/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.analytics.model.CreatePrivateAccessChannelDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePrivateAccessChannelRequest
extends BmcRequest<CreatePrivateAccessChannelDetails> {
    private String analyticsInstanceId;
    private CreatePrivateAccessChannelDetails createPrivateAccessChannelDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public CreatePrivateAccessChannelDetails getCreatePrivateAccessChannelDetails() {
        return this.createPrivateAccessChannelDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreatePrivateAccessChannelDetails getBody$() {
        return this.createPrivateAccessChannelDetails;
    }

    public Builder toBuilder() {
        return new Builder().analyticsInstanceId(this.analyticsInstanceId).createPrivateAccessChannelDetails(this.createPrivateAccessChannelDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",analyticsInstanceId=").append(String.valueOf(this.analyticsInstanceId));
        sb.append(",createPrivateAccessChannelDetails=").append(String.valueOf((Object)this.createPrivateAccessChannelDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePrivateAccessChannelRequest)) {
            return false;
        }
        CreatePrivateAccessChannelRequest other = (CreatePrivateAccessChannelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.analyticsInstanceId, other.analyticsInstanceId) && Objects.equals((Object)this.createPrivateAccessChannelDetails, (Object)other.createPrivateAccessChannelDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.analyticsInstanceId == null ? 43 : this.analyticsInstanceId.hashCode());
        result = result * 59 + (this.createPrivateAccessChannelDetails == null ? 43 : this.createPrivateAccessChannelDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePrivateAccessChannelRequest, CreatePrivateAccessChannelDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String analyticsInstanceId = null;
        private CreatePrivateAccessChannelDetails createPrivateAccessChannelDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder createPrivateAccessChannelDetails(CreatePrivateAccessChannelDetails createPrivateAccessChannelDetails) {
            this.createPrivateAccessChannelDetails = createPrivateAccessChannelDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePrivateAccessChannelRequest o) {
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.createPrivateAccessChannelDetails(o.getCreatePrivateAccessChannelDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePrivateAccessChannelRequest build() {
            CreatePrivateAccessChannelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePrivateAccessChannelDetails body) {
            this.createPrivateAccessChannelDetails(body);
            return this;
        }

        public CreatePrivateAccessChannelRequest buildWithoutInvocationCallback() {
            CreatePrivateAccessChannelRequest request = new CreatePrivateAccessChannelRequest();
            request.analyticsInstanceId = this.analyticsInstanceId;
            request.createPrivateAccessChannelDetails = this.createPrivateAccessChannelDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

