/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.analytics.model.AnalyticsInstanceLifecycleState;
import com.oracle.bmc.analytics.model.Capacity;
import com.oracle.bmc.analytics.model.FeatureSet;
import com.oracle.bmc.analytics.model.LicenseType;
import com.oracle.bmc.analytics.model.NetworkEndpointDetails;
import com.oracle.bmc.analytics.model.PrivateAccessChannel;
import com.oracle.bmc.analytics.model.VanityUrlDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AnalyticsInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final AnalyticsInstanceLifecycleState lifecycleState;
    @JsonProperty(value="featureSet")
    private final FeatureSet featureSet;
    @JsonProperty(value="capacity")
    private final Capacity capacity;
    @JsonProperty(value="licenseType")
    private final LicenseType licenseType;
    @JsonProperty(value="emailNotification")
    private final String emailNotification;
    @JsonProperty(value="networkEndpointDetails")
    private final NetworkEndpointDetails networkEndpointDetails;
    @JsonProperty(value="privateAccessChannels")
    private final Map<String, PrivateAccessChannel> privateAccessChannels;
    @JsonProperty(value="vanityUrlDetails")
    private final Map<String, VanityUrlDetails> vanityUrlDetails;
    @JsonProperty(value="serviceUrl")
    private final String serviceUrl;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "description", "compartmentId", "lifecycleState", "featureSet", "capacity", "licenseType", "emailNotification", "networkEndpointDetails", "privateAccessChannels", "vanityUrlDetails", "serviceUrl", "definedTags", "freeformTags", "kmsKeyId", "timeCreated", "timeUpdated"})
    public AnalyticsInstance(String id, String name, String description, String compartmentId, AnalyticsInstanceLifecycleState lifecycleState, FeatureSet featureSet, Capacity capacity, LicenseType licenseType, String emailNotification, NetworkEndpointDetails networkEndpointDetails, Map<String, PrivateAccessChannel> privateAccessChannels, Map<String, VanityUrlDetails> vanityUrlDetails, String serviceUrl, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, String kmsKeyId, Date timeCreated, Date timeUpdated) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.featureSet = featureSet;
        this.capacity = capacity;
        this.licenseType = licenseType;
        this.emailNotification = emailNotification;
        this.networkEndpointDetails = networkEndpointDetails;
        this.privateAccessChannels = privateAccessChannels;
        this.vanityUrlDetails = vanityUrlDetails;
        this.serviceUrl = serviceUrl;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
        this.kmsKeyId = kmsKeyId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public AnalyticsInstanceLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getEmailNotification() {
        return this.emailNotification;
    }

    public NetworkEndpointDetails getNetworkEndpointDetails() {
        return this.networkEndpointDetails;
    }

    public Map<String, PrivateAccessChannel> getPrivateAccessChannels() {
        return this.privateAccessChannels;
    }

    public Map<String, VanityUrlDetails> getVanityUrlDetails() {
        return this.vanityUrlDetails;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalyticsInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", featureSet=").append(String.valueOf((Object)this.featureSet));
        sb.append(", capacity=").append(String.valueOf((Object)this.capacity));
        sb.append(", licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(", emailNotification=").append(String.valueOf(this.emailNotification));
        sb.append(", networkEndpointDetails=").append(String.valueOf((Object)this.networkEndpointDetails));
        sb.append(", privateAccessChannels=").append(String.valueOf(this.privateAccessChannels));
        sb.append(", vanityUrlDetails=").append(String.valueOf(this.vanityUrlDetails));
        sb.append(", serviceUrl=").append(String.valueOf(this.serviceUrl));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyticsInstance)) {
            return false;
        }
        AnalyticsInstance other = (AnalyticsInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.featureSet, (Object)other.featureSet) && Objects.equals((Object)this.capacity, (Object)other.capacity) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals(this.emailNotification, other.emailNotification) && Objects.equals((Object)this.networkEndpointDetails, (Object)other.networkEndpointDetails) && Objects.equals(this.privateAccessChannels, other.privateAccessChannels) && Objects.equals(this.vanityUrlDetails, other.vanityUrlDetails) && Objects.equals(this.serviceUrl, other.serviceUrl) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.featureSet == null ? 43 : this.featureSet.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.emailNotification == null ? 43 : this.emailNotification.hashCode());
        result = result * 59 + (this.networkEndpointDetails == null ? 43 : this.networkEndpointDetails.hashCode());
        result = result * 59 + (this.privateAccessChannels == null ? 43 : this.privateAccessChannels.hashCode());
        result = result * 59 + (this.vanityUrlDetails == null ? 43 : this.vanityUrlDetails.hashCode());
        result = result * 59 + (this.serviceUrl == null ? 43 : this.serviceUrl.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private AnalyticsInstanceLifecycleState lifecycleState;
        @JsonProperty(value="featureSet")
        private FeatureSet featureSet;
        @JsonProperty(value="capacity")
        private Capacity capacity;
        @JsonProperty(value="licenseType")
        private LicenseType licenseType;
        @JsonProperty(value="emailNotification")
        private String emailNotification;
        @JsonProperty(value="networkEndpointDetails")
        private NetworkEndpointDetails networkEndpointDetails;
        @JsonProperty(value="privateAccessChannels")
        private Map<String, PrivateAccessChannel> privateAccessChannels;
        @JsonProperty(value="vanityUrlDetails")
        private Map<String, VanityUrlDetails> vanityUrlDetails;
        @JsonProperty(value="serviceUrl")
        private String serviceUrl;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(AnalyticsInstanceLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder featureSet(FeatureSet featureSet) {
            this.featureSet = featureSet;
            this.__explicitlySet__.add("featureSet");
            return this;
        }

        public Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            this.__explicitlySet__.add("licenseType");
            return this;
        }

        public Builder emailNotification(String emailNotification) {
            this.emailNotification = emailNotification;
            this.__explicitlySet__.add("emailNotification");
            return this;
        }

        public Builder networkEndpointDetails(NetworkEndpointDetails networkEndpointDetails) {
            this.networkEndpointDetails = networkEndpointDetails;
            this.__explicitlySet__.add("networkEndpointDetails");
            return this;
        }

        public Builder privateAccessChannels(Map<String, PrivateAccessChannel> privateAccessChannels) {
            this.privateAccessChannels = privateAccessChannels;
            this.__explicitlySet__.add("privateAccessChannels");
            return this;
        }

        public Builder vanityUrlDetails(Map<String, VanityUrlDetails> vanityUrlDetails) {
            this.vanityUrlDetails = vanityUrlDetails;
            this.__explicitlySet__.add("vanityUrlDetails");
            return this;
        }

        public Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            this.__explicitlySet__.add("serviceUrl");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public AnalyticsInstance build() {
            AnalyticsInstance model = new AnalyticsInstance(this.id, this.name, this.description, this.compartmentId, this.lifecycleState, this.featureSet, this.capacity, this.licenseType, this.emailNotification, this.networkEndpointDetails, this.privateAccessChannels, this.vanityUrlDetails, this.serviceUrl, this.definedTags, this.freeformTags, this.kmsKeyId, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AnalyticsInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("featureSet")) {
                this.featureSet(model.getFeatureSet());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("licenseType")) {
                this.licenseType(model.getLicenseType());
            }
            if (model.wasPropertyExplicitlySet("emailNotification")) {
                this.emailNotification(model.getEmailNotification());
            }
            if (model.wasPropertyExplicitlySet("networkEndpointDetails")) {
                this.networkEndpointDetails(model.getNetworkEndpointDetails());
            }
            if (model.wasPropertyExplicitlySet("privateAccessChannels")) {
                this.privateAccessChannels(model.getPrivateAccessChannels());
            }
            if (model.wasPropertyExplicitlySet("vanityUrlDetails")) {
                this.vanityUrlDetails(model.getVanityUrlDetails());
            }
            if (model.wasPropertyExplicitlySet("serviceUrl")) {
                this.serviceUrl(model.getServiceUrl());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

