/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.analytics.AnalyticsAsync;
import com.oracle.bmc.analytics.model.AnalyticsInstance;
import com.oracle.bmc.analytics.model.AnalyticsInstanceSummary;
import com.oracle.bmc.analytics.model.PrivateAccessChannel;
import com.oracle.bmc.analytics.model.WorkRequest;
import com.oracle.bmc.analytics.model.WorkRequestError;
import com.oracle.bmc.analytics.model.WorkRequestLog;
import com.oracle.bmc.analytics.model.WorkRequestSummary;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceCompartmentRequest;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceNetworkEndpointRequest;
import com.oracle.bmc.analytics.requests.CreateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.CreatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.CreateVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.DeletePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.DeleteVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.analytics.requests.GetAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.GetPrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.analytics.requests.ListAnalyticsInstancesRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.analytics.requests.ScaleAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.SetKmsKeyRequest;
import com.oracle.bmc.analytics.requests.StartAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StopAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.UpdateVanityUrlRequest;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceCompartmentResponse;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceNetworkEndpointResponse;
import com.oracle.bmc.analytics.responses.CreateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.CreatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.CreateVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.DeletePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.DeleteVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.analytics.responses.GetAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.GetPrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.analytics.responses.ListAnalyticsInstancesResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.analytics.responses.ScaleAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.SetKmsKeyResponse;
import com.oracle.bmc.analytics.responses.StartAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StopAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.UpdateVanityUrlResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsAsyncClient
extends BaseAsyncClient
implements AnalyticsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://analytics.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsAsyncClient.class);

    private AnalyticsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeAnalyticsInstanceCompartmentResponse> changeAnalyticsInstanceCompartment(ChangeAnalyticsInstanceCompartmentRequest request, AsyncHandler<ChangeAnalyticsInstanceCompartmentRequest, ChangeAnalyticsInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCompartmentDetails(), "changeCompartmentDetails is required");
        return this.clientCall(request, ChangeAnalyticsInstanceCompartmentResponse::builder).logger(LOG, "changeAnalyticsInstanceCompartment").serviceDetails("Analytics", "ChangeAnalyticsInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/ChangeAnalyticsInstanceCompartment").method(Method.POST).requestBuilder(ChangeAnalyticsInstanceCompartmentRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAnalyticsInstanceCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeAnalyticsInstanceCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAnalyticsInstanceNetworkEndpointResponse> changeAnalyticsInstanceNetworkEndpoint(ChangeAnalyticsInstanceNetworkEndpointRequest request, AsyncHandler<ChangeAnalyticsInstanceNetworkEndpointRequest, ChangeAnalyticsInstanceNetworkEndpointResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAnalyticsInstanceNetworkEndpointDetails(), "changeAnalyticsInstanceNetworkEndpointDetails is required");
        return this.clientCall(request, ChangeAnalyticsInstanceNetworkEndpointResponse::builder).logger(LOG, "changeAnalyticsInstanceNetworkEndpoint").serviceDetails("Analytics", "ChangeAnalyticsInstanceNetworkEndpoint", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/ChangeAnalyticsInstanceNetworkEndpoint").method(Method.POST).requestBuilder(ChangeAnalyticsInstanceNetworkEndpointRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("changeNetworkEndpoint").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAnalyticsInstanceNetworkEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeAnalyticsInstanceNetworkEndpointResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAnalyticsInstanceResponse> createAnalyticsInstance(CreateAnalyticsInstanceRequest request, AsyncHandler<CreateAnalyticsInstanceRequest, CreateAnalyticsInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateAnalyticsInstanceDetails(), "createAnalyticsInstanceDetails is required");
        return this.clientCall(request, CreateAnalyticsInstanceResponse::builder).logger(LOG, "createAnalyticsInstance").serviceDetails("Analytics", "CreateAnalyticsInstance", "").method(Method.POST).requestBuilder(CreateAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AnalyticsInstance.class, CreateAnalyticsInstanceResponse.Builder::analyticsInstance).handleResponseHeaderString("etag", CreateAnalyticsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAnalyticsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateAnalyticsInstanceResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreatePrivateAccessChannelResponse> createPrivateAccessChannel(CreatePrivateAccessChannelRequest request, AsyncHandler<CreatePrivateAccessChannelRequest, CreatePrivateAccessChannelResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePrivateAccessChannelDetails(), "createPrivateAccessChannelDetails is required");
        return this.clientCall(request, CreatePrivateAccessChannelResponse::builder).logger(LOG, "createPrivateAccessChannel").serviceDetails("Analytics", "CreatePrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/CreatePrivateAccessChannel").method(Method.POST).requestBuilder(CreatePrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreatePrivateAccessChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePrivateAccessChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateVanityUrlResponse> createVanityUrl(CreateVanityUrlRequest request, AsyncHandler<CreateVanityUrlRequest, CreateVanityUrlResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateVanityUrlDetails(), "createVanityUrlDetails is required");
        return this.clientCall(request, CreateVanityUrlResponse::builder).logger(LOG, "createVanityUrl").serviceDetails("Analytics", "CreateVanityUrl", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/CreateVanityUrl").method(Method.POST).requestBuilder(CreateVanityUrlRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("vanityUrls").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateVanityUrlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateVanityUrlResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAnalyticsInstanceResponse> deleteAnalyticsInstance(DeleteAnalyticsInstanceRequest request, AsyncHandler<DeleteAnalyticsInstanceRequest, DeleteAnalyticsInstanceResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAnalyticsInstanceResponse::builder).logger(LOG, "deleteAnalyticsInstance").serviceDetails("Analytics", "DeleteAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/DeleteAnalyticsInstance").method(Method.DELETE).requestBuilder(DeleteAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteAnalyticsInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePrivateAccessChannelResponse> deletePrivateAccessChannel(DeletePrivateAccessChannelRequest request, AsyncHandler<DeletePrivateAccessChannelRequest, DeletePrivateAccessChannelResponse> handler) {
        Validate.notBlank((String)request.getPrivateAccessChannelKey(), (String)"privateAccessChannelKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePrivateAccessChannelResponse::builder).logger(LOG, "deletePrivateAccessChannel").serviceDetails("Analytics", "DeletePrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/DeletePrivateAccessChannel").method(Method.DELETE).requestBuilder(DeletePrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").appendPathParam(request.getPrivateAccessChannelKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeletePrivateAccessChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeletePrivateAccessChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVanityUrlResponse> deleteVanityUrl(DeleteVanityUrlRequest request, AsyncHandler<DeleteVanityUrlRequest, DeleteVanityUrlResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVanityUrlKey(), (String)"vanityUrlKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVanityUrlResponse::builder).logger(LOG, "deleteVanityUrl").serviceDetails("Analytics", "DeleteVanityUrl", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/DeleteVanityUrl").method(Method.DELETE).requestBuilder(DeleteVanityUrlRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("vanityUrls").appendPathParam(request.getVanityUrlKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteVanityUrlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteVanityUrlResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("Analytics", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAnalyticsInstanceResponse> getAnalyticsInstance(GetAnalyticsInstanceRequest request, AsyncHandler<GetAnalyticsInstanceRequest, GetAnalyticsInstanceResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAnalyticsInstanceResponse::builder).logger(LOG, "getAnalyticsInstance").serviceDetails("Analytics", "GetAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/GetAnalyticsInstance").method(Method.GET).requestBuilder(GetAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnalyticsInstance.class, GetAnalyticsInstanceResponse.Builder::analyticsInstance).handleResponseHeaderString("etag", GetAnalyticsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAnalyticsInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateAccessChannelResponse> getPrivateAccessChannel(GetPrivateAccessChannelRequest request, AsyncHandler<GetPrivateAccessChannelRequest, GetPrivateAccessChannelResponse> handler) {
        Validate.notBlank((String)request.getPrivateAccessChannelKey(), (String)"privateAccessChannelKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPrivateAccessChannelResponse::builder).logger(LOG, "getPrivateAccessChannel").serviceDetails("Analytics", "GetPrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/GetPrivateAccessChannel").method(Method.GET).requestBuilder(GetPrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").appendPathParam(request.getPrivateAccessChannelKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PrivateAccessChannel.class, GetPrivateAccessChannelResponse.Builder::privateAccessChannel).handleResponseHeaderString("etag", GetPrivateAccessChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateAccessChannelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Analytics", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAnalyticsInstancesResponse> listAnalyticsInstances(ListAnalyticsInstancesRequest request, AsyncHandler<ListAnalyticsInstancesRequest, ListAnalyticsInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAnalyticsInstancesResponse::builder).logger(LOG, "listAnalyticsInstances").serviceDetails("Analytics", "ListAnalyticsInstances", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstanceSummary/ListAnalyticsInstances").method(Method.GET).requestBuilder(ListAnalyticsInstancesRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("capacityType", (BmcEnum)request.getCapacityType()).appendEnumQueryParam("featureSet", (BmcEnum)request.getFeatureSet()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AnalyticsInstanceSummary.class, ListAnalyticsInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAnalyticsInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAnalyticsInstancesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Analytics", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Analytics", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLog.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Analytics", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("resourceType", (BmcEnum)request.getResourceType()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScaleAnalyticsInstanceResponse> scaleAnalyticsInstance(ScaleAnalyticsInstanceRequest request, AsyncHandler<ScaleAnalyticsInstanceRequest, ScaleAnalyticsInstanceResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScaleAnalyticsInstanceDetails(), "scaleAnalyticsInstanceDetails is required");
        return this.clientCall(request, ScaleAnalyticsInstanceResponse::builder).logger(LOG, "scaleAnalyticsInstance").serviceDetails("Analytics", "ScaleAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/ScaleAnalyticsInstance").method(Method.POST).requestBuilder(ScaleAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("scale").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ScaleAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ScaleAnalyticsInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<SetKmsKeyResponse> setKmsKey(SetKmsKeyRequest request, AsyncHandler<SetKmsKeyRequest, SetKmsKeyResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSetKmsKeyDetails(), "setKmsKeyDetails is required");
        return this.clientCall(request, SetKmsKeyResponse::builder).logger(LOG, "setKmsKey").serviceDetails("Analytics", "SetKmsKey", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/SetKmsKey").method(Method.POST).requestBuilder(SetKmsKeyRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("setKmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", SetKmsKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", SetKmsKeyResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartAnalyticsInstanceResponse> startAnalyticsInstance(StartAnalyticsInstanceRequest request, AsyncHandler<StartAnalyticsInstanceRequest, StartAnalyticsInstanceResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartAnalyticsInstanceResponse::builder).logger(LOG, "startAnalyticsInstance").serviceDetails("Analytics", "StartAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/StartAnalyticsInstance").method(Method.POST).requestBuilder(StartAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartAnalyticsInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopAnalyticsInstanceResponse> stopAnalyticsInstance(StopAnalyticsInstanceRequest request, AsyncHandler<StopAnalyticsInstanceRequest, StopAnalyticsInstanceResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopAnalyticsInstanceResponse::builder).logger(LOG, "stopAnalyticsInstance").serviceDetails("Analytics", "StopAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/StopAnalyticsInstance").method(Method.POST).requestBuilder(StopAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopAnalyticsInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAnalyticsInstanceResponse> updateAnalyticsInstance(UpdateAnalyticsInstanceRequest request, AsyncHandler<UpdateAnalyticsInstanceRequest, UpdateAnalyticsInstanceResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAnalyticsInstanceDetails(), "updateAnalyticsInstanceDetails is required");
        return this.clientCall(request, UpdateAnalyticsInstanceResponse::builder).logger(LOG, "updateAnalyticsInstance").serviceDetails("Analytics", "UpdateAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/UpdateAnalyticsInstance").method(Method.PUT).requestBuilder(UpdateAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyticsInstance.class, UpdateAnalyticsInstanceResponse.Builder::analyticsInstance).handleResponseHeaderString("etag", UpdateAnalyticsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAnalyticsInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePrivateAccessChannelResponse> updatePrivateAccessChannel(UpdatePrivateAccessChannelRequest request, AsyncHandler<UpdatePrivateAccessChannelRequest, UpdatePrivateAccessChannelResponse> handler) {
        Validate.notBlank((String)request.getPrivateAccessChannelKey(), (String)"privateAccessChannelKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateAccessChannelDetails(), "updatePrivateAccessChannelDetails is required");
        return this.clientCall(request, UpdatePrivateAccessChannelResponse::builder).logger(LOG, "updatePrivateAccessChannel").serviceDetails("Analytics", "UpdatePrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/UpdatePrivateAccessChannel").method(Method.PUT).requestBuilder(UpdatePrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").appendPathParam(request.getPrivateAccessChannelKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePrivateAccessChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePrivateAccessChannelResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVanityUrlResponse> updateVanityUrl(UpdateVanityUrlRequest request, AsyncHandler<UpdateVanityUrlRequest, UpdateVanityUrlResponse> handler) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVanityUrlKey(), (String)"vanityUrlKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVanityUrlDetails(), "updateVanityUrlDetails is required");
        return this.clientCall(request, UpdateVanityUrlResponse::builder).logger(LOG, "updateVanityUrl").serviceDetails("Analytics", "UpdateVanityUrl", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/UpdateVanityUrl").method(Method.PUT).requestBuilder(UpdateVanityUrlRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("vanityUrls").appendPathParam(request.getVanityUrlKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateVanityUrlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateVanityUrlResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public AnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AnalyticsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AnalyticsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnalyticsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AnalyticsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AnalyticsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AnalyticsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AnalyticsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AnalyticsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnalyticsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnalyticsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AnalyticsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AnalyticsAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

