/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.BoundingPolygon;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Cell
extends ExplicitlySetBmcModel {
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="rowIndex")
    private final Integer rowIndex;
    @JsonProperty(value="columnIndex")
    private final Integer columnIndex;
    @JsonProperty(value="confidence")
    private final Float confidence;
    @JsonProperty(value="boundingPolygon")
    private final BoundingPolygon boundingPolygon;
    @JsonProperty(value="wordIndexes")
    private final List<Integer> wordIndexes;

    @Deprecated
    @ConstructorProperties(value={"text", "rowIndex", "columnIndex", "confidence", "boundingPolygon", "wordIndexes"})
    public Cell(String text, Integer rowIndex, Integer columnIndex, Float confidence, BoundingPolygon boundingPolygon, List<Integer> wordIndexes) {
        this.text = text;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.confidence = confidence;
        this.boundingPolygon = boundingPolygon;
        this.wordIndexes = wordIndexes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getText() {
        return this.text;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public BoundingPolygon getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public List<Integer> getWordIndexes() {
        return this.wordIndexes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cell(");
        sb.append("super=").append(super.toString());
        sb.append("text=").append(String.valueOf(this.text));
        sb.append(", rowIndex=").append(String.valueOf(this.rowIndex));
        sb.append(", columnIndex=").append(String.valueOf(this.columnIndex));
        sb.append(", confidence=").append(String.valueOf(this.confidence));
        sb.append(", boundingPolygon=").append(String.valueOf((Object)this.boundingPolygon));
        sb.append(", wordIndexes=").append(String.valueOf(this.wordIndexes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)((Object)o);
        return Objects.equals(this.text, other.text) && Objects.equals(this.rowIndex, other.rowIndex) && Objects.equals(this.columnIndex, other.columnIndex) && Objects.equals(this.confidence, other.confidence) && Objects.equals((Object)this.boundingPolygon, (Object)other.boundingPolygon) && Objects.equals(this.wordIndexes, other.wordIndexes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.text == null ? 43 : this.text.hashCode());
        result = result * 59 + (this.rowIndex == null ? 43 : this.rowIndex.hashCode());
        result = result * 59 + (this.columnIndex == null ? 43 : this.columnIndex.hashCode());
        result = result * 59 + (this.confidence == null ? 43 : this.confidence.hashCode());
        result = result * 59 + (this.boundingPolygon == null ? 43 : this.boundingPolygon.hashCode());
        result = result * 59 + (this.wordIndexes == null ? 43 : this.wordIndexes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="rowIndex")
        private Integer rowIndex;
        @JsonProperty(value="columnIndex")
        private Integer columnIndex;
        @JsonProperty(value="confidence")
        private Float confidence;
        @JsonProperty(value="boundingPolygon")
        private BoundingPolygon boundingPolygon;
        @JsonProperty(value="wordIndexes")
        private List<Integer> wordIndexes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder text(String text) {
            this.text = text;
            this.__explicitlySet__.add("text");
            return this;
        }

        public Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            this.__explicitlySet__.add("rowIndex");
            return this;
        }

        public Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            this.__explicitlySet__.add("columnIndex");
            return this;
        }

        public Builder confidence(Float confidence) {
            this.confidence = confidence;
            this.__explicitlySet__.add("confidence");
            return this;
        }

        public Builder boundingPolygon(BoundingPolygon boundingPolygon) {
            this.boundingPolygon = boundingPolygon;
            this.__explicitlySet__.add("boundingPolygon");
            return this;
        }

        public Builder wordIndexes(List<Integer> wordIndexes) {
            this.wordIndexes = wordIndexes;
            this.__explicitlySet__.add("wordIndexes");
            return this;
        }

        public Cell build() {
            Cell model = new Cell(this.text, this.rowIndex, this.columnIndex, this.confidence, this.boundingPolygon, this.wordIndexes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Cell model) {
            if (model.wasPropertyExplicitlySet("text")) {
                this.text(model.getText());
            }
            if (model.wasPropertyExplicitlySet("rowIndex")) {
                this.rowIndex(model.getRowIndex());
            }
            if (model.wasPropertyExplicitlySet("columnIndex")) {
                this.columnIndex(model.getColumnIndex());
            }
            if (model.wasPropertyExplicitlySet("confidence")) {
                this.confidence(model.getConfidence());
            }
            if (model.wasPropertyExplicitlySet("boundingPolygon")) {
                this.boundingPolygon(model.getBoundingPolygon());
            }
            if (model.wasPropertyExplicitlySet("wordIndexes")) {
                this.wordIndexes(model.getWordIndexes());
            }
            return this;
        }
    }
}

