/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision;

import com.oracle.bmc.aivision.AIServiceVision;
import com.oracle.bmc.aivision.model.DocumentJob;
import com.oracle.bmc.aivision.model.ImageJob;
import com.oracle.bmc.aivision.model.Model;
import com.oracle.bmc.aivision.model.Project;
import com.oracle.bmc.aivision.requests.GetDocumentJobRequest;
import com.oracle.bmc.aivision.requests.GetImageJobRequest;
import com.oracle.bmc.aivision.requests.GetModelRequest;
import com.oracle.bmc.aivision.requests.GetProjectRequest;
import com.oracle.bmc.aivision.requests.GetWorkRequestRequest;
import com.oracle.bmc.aivision.responses.GetDocumentJobResponse;
import com.oracle.bmc.aivision.responses.GetImageJobResponse;
import com.oracle.bmc.aivision.responses.GetModelResponse;
import com.oracle.bmc.aivision.responses.GetProjectResponse;
import com.oracle.bmc.aivision.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AIServiceVisionWaiters {
    private final ExecutorService executorService;
    private final AIServiceVision client;

    public AIServiceVisionWaiters(ExecutorService executorService, AIServiceVision client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDocumentJobRequest, GetDocumentJobResponse> forDocumentJob(GetDocumentJobRequest request, DocumentJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDocumentJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDocumentJobRequest, GetDocumentJobResponse> forDocumentJob(GetDocumentJobRequest request, DocumentJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDocumentJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDocumentJobRequest, GetDocumentJobResponse> forDocumentJob(GetDocumentJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DocumentJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDocumentJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDocumentJobRequest, GetDocumentJobResponse> forDocumentJob(BmcGenericWaiter waiter, GetDocumentJobRequest request, DocumentJob.LifecycleState ... targetStates) {
        final HashSet<DocumentJob.LifecycleState> targetStatesSet = new HashSet<DocumentJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDocumentJobRequest, GetDocumentJobResponse>(){

            @Override
            public GetDocumentJobResponse apply(GetDocumentJobRequest request) {
                return AIServiceVisionWaiters.this.client.getDocumentJob(request);
            }
        }, (Predicate)new Predicate<GetDocumentJobResponse>(){

            @Override
            public boolean test(GetDocumentJobResponse response) {
                return targetStatesSet.contains((Object)response.getDocumentJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetImageJobRequest, GetImageJobResponse> forImageJob(GetImageJobRequest request, ImageJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forImageJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetImageJobRequest, GetImageJobResponse> forImageJob(GetImageJobRequest request, ImageJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forImageJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetImageJobRequest, GetImageJobResponse> forImageJob(GetImageJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ImageJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forImageJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetImageJobRequest, GetImageJobResponse> forImageJob(BmcGenericWaiter waiter, GetImageJobRequest request, ImageJob.LifecycleState ... targetStates) {
        final HashSet<ImageJob.LifecycleState> targetStatesSet = new HashSet<ImageJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetImageJobRequest, GetImageJobResponse>(){

            @Override
            public GetImageJobResponse apply(GetImageJobRequest request) {
                return AIServiceVisionWaiters.this.client.getImageJob(request);
            }
        }, (Predicate)new Predicate<GetImageJobResponse>(){

            @Override
            public boolean test(GetImageJobResponse response) {
                return targetStatesSet.contains((Object)response.getImageJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelRequest, GetModelResponse> forModel(BmcGenericWaiter waiter, GetModelRequest request, Model.LifecycleState ... targetStates) {
        final HashSet<Model.LifecycleState> targetStatesSet = new HashSet<Model.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelRequest, GetModelResponse>(){

            @Override
            public GetModelResponse apply(GetModelRequest request) {
                return AIServiceVisionWaiters.this.client.getModel(request);
            }
        }, (Predicate)new Predicate<GetModelResponse>(){

            @Override
            public boolean test(GetModelResponse response) {
                return targetStatesSet.contains((Object)response.getModel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Model.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProjectRequest, GetProjectResponse> forProject(BmcGenericWaiter waiter, GetProjectRequest request, Project.LifecycleState ... targetStates) {
        final HashSet<Project.LifecycleState> targetStatesSet = new HashSet<Project.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProjectRequest, GetProjectResponse>(){

            @Override
            public GetProjectResponse apply(GetProjectRequest request) {
                return AIServiceVisionWaiters.this.client.getProject(request);
            }
        }, (Predicate)new Predicate<GetProjectResponse>(){

            @Override
            public boolean test(GetProjectResponse response) {
                return targetStatesSet.contains((Object)response.getProject().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Project.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return AIServiceVisionWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

