/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTranscriptionTaskRequest
extends BmcRequest<Void> {
    private String transcriptionJobId;
    private String transcriptionTaskId;
    private String opcRequestId;

    public String getTranscriptionJobId() {
        return this.transcriptionJobId;
    }

    public String getTranscriptionTaskId() {
        return this.transcriptionTaskId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().transcriptionJobId(this.transcriptionJobId).transcriptionTaskId(this.transcriptionTaskId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",transcriptionJobId=").append(String.valueOf(this.transcriptionJobId));
        sb.append(",transcriptionTaskId=").append(String.valueOf(this.transcriptionTaskId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTranscriptionTaskRequest)) {
            return false;
        }
        GetTranscriptionTaskRequest other = (GetTranscriptionTaskRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.transcriptionJobId, other.transcriptionJobId) && Objects.equals(this.transcriptionTaskId, other.transcriptionTaskId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.transcriptionJobId == null ? 43 : this.transcriptionJobId.hashCode());
        result = result * 59 + (this.transcriptionTaskId == null ? 43 : this.transcriptionTaskId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTranscriptionTaskRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String transcriptionJobId = null;
        private String transcriptionTaskId = null;
        private String opcRequestId = null;

        public Builder transcriptionJobId(String transcriptionJobId) {
            this.transcriptionJobId = transcriptionJobId;
            return this;
        }

        public Builder transcriptionTaskId(String transcriptionTaskId) {
            this.transcriptionTaskId = transcriptionTaskId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTranscriptionTaskRequest o) {
            this.transcriptionJobId(o.getTranscriptionJobId());
            this.transcriptionTaskId(o.getTranscriptionTaskId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTranscriptionTaskRequest build() {
            GetTranscriptionTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTranscriptionTaskRequest buildWithoutInvocationCallback() {
            GetTranscriptionTaskRequest request = new GetTranscriptionTaskRequest();
            request.transcriptionJobId = this.transcriptionJobId;
            request.transcriptionTaskId = this.transcriptionTaskId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

