/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TranscriptionModelDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="domain")
    private final Domain domain;
    @JsonProperty(value="languageCode")
    private final LanguageCode languageCode;

    @Deprecated
    @ConstructorProperties(value={"domain", "languageCode"})
    public TranscriptionModelDetails(Domain domain, LanguageCode languageCode) {
        this.domain = domain;
        this.languageCode = languageCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Domain getDomain() {
        return this.domain;
    }

    public LanguageCode getLanguageCode() {
        return this.languageCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TranscriptionModelDetails(");
        sb.append("super=").append(super.toString());
        sb.append("domain=").append(String.valueOf((Object)this.domain));
        sb.append(", languageCode=").append(String.valueOf((Object)this.languageCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranscriptionModelDetails)) {
            return false;
        }
        TranscriptionModelDetails other = (TranscriptionModelDetails)((Object)o);
        return Objects.equals((Object)this.domain, (Object)other.domain) && Objects.equals((Object)this.languageCode, (Object)other.languageCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LanguageCode implements BmcEnum
    {
        EnUs("en-US"),
        EsEs("es-ES"),
        PtBr("pt-BR"),
        EnGb("en-GB"),
        EnAu("en-AU"),
        EnIn("en-IN"),
        HiIn("hi-IN"),
        FrFr("fr-FR"),
        DeDe("de-DE"),
        ItIt("it-IT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LanguageCode> map;

        private LanguageCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LanguageCode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LanguageCode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LanguageCode.class);
            map = new HashMap<String, LanguageCode>();
            for (LanguageCode v : LanguageCode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Domain implements BmcEnum
    {
        Generic("GENERIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Domain> map;

        private Domain(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Domain create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Domain', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Domain.class);
            map = new HashMap<String, Domain>();
            for (Domain v : Domain.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="domain")
        private Domain domain;
        @JsonProperty(value="languageCode")
        private LanguageCode languageCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder domain(Domain domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder languageCode(LanguageCode languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public TranscriptionModelDetails build() {
            TranscriptionModelDetails model = new TranscriptionModelDetails(this.domain, this.languageCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TranscriptionModelDetails model) {
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            return this;
        }
    }
}

