/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ObjectLocation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespaceName")
    private final String namespaceName;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="objectNames")
    private final List<String> objectNames;

    @Deprecated
    @ConstructorProperties(value={"namespaceName", "bucketName", "objectNames"})
    public ObjectLocation(String namespaceName, String bucketName, List<String> objectNames) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectNames = objectNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<String> getObjectNames() {
        return this.objectNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectLocation(");
        sb.append("super=").append(super.toString());
        sb.append("namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", objectNames=").append(String.valueOf(this.objectNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectLocation)) {
            return false;
        }
        ObjectLocation other = (ObjectLocation)((Object)o);
        return Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectNames, other.objectNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectNames == null ? 43 : this.objectNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespaceName")
        private String namespaceName;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="objectNames")
        private List<String> objectNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            this.__explicitlySet__.add("namespaceName");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder objectNames(List<String> objectNames) {
            this.objectNames = objectNames;
            this.__explicitlySet__.add("objectNames");
            return this;
        }

        public ObjectLocation build() {
            ObjectLocation model = new ObjectLocation(this.namespaceName, this.bucketName, this.objectNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectLocation model) {
            if (model.wasPropertyExplicitlySet("namespaceName")) {
                this.namespaceName(model.getNamespaceName());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("objectNames")) {
                this.objectNames(model.getObjectNames());
            }
            return this;
        }
    }
}

