/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aispeech.model.InputLocation;
import com.oracle.bmc.aispeech.model.OutputLocation;
import com.oracle.bmc.aispeech.model.TranscriptionModelDetails;
import com.oracle.bmc.aispeech.model.TranscriptionNormalization;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateTranscriptionJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="additionalTranscriptionFormats")
    private final List<AdditionalTranscriptionFormats> additionalTranscriptionFormats;
    @JsonProperty(value="modelDetails")
    private final TranscriptionModelDetails modelDetails;
    @JsonProperty(value="normalization")
    private final TranscriptionNormalization normalization;
    @JsonProperty(value="inputLocation")
    private final InputLocation inputLocation;
    @JsonProperty(value="outputLocation")
    private final OutputLocation outputLocation;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "description", "additionalTranscriptionFormats", "modelDetails", "normalization", "inputLocation", "outputLocation", "freeformTags", "definedTags"})
    public CreateTranscriptionJobDetails(String displayName, String compartmentId, String description, List<AdditionalTranscriptionFormats> additionalTranscriptionFormats, TranscriptionModelDetails modelDetails, TranscriptionNormalization normalization, InputLocation inputLocation, OutputLocation outputLocation, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.description = description;
        this.additionalTranscriptionFormats = additionalTranscriptionFormats;
        this.modelDetails = modelDetails;
        this.normalization = normalization;
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AdditionalTranscriptionFormats> getAdditionalTranscriptionFormats() {
        return this.additionalTranscriptionFormats;
    }

    public TranscriptionModelDetails getModelDetails() {
        return this.modelDetails;
    }

    public TranscriptionNormalization getNormalization() {
        return this.normalization;
    }

    public InputLocation getInputLocation() {
        return this.inputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateTranscriptionJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", additionalTranscriptionFormats=").append(String.valueOf(this.additionalTranscriptionFormats));
        sb.append(", modelDetails=").append(String.valueOf((Object)this.modelDetails));
        sb.append(", normalization=").append(String.valueOf((Object)this.normalization));
        sb.append(", inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTranscriptionJobDetails)) {
            return false;
        }
        CreateTranscriptionJobDetails other = (CreateTranscriptionJobDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.additionalTranscriptionFormats, other.additionalTranscriptionFormats) && Objects.equals((Object)this.modelDetails, (Object)other.modelDetails) && Objects.equals((Object)this.normalization, (Object)other.normalization) && Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.additionalTranscriptionFormats == null ? 43 : this.additionalTranscriptionFormats.hashCode());
        result = result * 59 + (this.modelDetails == null ? 43 : this.modelDetails.hashCode());
        result = result * 59 + (this.normalization == null ? 43 : this.normalization.hashCode());
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AdditionalTranscriptionFormats implements BmcEnum
    {
        Srt("SRT");

        private final String value;
        private static Map<String, AdditionalTranscriptionFormats> map;

        private AdditionalTranscriptionFormats(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AdditionalTranscriptionFormats create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AdditionalTranscriptionFormats: " + key);
        }

        static {
            map = new HashMap<String, AdditionalTranscriptionFormats>();
            for (AdditionalTranscriptionFormats v : AdditionalTranscriptionFormats.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="additionalTranscriptionFormats")
        private List<AdditionalTranscriptionFormats> additionalTranscriptionFormats;
        @JsonProperty(value="modelDetails")
        private TranscriptionModelDetails modelDetails;
        @JsonProperty(value="normalization")
        private TranscriptionNormalization normalization;
        @JsonProperty(value="inputLocation")
        private InputLocation inputLocation;
        @JsonProperty(value="outputLocation")
        private OutputLocation outputLocation;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder additionalTranscriptionFormats(List<AdditionalTranscriptionFormats> additionalTranscriptionFormats) {
            this.additionalTranscriptionFormats = additionalTranscriptionFormats;
            this.__explicitlySet__.add("additionalTranscriptionFormats");
            return this;
        }

        public Builder modelDetails(TranscriptionModelDetails modelDetails) {
            this.modelDetails = modelDetails;
            this.__explicitlySet__.add("modelDetails");
            return this;
        }

        public Builder normalization(TranscriptionNormalization normalization) {
            this.normalization = normalization;
            this.__explicitlySet__.add("normalization");
            return this;
        }

        public Builder inputLocation(InputLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateTranscriptionJobDetails build() {
            CreateTranscriptionJobDetails model = new CreateTranscriptionJobDetails(this.displayName, this.compartmentId, this.description, this.additionalTranscriptionFormats, this.modelDetails, this.normalization, this.inputLocation, this.outputLocation, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateTranscriptionJobDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("additionalTranscriptionFormats")) {
                this.additionalTranscriptionFormats(model.getAdditionalTranscriptionFormats());
            }
            if (model.wasPropertyExplicitlySet("modelDetails")) {
                this.modelDetails(model.getModelDetails());
            }
            if (model.wasPropertyExplicitlySet("normalization")) {
                this.normalization(model.getNormalization());
            }
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

