/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AudioFormatDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="format")
    private final String format;
    @JsonProperty(value="numberOfChannels")
    private final Integer numberOfChannels;
    @JsonProperty(value="encoding")
    private final String encoding;
    @JsonProperty(value="sampleRateInHz")
    private final Integer sampleRateInHz;

    @Deprecated
    @ConstructorProperties(value={"format", "numberOfChannels", "encoding", "sampleRateInHz"})
    public AudioFormatDetails(String format, Integer numberOfChannels, String encoding, Integer sampleRateInHz) {
        this.format = format;
        this.numberOfChannels = numberOfChannels;
        this.encoding = encoding;
        this.sampleRateInHz = sampleRateInHz;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFormat() {
        return this.format;
    }

    public Integer getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Integer getSampleRateInHz() {
        return this.sampleRateInHz;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AudioFormatDetails(");
        sb.append("super=").append(super.toString());
        sb.append("format=").append(String.valueOf(this.format));
        sb.append(", numberOfChannels=").append(String.valueOf(this.numberOfChannels));
        sb.append(", encoding=").append(String.valueOf(this.encoding));
        sb.append(", sampleRateInHz=").append(String.valueOf(this.sampleRateInHz));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioFormatDetails)) {
            return false;
        }
        AudioFormatDetails other = (AudioFormatDetails)((Object)o);
        return Objects.equals(this.format, other.format) && Objects.equals(this.numberOfChannels, other.numberOfChannels) && Objects.equals(this.encoding, other.encoding) && Objects.equals(this.sampleRateInHz, other.sampleRateInHz) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.format == null ? 43 : this.format.hashCode());
        result = result * 59 + (this.numberOfChannels == null ? 43 : this.numberOfChannels.hashCode());
        result = result * 59 + (this.encoding == null ? 43 : this.encoding.hashCode());
        result = result * 59 + (this.sampleRateInHz == null ? 43 : this.sampleRateInHz.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="format")
        private String format;
        @JsonProperty(value="numberOfChannels")
        private Integer numberOfChannels;
        @JsonProperty(value="encoding")
        private String encoding;
        @JsonProperty(value="sampleRateInHz")
        private Integer sampleRateInHz;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder format(String format) {
            this.format = format;
            this.__explicitlySet__.add("format");
            return this;
        }

        public Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            this.__explicitlySet__.add("numberOfChannels");
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            this.__explicitlySet__.add("encoding");
            return this;
        }

        public Builder sampleRateInHz(Integer sampleRateInHz) {
            this.sampleRateInHz = sampleRateInHz;
            this.__explicitlySet__.add("sampleRateInHz");
            return this;
        }

        public AudioFormatDetails build() {
            AudioFormatDetails model = new AudioFormatDetails(this.format, this.numberOfChannels, this.encoding, this.sampleRateInHz);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AudioFormatDetails model) {
            if (model.wasPropertyExplicitlySet("format")) {
                this.format(model.getFormat());
            }
            if (model.wasPropertyExplicitlySet("numberOfChannels")) {
                this.numberOfChannels(model.getNumberOfChannels());
            }
            if (model.wasPropertyExplicitlySet("encoding")) {
                this.encoding(model.getEncoding());
            }
            if (model.wasPropertyExplicitlySet("sampleRateInHz")) {
                this.sampleRateInHz(model.getSampleRateInHz());
            }
            return this;
        }
    }
}

