/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aispeech.AIServiceSpeechAsync;
import com.oracle.bmc.aispeech.model.TranscriptionJob;
import com.oracle.bmc.aispeech.model.TranscriptionJobCollection;
import com.oracle.bmc.aispeech.model.TranscriptionTask;
import com.oracle.bmc.aispeech.model.TranscriptionTaskCollection;
import com.oracle.bmc.aispeech.requests.CancelTranscriptionJobRequest;
import com.oracle.bmc.aispeech.requests.CancelTranscriptionTaskRequest;
import com.oracle.bmc.aispeech.requests.ChangeTranscriptionJobCompartmentRequest;
import com.oracle.bmc.aispeech.requests.CreateTranscriptionJobRequest;
import com.oracle.bmc.aispeech.requests.GetTranscriptionJobRequest;
import com.oracle.bmc.aispeech.requests.GetTranscriptionTaskRequest;
import com.oracle.bmc.aispeech.requests.ListTranscriptionJobsRequest;
import com.oracle.bmc.aispeech.requests.ListTranscriptionTasksRequest;
import com.oracle.bmc.aispeech.requests.UpdateTranscriptionJobRequest;
import com.oracle.bmc.aispeech.responses.CancelTranscriptionJobResponse;
import com.oracle.bmc.aispeech.responses.CancelTranscriptionTaskResponse;
import com.oracle.bmc.aispeech.responses.ChangeTranscriptionJobCompartmentResponse;
import com.oracle.bmc.aispeech.responses.CreateTranscriptionJobResponse;
import com.oracle.bmc.aispeech.responses.GetTranscriptionJobResponse;
import com.oracle.bmc.aispeech.responses.GetTranscriptionTaskResponse;
import com.oracle.bmc.aispeech.responses.ListTranscriptionJobsResponse;
import com.oracle.bmc.aispeech.responses.ListTranscriptionTasksResponse;
import com.oracle.bmc.aispeech.responses.UpdateTranscriptionJobResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceSpeechAsyncClient
extends BaseAsyncClient
implements AIServiceSpeechAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICESPEECH").serviceEndpointPrefix("").serviceEndpointTemplate("https://speech.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceSpeechAsyncClient.class);

    private AIServiceSpeechAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelTranscriptionJobResponse> cancelTranscriptionJob(CancelTranscriptionJobRequest request, AsyncHandler<CancelTranscriptionJobRequest, CancelTranscriptionJobResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelTranscriptionJobResponse::builder).logger(LOG, "cancelTranscriptionJob").serviceDetails("AIServiceSpeech", "CancelTranscriptionJob", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionJob/CancelTranscriptionJob").method(Method.POST).requestBuilder(CancelTranscriptionJobRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", CancelTranscriptionJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelTranscriptionTaskResponse> cancelTranscriptionTask(CancelTranscriptionTaskRequest request, AsyncHandler<CancelTranscriptionTaskRequest, CancelTranscriptionTaskResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranscriptionTaskId(), (String)"transcriptionTaskId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelTranscriptionTaskResponse::builder).logger(LOG, "cancelTranscriptionTask").serviceDetails("AIServiceSpeech", "CancelTranscriptionTask", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionTask/CancelTranscriptionTask").method(Method.POST).requestBuilder(CancelTranscriptionTaskRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).appendPathParam("transcriptionTasks").appendPathParam(request.getTranscriptionTaskId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", CancelTranscriptionTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeTranscriptionJobCompartmentResponse> changeTranscriptionJobCompartment(ChangeTranscriptionJobCompartmentRequest request, AsyncHandler<ChangeTranscriptionJobCompartmentRequest, ChangeTranscriptionJobCompartmentResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTranscriptionJobCompartmentDetails(), "changeTranscriptionJobCompartmentDetails is required");
        return this.clientCall(request, ChangeTranscriptionJobCompartmentResponse::builder).logger(LOG, "changeTranscriptionJobCompartment").serviceDetails("AIServiceSpeech", "ChangeTranscriptionJobCompartment", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionJob/ChangeTranscriptionJobCompartment").method(Method.POST).requestBuilder(ChangeTranscriptionJobCompartmentRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTranscriptionJobCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateTranscriptionJobResponse> createTranscriptionJob(CreateTranscriptionJobRequest request, AsyncHandler<CreateTranscriptionJobRequest, CreateTranscriptionJobResponse> handler) {
        Objects.requireNonNull(request.getCreateTranscriptionJobDetails(), "createTranscriptionJobDetails is required");
        return this.clientCall(request, CreateTranscriptionJobResponse::builder).logger(LOG, "createTranscriptionJob").serviceDetails("AIServiceSpeech", "CreateTranscriptionJob", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionJob/CreateTranscriptionJob").method(Method.POST).requestBuilder(CreateTranscriptionJobRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TranscriptionJob.class, CreateTranscriptionJobResponse.Builder::transcriptionJob).handleResponseHeaderString("opc-request-id", CreateTranscriptionJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTranscriptionJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetTranscriptionJobResponse> getTranscriptionJob(GetTranscriptionJobRequest request, AsyncHandler<GetTranscriptionJobRequest, GetTranscriptionJobResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTranscriptionJobResponse::builder).logger(LOG, "getTranscriptionJob").serviceDetails("AIServiceSpeech", "GetTranscriptionJob", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionJob/GetTranscriptionJob").method(Method.GET).requestBuilder(GetTranscriptionJobRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TranscriptionJob.class, GetTranscriptionJobResponse.Builder::transcriptionJob).handleResponseHeaderString("etag", GetTranscriptionJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTranscriptionJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTranscriptionTaskResponse> getTranscriptionTask(GetTranscriptionTaskRequest request, AsyncHandler<GetTranscriptionTaskRequest, GetTranscriptionTaskResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTranscriptionTaskId(), (String)"transcriptionTaskId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTranscriptionTaskResponse::builder).logger(LOG, "getTranscriptionTask").serviceDetails("AIServiceSpeech", "GetTranscriptionTask", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionTask/GetTranscriptionTask").method(Method.GET).requestBuilder(GetTranscriptionTaskRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).appendPathParam("transcriptionTasks").appendPathParam(request.getTranscriptionTaskId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TranscriptionTask.class, GetTranscriptionTaskResponse.Builder::transcriptionTask).handleResponseHeaderString("etag", GetTranscriptionTaskResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTranscriptionTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListTranscriptionJobsResponse> listTranscriptionJobs(ListTranscriptionJobsRequest request, AsyncHandler<ListTranscriptionJobsRequest, ListTranscriptionJobsResponse> handler) {
        return this.clientCall(request, ListTranscriptionJobsResponse::builder).logger(LOG, "listTranscriptionJobs").serviceDetails("AIServiceSpeech", "ListTranscriptionJobs", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionJob/ListTranscriptionJobs").method(Method.GET).requestBuilder(ListTranscriptionJobsRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TranscriptionJobCollection.class, ListTranscriptionJobsResponse.Builder::transcriptionJobCollection).handleResponseHeaderString("opc-request-id", ListTranscriptionJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTranscriptionJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTranscriptionJobsResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListTranscriptionTasksResponse> listTranscriptionTasks(ListTranscriptionTasksRequest request, AsyncHandler<ListTranscriptionTasksRequest, ListTranscriptionTasksResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTranscriptionTasksResponse::builder).logger(LOG, "listTranscriptionTasks").serviceDetails("AIServiceSpeech", "ListTranscriptionTasks", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionTask/ListTranscriptionTasks").method(Method.GET).requestBuilder(ListTranscriptionTasksRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).appendPathParam("transcriptionTasks").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TranscriptionTaskCollection.class, ListTranscriptionTasksResponse.Builder::transcriptionTaskCollection).handleResponseHeaderString("opc-request-id", ListTranscriptionTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTranscriptionTasksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListTranscriptionTasksResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateTranscriptionJobResponse> updateTranscriptionJob(UpdateTranscriptionJobRequest request, AsyncHandler<UpdateTranscriptionJobRequest, UpdateTranscriptionJobResponse> handler) {
        Validate.notBlank((String)request.getTranscriptionJobId(), (String)"transcriptionJobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTranscriptionJobDetails(), "updateTranscriptionJobDetails is required");
        return this.clientCall(request, UpdateTranscriptionJobResponse::builder).logger(LOG, "updateTranscriptionJob").serviceDetails("AIServiceSpeech", "UpdateTranscriptionJob", "https://docs.oracle.com/iaas/api/#/en/speech/20220101/TranscriptionJob/UpdateTranscriptionJob").method(Method.PUT).requestBuilder(UpdateTranscriptionJobRequest::builder).basePath("/20220101").appendPathParam("transcriptionJobs").appendPathParam(request.getTranscriptionJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TranscriptionJob.class, UpdateTranscriptionJobResponse.Builder::transcriptionJob).handleResponseHeaderString("opc-request-id", UpdateTranscriptionJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTranscriptionJobResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceSpeechAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceSpeechAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceSpeechAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceSpeechAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceSpeechAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceSpeechAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceSpeechAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceSpeechAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceSpeechAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AIServiceSpeechAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceSpeechAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

