/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TranslationDocumentResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="translatedText")
    private final String translatedText;
    @JsonProperty(value="sourceLanguageCode")
    private final String sourceLanguageCode;
    @JsonProperty(value="targetLanguageCode")
    private final String targetLanguageCode;

    @Deprecated
    @ConstructorProperties(value={"key", "translatedText", "sourceLanguageCode", "targetLanguageCode"})
    public TranslationDocumentResult(String key, String translatedText, String sourceLanguageCode, String targetLanguageCode) {
        this.key = key;
        this.translatedText = translatedText;
        this.sourceLanguageCode = sourceLanguageCode;
        this.targetLanguageCode = targetLanguageCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getTranslatedText() {
        return this.translatedText;
    }

    public String getSourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public String getTargetLanguageCode() {
        return this.targetLanguageCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TranslationDocumentResult(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", translatedText=").append(String.valueOf(this.translatedText));
        sb.append(", sourceLanguageCode=").append(String.valueOf(this.sourceLanguageCode));
        sb.append(", targetLanguageCode=").append(String.valueOf(this.targetLanguageCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslationDocumentResult)) {
            return false;
        }
        TranslationDocumentResult other = (TranslationDocumentResult)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.translatedText, other.translatedText) && Objects.equals(this.sourceLanguageCode, other.sourceLanguageCode) && Objects.equals(this.targetLanguageCode, other.targetLanguageCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.translatedText == null ? 43 : this.translatedText.hashCode());
        result = result * 59 + (this.sourceLanguageCode == null ? 43 : this.sourceLanguageCode.hashCode());
        result = result * 59 + (this.targetLanguageCode == null ? 43 : this.targetLanguageCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="translatedText")
        private String translatedText;
        @JsonProperty(value="sourceLanguageCode")
        private String sourceLanguageCode;
        @JsonProperty(value="targetLanguageCode")
        private String targetLanguageCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder translatedText(String translatedText) {
            this.translatedText = translatedText;
            this.__explicitlySet__.add("translatedText");
            return this;
        }

        public Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            this.__explicitlySet__.add("sourceLanguageCode");
            return this;
        }

        public Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            this.__explicitlySet__.add("targetLanguageCode");
            return this;
        }

        public TranslationDocumentResult build() {
            TranslationDocumentResult model = new TranslationDocumentResult(this.key, this.translatedText, this.sourceLanguageCode, this.targetLanguageCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TranslationDocumentResult model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("translatedText")) {
                this.translatedText(model.getTranslatedText());
            }
            if (model.wasPropertyExplicitlySet("sourceLanguageCode")) {
                this.sourceLanguageCode(model.getSourceLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("targetLanguageCode")) {
                this.targetLanguageCode(model.getTargetLanguageCode());
            }
            return this;
        }
    }
}

