/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.ClassificationType;
import com.oracle.bmc.ailanguage.model.ModelDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class TextClassificationModelDetails
extends ModelDetails {
    @JsonProperty(value="classificationMode")
    private final ClassificationType classificationMode;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TextClassificationModelDetails(String languageCode, ClassificationType classificationMode) {
        super(languageCode);
        this.classificationMode = classificationMode;
    }

    public ClassificationType getClassificationMode() {
        return this.classificationMode;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TextClassificationModelDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", classificationMode=").append(String.valueOf((Object)this.classificationMode));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextClassificationModelDetails)) {
            return false;
        }
        TextClassificationModelDetails other = (TextClassificationModelDetails)((Object)o);
        return Objects.equals((Object)this.classificationMode, (Object)other.classificationMode) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.classificationMode == null ? 43 : this.classificationMode.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonProperty(value="classificationMode")
        private ClassificationType classificationMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public Builder classificationMode(ClassificationType classificationMode) {
            this.classificationMode = classificationMode;
            this.__explicitlySet__.add("classificationMode");
            return this;
        }

        public TextClassificationModelDetails build() {
            TextClassificationModelDetails model = new TextClassificationModelDetails(this.languageCode, this.classificationMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TextClassificationModelDetails model) {
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("classificationMode")) {
                this.classificationMode(model.getClassificationMode());
            }
            return this;
        }
    }
}

