/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.TextDocument;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BatchLanguageTranslationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetLanguageCode")
    private final String targetLanguageCode;
    @JsonProperty(value="documents")
    private final List<TextDocument> documents;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "targetLanguageCode", "documents"})
    public BatchLanguageTranslationDetails(String compartmentId, String targetLanguageCode, List<TextDocument> documents) {
        this.compartmentId = compartmentId;
        this.targetLanguageCode = targetLanguageCode;
        this.documents = documents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetLanguageCode() {
        return this.targetLanguageCode;
    }

    public List<TextDocument> getDocuments() {
        return this.documents;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchLanguageTranslationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetLanguageCode=").append(String.valueOf(this.targetLanguageCode));
        sb.append(", documents=").append(String.valueOf(this.documents));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchLanguageTranslationDetails)) {
            return false;
        }
        BatchLanguageTranslationDetails other = (BatchLanguageTranslationDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetLanguageCode, other.targetLanguageCode) && Objects.equals(this.documents, other.documents) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetLanguageCode == null ? 43 : this.targetLanguageCode.hashCode());
        result = result * 59 + (this.documents == null ? 43 : this.documents.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetLanguageCode")
        private String targetLanguageCode;
        @JsonProperty(value="documents")
        private List<TextDocument> documents;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            this.__explicitlySet__.add("targetLanguageCode");
            return this;
        }

        public Builder documents(List<TextDocument> documents) {
            this.documents = documents;
            this.__explicitlySet__.add("documents");
            return this;
        }

        public BatchLanguageTranslationDetails build() {
            BatchLanguageTranslationDetails model = new BatchLanguageTranslationDetails(this.compartmentId, this.targetLanguageCode, this.documents);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BatchLanguageTranslationDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetLanguageCode")) {
                this.targetLanguageCode(model.getTargetLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("documents")) {
                this.documents(model.getDocuments());
            }
            return this;
        }
    }
}

