/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.DocumentError;
import com.oracle.bmc.ailanguage.model.EntityDocumentResult;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BatchDetectLanguageEntitiesResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="documents")
    private final List<EntityDocumentResult> documents;
    @JsonProperty(value="errors")
    private final List<DocumentError> errors;

    @Deprecated
    @ConstructorProperties(value={"documents", "errors"})
    public BatchDetectLanguageEntitiesResult(List<EntityDocumentResult> documents, List<DocumentError> errors) {
        this.documents = documents;
        this.errors = errors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<EntityDocumentResult> getDocuments() {
        return this.documents;
    }

    public List<DocumentError> getErrors() {
        return this.errors;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchDetectLanguageEntitiesResult(");
        sb.append("super=").append(super.toString());
        sb.append("documents=").append(String.valueOf(this.documents));
        sb.append(", errors=").append(String.valueOf(this.errors));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchDetectLanguageEntitiesResult)) {
            return false;
        }
        BatchDetectLanguageEntitiesResult other = (BatchDetectLanguageEntitiesResult)((Object)o);
        return Objects.equals(this.documents, other.documents) && Objects.equals(this.errors, other.errors) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.documents == null ? 43 : this.documents.hashCode());
        result = result * 59 + (this.errors == null ? 43 : this.errors.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="documents")
        private List<EntityDocumentResult> documents;
        @JsonProperty(value="errors")
        private List<DocumentError> errors;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder documents(List<EntityDocumentResult> documents) {
            this.documents = documents;
            this.__explicitlySet__.add("documents");
            return this;
        }

        public Builder errors(List<DocumentError> errors) {
            this.errors = errors;
            this.__explicitlySet__.add("errors");
            return this;
        }

        public BatchDetectLanguageEntitiesResult build() {
            BatchDetectLanguageEntitiesResult model = new BatchDetectLanguageEntitiesResult(this.documents, this.errors);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BatchDetectLanguageEntitiesResult model) {
            if (model.wasPropertyExplicitlySet("documents")) {
                this.documents(model.getDocuments());
            }
            if (model.wasPropertyExplicitlySet("errors")) {
                this.errors(model.getErrors());
            }
            return this;
        }
    }
}

