/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage;

import com.oracle.bmc.ailanguage.AIServiceLanguage;
import com.oracle.bmc.ailanguage.model.Endpoint;
import com.oracle.bmc.ailanguage.model.Model;
import com.oracle.bmc.ailanguage.model.Project;
import com.oracle.bmc.ailanguage.requests.GetEndpointRequest;
import com.oracle.bmc.ailanguage.requests.GetModelRequest;
import com.oracle.bmc.ailanguage.requests.GetProjectRequest;
import com.oracle.bmc.ailanguage.requests.GetWorkRequestRequest;
import com.oracle.bmc.ailanguage.responses.GetEndpointResponse;
import com.oracle.bmc.ailanguage.responses.GetModelResponse;
import com.oracle.bmc.ailanguage.responses.GetProjectResponse;
import com.oracle.bmc.ailanguage.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AIServiceLanguageWaiters {
    private final ExecutorService executorService;
    private final AIServiceLanguage client;

    public AIServiceLanguageWaiters(ExecutorService executorService, AIServiceLanguage client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, Endpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, Endpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(GetEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Endpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEndpointRequest, GetEndpointResponse> forEndpoint(BmcGenericWaiter waiter, GetEndpointRequest request, Endpoint.LifecycleState ... targetStates) {
        final HashSet<Endpoint.LifecycleState> targetStatesSet = new HashSet<Endpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEndpointRequest, GetEndpointResponse>(){

            @Override
            public GetEndpointResponse apply(GetEndpointRequest request) {
                return AIServiceLanguageWaiters.this.client.getEndpoint(request);
            }
        }, (Predicate)new Predicate<GetEndpointResponse>(){

            @Override
            public boolean test(GetEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Endpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, Model.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Model.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelRequest, GetModelResponse> forModel(BmcGenericWaiter waiter, GetModelRequest request, Model.LifecycleState ... targetStates) {
        final HashSet<Model.LifecycleState> targetStatesSet = new HashSet<Model.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelRequest, GetModelResponse>(){

            @Override
            public GetModelResponse apply(GetModelRequest request) {
                return AIServiceLanguageWaiters.this.client.getModel(request);
            }
        }, (Predicate)new Predicate<GetModelResponse>(){

            @Override
            public boolean test(GetModelResponse response) {
                return targetStatesSet.contains((Object)response.getModel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Model.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProjectRequest, GetProjectResponse> forProject(BmcGenericWaiter waiter, GetProjectRequest request, Project.LifecycleState ... targetStates) {
        final HashSet<Project.LifecycleState> targetStatesSet = new HashSet<Project.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProjectRequest, GetProjectResponse>(){

            @Override
            public GetProjectResponse apply(GetProjectRequest request) {
                return AIServiceLanguageWaiters.this.client.getProject(request);
            }
        }, (Predicate)new Predicate<GetProjectResponse>(){

            @Override
            public boolean test(GetProjectResponse response) {
                return targetStatesSet.contains((Object)response.getProject().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Project.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return AIServiceLanguageWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

