/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetProcessorJobRequest
extends BmcRequest<Void> {
    private String processorJobId;
    private String opcRequestId;

    public String getProcessorJobId() {
        return this.processorJobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().processorJobId(this.processorJobId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",processorJobId=").append(String.valueOf(this.processorJobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetProcessorJobRequest)) {
            return false;
        }
        GetProcessorJobRequest other = (GetProcessorJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.processorJobId, other.processorJobId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.processorJobId == null ? 43 : this.processorJobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetProcessorJobRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String processorJobId = null;
        private String opcRequestId = null;

        public Builder processorJobId(String processorJobId) {
            this.processorJobId = processorJobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetProcessorJobRequest o) {
            this.processorJobId(o.getProcessorJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetProcessorJobRequest build() {
            GetProcessorJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetProcessorJobRequest buildWithoutInvocationCallback() {
            GetProcessorJobRequest request = new GetProcessorJobRequest();
            request.processorJobId = this.processorJobId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

