/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DocumentMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="pageCount")
    private final Integer pageCount;
    @JsonProperty(value="mimeType")
    private final String mimeType;

    @Deprecated
    @ConstructorProperties(value={"pageCount", "mimeType"})
    public DocumentMetadata(Integer pageCount, String mimeType) {
        this.pageCount = pageCount;
        this.mimeType = mimeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DocumentMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("pageCount=").append(String.valueOf(this.pageCount));
        sb.append(", mimeType=").append(String.valueOf(this.mimeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)((Object)o);
        return Objects.equals(this.pageCount, other.pageCount) && Objects.equals(this.mimeType, other.mimeType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.pageCount == null ? 43 : this.pageCount.hashCode());
        result = result * 59 + (this.mimeType == null ? 43 : this.mimeType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pageCount")
        private Integer pageCount;
        @JsonProperty(value="mimeType")
        private String mimeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pageCount(Integer pageCount) {
            this.pageCount = pageCount;
            this.__explicitlySet__.add("pageCount");
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            this.__explicitlySet__.add("mimeType");
            return this;
        }

        public DocumentMetadata build() {
            DocumentMetadata model = new DocumentMetadata(this.pageCount, this.mimeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DocumentMetadata model) {
            if (model.wasPropertyExplicitlySet("pageCount")) {
                this.pageCount(model.getPageCount());
            }
            if (model.wasPropertyExplicitlySet("mimeType")) {
                this.mimeType(model.getMimeType());
            }
            return this;
        }
    }
}

