/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument;

import com.oracle.bmc.aidocument.AIServiceDocument;
import com.oracle.bmc.aidocument.model.ProcessorJob;
import com.oracle.bmc.aidocument.requests.GetProcessorJobRequest;
import com.oracle.bmc.aidocument.responses.GetProcessorJobResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AIServiceDocumentWaiters {
    private final ExecutorService executorService;
    private final AIServiceDocument client;

    public AIServiceDocumentWaiters(ExecutorService executorService, AIServiceDocument client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetProcessorJobRequest, GetProcessorJobResponse> forProcessorJob(GetProcessorJobRequest request, ProcessorJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProcessorJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProcessorJobRequest, GetProcessorJobResponse> forProcessorJob(GetProcessorJobRequest request, ProcessorJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProcessorJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProcessorJobRequest, GetProcessorJobResponse> forProcessorJob(GetProcessorJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ProcessorJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProcessorJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProcessorJobRequest, GetProcessorJobResponse> forProcessorJob(BmcGenericWaiter waiter, GetProcessorJobRequest request, ProcessorJob.LifecycleState ... targetStates) {
        final HashSet<ProcessorJob.LifecycleState> targetStatesSet = new HashSet<ProcessorJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProcessorJobRequest, GetProcessorJobResponse>(){

            @Override
            public GetProcessorJobResponse apply(GetProcessorJobRequest request) {
                return AIServiceDocumentWaiters.this.client.getProcessorJob(request);
            }
        }, (Predicate)new Predicate<GetProcessorJobResponse>(){

            @Override
            public boolean test(GetProcessorJobResponse response) {
                return targetStatesSet.contains((Object)response.getProcessorJob().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

