/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RowReductionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isReductionEnabled")
    private final Boolean isReductionEnabled;
    @JsonProperty(value="reductionPercentage")
    private final Double reductionPercentage;
    @JsonProperty(value="reductionMethod")
    private final ReductionMethod reductionMethod;

    @Deprecated
    @ConstructorProperties(value={"isReductionEnabled", "reductionPercentage", "reductionMethod"})
    public RowReductionDetails(Boolean isReductionEnabled, Double reductionPercentage, ReductionMethod reductionMethod) {
        this.isReductionEnabled = isReductionEnabled;
        this.reductionPercentage = reductionPercentage;
        this.reductionMethod = reductionMethod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsReductionEnabled() {
        return this.isReductionEnabled;
    }

    public Double getReductionPercentage() {
        return this.reductionPercentage;
    }

    public ReductionMethod getReductionMethod() {
        return this.reductionMethod;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RowReductionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isReductionEnabled=").append(String.valueOf(this.isReductionEnabled));
        sb.append(", reductionPercentage=").append(String.valueOf(this.reductionPercentage));
        sb.append(", reductionMethod=").append(String.valueOf((Object)this.reductionMethod));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowReductionDetails)) {
            return false;
        }
        RowReductionDetails other = (RowReductionDetails)((Object)o);
        return Objects.equals(this.isReductionEnabled, other.isReductionEnabled) && Objects.equals(this.reductionPercentage, other.reductionPercentage) && Objects.equals((Object)this.reductionMethod, (Object)other.reductionMethod) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReductionEnabled == null ? 43 : this.isReductionEnabled.hashCode());
        result = result * 59 + (this.reductionPercentage == null ? 43 : this.reductionPercentage.hashCode());
        result = result * 59 + (this.reductionMethod == null ? 43 : this.reductionMethod.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReductionMethod implements BmcEnum
    {
        DeleteRow("DELETE_ROW"),
        AverageRow("AVERAGE_ROW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ReductionMethod> map;

        private ReductionMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReductionMethod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ReductionMethod', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ReductionMethod.class);
            map = new HashMap<String, ReductionMethod>();
            for (ReductionMethod v : ReductionMethod.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isReductionEnabled")
        private Boolean isReductionEnabled;
        @JsonProperty(value="reductionPercentage")
        private Double reductionPercentage;
        @JsonProperty(value="reductionMethod")
        private ReductionMethod reductionMethod;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isReductionEnabled(Boolean isReductionEnabled) {
            this.isReductionEnabled = isReductionEnabled;
            this.__explicitlySet__.add("isReductionEnabled");
            return this;
        }

        public Builder reductionPercentage(Double reductionPercentage) {
            this.reductionPercentage = reductionPercentage;
            this.__explicitlySet__.add("reductionPercentage");
            return this;
        }

        public Builder reductionMethod(ReductionMethod reductionMethod) {
            this.reductionMethod = reductionMethod;
            this.__explicitlySet__.add("reductionMethod");
            return this;
        }

        public RowReductionDetails build() {
            RowReductionDetails model = new RowReductionDetails(this.isReductionEnabled, this.reductionPercentage, this.reductionMethod);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RowReductionDetails model) {
            if (model.wasPropertyExplicitlySet("isReductionEnabled")) {
                this.isReductionEnabled(model.getIsReductionEnabled());
            }
            if (model.wasPropertyExplicitlySet("reductionPercentage")) {
                this.reductionPercentage(model.getReductionPercentage());
            }
            if (model.wasPropertyExplicitlySet("reductionMethod")) {
                this.reductionMethod(model.getReductionMethod());
            }
            return this;
        }
    }
}

