/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelTrainingDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetFap")
    private final Float targetFap;
    @JsonProperty(value="trainingFraction")
    private final Float trainingFraction;
    @JsonProperty(value="dataAssetIds")
    private final List<String> dataAssetIds;

    @Deprecated
    @ConstructorProperties(value={"targetFap", "trainingFraction", "dataAssetIds"})
    public ModelTrainingDetails(Float targetFap, Float trainingFraction, List<String> dataAssetIds) {
        this.targetFap = targetFap;
        this.trainingFraction = trainingFraction;
        this.dataAssetIds = dataAssetIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getTargetFap() {
        return this.targetFap;
    }

    public Float getTrainingFraction() {
        return this.trainingFraction;
    }

    public List<String> getDataAssetIds() {
        return this.dataAssetIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelTrainingDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targetFap=").append(String.valueOf(this.targetFap));
        sb.append(", trainingFraction=").append(String.valueOf(this.trainingFraction));
        sb.append(", dataAssetIds=").append(String.valueOf(this.dataAssetIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelTrainingDetails)) {
            return false;
        }
        ModelTrainingDetails other = (ModelTrainingDetails)((Object)o);
        return Objects.equals(this.targetFap, other.targetFap) && Objects.equals(this.trainingFraction, other.trainingFraction) && Objects.equals(this.dataAssetIds, other.dataAssetIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetFap == null ? 43 : this.targetFap.hashCode());
        result = result * 59 + (this.trainingFraction == null ? 43 : this.trainingFraction.hashCode());
        result = result * 59 + (this.dataAssetIds == null ? 43 : this.dataAssetIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetFap")
        private Float targetFap;
        @JsonProperty(value="trainingFraction")
        private Float trainingFraction;
        @JsonProperty(value="dataAssetIds")
        private List<String> dataAssetIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetFap(Float targetFap) {
            this.targetFap = targetFap;
            this.__explicitlySet__.add("targetFap");
            return this;
        }

        public Builder trainingFraction(Float trainingFraction) {
            this.trainingFraction = trainingFraction;
            this.__explicitlySet__.add("trainingFraction");
            return this;
        }

        public Builder dataAssetIds(List<String> dataAssetIds) {
            this.dataAssetIds = dataAssetIds;
            this.__explicitlySet__.add("dataAssetIds");
            return this;
        }

        public ModelTrainingDetails build() {
            ModelTrainingDetails model = new ModelTrainingDetails(this.targetFap, this.trainingFraction, this.dataAssetIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelTrainingDetails model) {
            if (model.wasPropertyExplicitlySet("targetFap")) {
                this.targetFap(model.getTargetFap());
            }
            if (model.wasPropertyExplicitlySet("trainingFraction")) {
                this.trainingFraction(model.getTrainingFraction());
            }
            if (model.wasPropertyExplicitlySet("dataAssetIds")) {
                this.dataAssetIds(model.getDataAssetIds());
            }
            return this;
        }
    }
}

