/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.DetectAnomaliesDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="requestType")
@JsonFilter(value="explicitlySetFilter")
public final class EmbeddedDetectAnomaliesRequest
extends DetectAnomaliesDetails {
    @JsonProperty(value="contentType")
    private final ContentType contentType;
    @JsonProperty(value="content")
    private final byte[] content;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public EmbeddedDetectAnomaliesRequest(String modelId, ContentType contentType, byte[] content) {
        super(modelId);
        this.contentType = contentType;
        this.content = content;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EmbeddedDetectAnomaliesRequest(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", contentType=").append(String.valueOf((Object)this.contentType));
        sb.append(", content=").append(includeByteArrayContents ? Arrays.toString(this.content) : String.valueOf(this.content) + (this.content != null ? " (byte[" + this.content.length + "])" : ""));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbeddedDetectAnomaliesRequest)) {
            return false;
        }
        EmbeddedDetectAnomaliesRequest other = (EmbeddedDetectAnomaliesRequest)((Object)o);
        return Objects.equals((Object)this.contentType, (Object)other.contentType) && Arrays.equals(this.content, other.content) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + Arrays.hashCode(this.content);
        return result;
    }

    public static enum ContentType implements BmcEnum
    {
        Csv("CSV"),
        Json("JSON");

        private final String value;
        private static Map<String, ContentType> map;

        private ContentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ContentType: " + key);
        }

        static {
            map = new HashMap<String, ContentType>();
            for (ContentType v : ContentType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonProperty(value="contentType")
        private ContentType contentType;
        @JsonProperty(value="content")
        private byte[] content;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public Builder contentType(ContentType contentType) {
            this.contentType = contentType;
            this.__explicitlySet__.add("contentType");
            return this;
        }

        public Builder content(byte[] content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public EmbeddedDetectAnomaliesRequest build() {
            EmbeddedDetectAnomaliesRequest model = new EmbeddedDetectAnomaliesRequest(this.modelId, this.contentType, this.content);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EmbeddedDetectAnomaliesRequest model) {
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            if (model.wasPropertyExplicitlySet("contentType")) {
                this.contentType(model.getContentType());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            return this;
        }
    }
}

