/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.Anomaly;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DetectionResultItem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="rowIndex")
    private final Integer rowIndex;
    @JsonProperty(value="score")
    private final Double score;
    @JsonProperty(value="anomalies")
    private final List<Anomaly> anomalies;

    @Deprecated
    @ConstructorProperties(value={"timestamp", "rowIndex", "score", "anomalies"})
    public DetectionResultItem(Date timestamp, Integer rowIndex, Double score, List<Anomaly> anomalies) {
        this.timestamp = timestamp;
        this.rowIndex = rowIndex;
        this.score = score;
        this.anomalies = anomalies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public Double getScore() {
        return this.score;
    }

    public List<Anomaly> getAnomalies() {
        return this.anomalies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DetectionResultItem(");
        sb.append("super=").append(super.toString());
        sb.append("timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", rowIndex=").append(String.valueOf(this.rowIndex));
        sb.append(", score=").append(String.valueOf(this.score));
        sb.append(", anomalies=").append(String.valueOf(this.anomalies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectionResultItem)) {
            return false;
        }
        DetectionResultItem other = (DetectionResultItem)((Object)o);
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.rowIndex, other.rowIndex) && Objects.equals(this.score, other.score) && Objects.equals(this.anomalies, other.anomalies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.rowIndex == null ? 43 : this.rowIndex.hashCode());
        result = result * 59 + (this.score == null ? 43 : this.score.hashCode());
        result = result * 59 + (this.anomalies == null ? 43 : this.anomalies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="rowIndex")
        private Integer rowIndex;
        @JsonProperty(value="score")
        private Double score;
        @JsonProperty(value="anomalies")
        private List<Anomaly> anomalies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            this.__explicitlySet__.add("rowIndex");
            return this;
        }

        public Builder score(Double score) {
            this.score = score;
            this.__explicitlySet__.add("score");
            return this;
        }

        public Builder anomalies(List<Anomaly> anomalies) {
            this.anomalies = anomalies;
            this.__explicitlySet__.add("anomalies");
            return this;
        }

        public DetectionResultItem build() {
            DetectionResultItem model = new DetectionResultItem(this.timestamp, this.rowIndex, this.score, this.anomalies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DetectionResultItem model) {
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("rowIndex")) {
                this.rowIndex(model.getRowIndex());
            }
            if (model.wasPropertyExplicitlySet("score")) {
                this.score(model.getScore());
            }
            if (model.wasPropertyExplicitlySet("anomalies")) {
                this.anomalies(model.getAnomalies());
            }
            return this;
        }
    }
}

