/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataSourceType implements BmcEnum
{
    OracleObjectStorage("ORACLE_OBJECT_STORAGE"),
    OracleAtp("ORACLE_ATP"),
    Influx("INFLUX"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, DataSourceType> map;

    private DataSourceType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static DataSourceType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'DataSourceType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(DataSourceType.class);
        map = new HashMap<String, DataSourceType>();
        for (DataSourceType v : DataSourceType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

