/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.graalvm;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Iterator;
import java.util.ServiceLoader;

@TargetClass(className="org.glassfish.jersey.internal.ServiceFinder")
final class ServiceFinderReplacement<T>
implements Iterable<T> {
    @Alias
    private Class<T> serviceClass;
    @Alias
    private String serviceName;
    @Alias
    private ClassLoader classLoader;
    @Alias
    private boolean ignoreOnClassNotFound;

    @Substitute
    private ServiceFinderReplacement(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this(service, service.getName(), loader, ignoreOnClassNotFound);
    }

    @Substitute
    private ServiceFinderReplacement(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this.serviceClass = service;
        this.serviceName = serviceName;
        this.classLoader = loader;
        this.ignoreOnClassNotFound = ignoreOnClassNotFound;
    }

    @Override
    @Substitute
    public Iterator<T> iterator() {
        return ServiceLoader.load(this.serviceClass).iterator();
    }
}

