/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import oracle.xml.common.format.DecimalFormatProperties;
import oracle.xml.common.format.Picture;
import oracle.xml.common.format.SubPicture;

public abstract class NumberFormatter<E extends Exception> {
    protected abstract E createInvalidPictureStringException(String var1);

    public Picture parsePicture(String string, DecimalFormatProperties<E> decimalFormatProperties) throws E {
        Picture picture = new Picture();
        SubPicture subPicture = picture.subPicture1 = new SubPicture(0);
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            int n2;
            int n3 = string.codePointAt(n);
            if (n3 == decimalFormatProperties.getPatternSeparator()) {
                if (picture.subPicture2 != null) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.end = n;
                this.finishParsing(string, subPicture, bl, decimalFormatProperties);
                this.setMinMaxActiveCharacter(subPicture, n);
                subPicture = picture.subPicture2 = new SubPicture(n += Character.charCount(n3));
                bl = false;
                continue;
            }
            if (n3 == decimalFormatProperties.getDecimalSeparator()) {
                if (subPicture.decimalSepPos != -1) {
                    throw this.createInvalidPictureStringException(string);
                }
                n2 = this.previousIndex(n, string);
                if (n2 >= 0 && string.codePointAt(n2) == decimalFormatProperties.getGroupingSeparator()) {
                    throw this.createInvalidPictureStringException(string);
                }
                this.setMinMaxActiveCharacter(subPicture, n);
                subPicture.decimalSepPos = n;
            } else if (n3 == decimalFormatProperties.getPercent()) {
                if (subPicture.percentPos != -1 || subPicture.perMillePos != -1) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.percentPos = n;
            } else if (n3 == decimalFormatProperties.getPerMille()) {
                if (subPicture.percentPos != -1 || subPicture.perMillePos != -1) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.perMillePos = n;
            } else if (n3 == decimalFormatProperties.getGroupingSeparator()) {
                int n4;
                n2 = this.previousIndex(n, string);
                if (n2 >= 0 && ((n4 = string.codePointAt(n2)) == decimalFormatProperties.getGroupingSeparator() || n4 == decimalFormatProperties.getDecimalSeparator())) {
                    throw this.createInvalidPictureStringException(string);
                }
                this.setMinMaxActiveCharacter(subPicture, n);
            } else if (n3 == decimalFormatProperties.getDigit()) {
                bl = true;
                this.setMinMaxActiveCharacter(subPicture, n);
            } else if (this.isMemberOfDecimalDigitFamily(n3, decimalFormatProperties)) {
                bl = true;
                this.setMinMaxActiveCharacter(subPicture, n);
            } else if (subPicture.minActiveCharacter != -1 && subPicture.unknownCharPos == -1) {
                subPicture.unknownCharPos = n;
            }
            n += Character.charCount(n3);
        }
        subPicture.end = string.length();
        this.finishParsing(string, subPicture, bl, decimalFormatProperties);
        return picture;
    }

    private void finishParsing(String string, SubPicture subPicture, boolean bl, DecimalFormatProperties<E> decimalFormatProperties) throws E {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (!bl) {
            throw this.createInvalidPictureStringException(string);
        }
        if (subPicture.unknownCharPos > subPicture.minActiveCharacter && subPicture.unknownCharPos < subPicture.maxActiveCharacter) {
            throw this.createInvalidPictureStringException(string);
        }
        boolean bl2 = false;
        for (n4 = subPicture.start; n4 < subPicture.integerPartEndPos(); n4 += Character.charCount(n5)) {
            n5 = string.codePointAt(n4);
            if (this.isMemberOfDecimalDigitFamily(n5, decimalFormatProperties)) {
                bl2 = true;
                ++subPicture.minimumIntegerPartSize;
                subPicture.addDigit();
                continue;
            }
            if (n5 == decimalFormatProperties.getDigit()) {
                if (bl2) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.addDigit();
                continue;
            }
            if (n5 != decimalFormatProperties.getGroupingSeparator()) continue;
            subPicture.integerPartGroupingPositions.add(0);
        }
        if (subPicture.integerPartGroupingPositions.size() > 0) {
            n4 = subPicture.integerPartGroupingPositions.size();
            n5 = subPicture.integerPartGroupingPositions.get(n4 - 1);
            for (n3 = n4 - 2; n3 >= 0; --n3) {
                n2 = subPicture.integerPartGroupingPositions.get(n3);
                if (n2 % n5 == 0 && n2 / n5 == n4 - n3) continue;
                n5 = -1;
                break;
            }
            n3 = 0;
            if (n5 != -1) {
                n = n2 = this.previousIndex(subPicture.integerPartEndPos(), string);
                while (n >= subPicture.start) {
                    int n6 = string.codePointAt(n);
                    if (++n3 % (n5 + 1) == 0 && n6 != decimalFormatProperties.getGroupingSeparator()) {
                        n5 = -1;
                        break;
                    }
                    n = this.previousIndex(n, string);
                }
            }
            subPicture.regularGroupingMultiple = n5;
        }
        n4 = 0;
        n5 = subPicture.fractionalPartBeginPos();
        for (n2 = n3 = this.nextIndex(n5, string.codePointAt(n5)); n2 < subPicture.mantissaPartEndPos(); n2 += Character.charCount(n)) {
            n = string.codePointAt(n2);
            if (n == decimalFormatProperties.getDigit()) {
                n4 = 1;
                ++subPicture.maximumFractionalPartSize;
                continue;
            }
            if (this.isMemberOfDecimalDigitFamily(n, decimalFormatProperties)) {
                if (n4 != 0) {
                    throw this.createInvalidPictureStringException(string);
                }
                ++subPicture.minimumFractionalPartSize;
                ++subPicture.maximumFractionalPartSize;
                continue;
            }
            if (n != decimalFormatProperties.getGroupingSeparator()) continue;
            subPicture.fractionalPartGroupingPositions.add(subPicture.maximumFractionalPartSize);
        }
        if (subPicture.decimalSepPos == -1 && (n2 = this.previousIndex(subPicture.integerPartEndPos(), string)) > 0 && string.codePointAt(n2) == decimalFormatProperties.getGroupingSeparator()) {
            throw this.createInvalidPictureStringException(string);
        }
        if (subPicture.minimumIntegerPartSize == 0 && subPicture.maximumFractionalPartSize == 0) {
            subPicture.minimumIntegerPartSize = 1;
        }
        if (subPicture.minimumIntegerPartSize == 0 && subPicture.minimumFractionalPartSize == 0) {
            subPicture.minimumFractionalPartSize = 1;
        }
    }

    private boolean isMemberOfDecimalDigitFamily(int n, DecimalFormatProperties<E> decimalFormatProperties) {
        return n >= decimalFormatProperties.getZeroDigit() && n <= decimalFormatProperties.getNineDigit();
    }

    private int getCorrespondingDecimalDigit(char c, int n) {
        int n2 = c - 48;
        return n + n2;
    }

    private int previousIndex(int n, String string) {
        int n2 = n - 1;
        if (n2 < 0) {
            return -1;
        }
        if (this.isSurrogate(string.charAt(n2))) {
            --n2;
        }
        return n2;
    }

    private int previousIndex(int n, StringBuilder stringBuilder) {
        int n2 = n - 1;
        if (n2 < 0) {
            return -1;
        }
        if (this.isSurrogate(stringBuilder.charAt(n2))) {
            --n2;
        }
        return n2;
    }

    private int nextIndex(int n, int n2) {
        return n + Character.charCount(n2);
    }

    private boolean isSurrogate(char c) {
        return c >= '\ud800' && c <= '\udfff';
    }

    private void setMinMaxActiveCharacter(SubPicture subPicture, int n) {
        if (subPicture.minActiveCharacter == -1) {
            subPicture.minActiveCharacter = n;
        }
        subPicture.maxActiveCharacter = n;
    }

    private void suffix(SubPicture subPicture, StringBuilder stringBuilder, String string) {
        int n;
        int n2;
        int n3 = subPicture.maxActiveCharacter;
        for (int i = n = this.nextIndex(n3, string.codePointAt(n3)); i < subPicture.end; i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            stringBuilder.appendCodePoint(n2);
        }
    }

    private void prefix(SubPicture subPicture, SubPicture subPicture2, StringBuilder stringBuilder, boolean bl, String string, DecimalFormatProperties<E> decimalFormatProperties) {
        int n;
        if (subPicture == subPicture2 && bl) {
            char[] cArray = Character.toChars(decimalFormatProperties.getMinusSign());
            stringBuilder.append(cArray);
        }
        for (int i = subPicture.start; i < subPicture.minActiveCharacter; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            stringBuilder.appendCodePoint(n);
        }
    }

    private boolean isNegativeZero(double d) {
        return d == 0.0 && 1.0 / d == Double.NEGATIVE_INFINITY;
    }

    private void infinity(StringBuilder stringBuilder, boolean bl, SubPicture subPicture, SubPicture subPicture2, String string, DecimalFormatProperties<E> decimalFormatProperties) {
        this.prefix(subPicture, subPicture2, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append(decimalFormatProperties.getInfinity());
        this.suffix(subPicture, stringBuilder, string);
    }

    private BigDecimal roundHalfToEven(BigDecimal bigDecimal, int n) {
        return n == 0 ? bigDecimal.setScale(0, RoundingMode.HALF_EVEN) : bigDecimal.movePointRight(n).setScale(0, RoundingMode.HALF_EVEN).movePointLeft(n);
    }

    public void formatDouble(double d, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        if (Double.isNaN(d)) {
            stringBuilder.append(decimalFormatProperties.getNan());
            return;
        }
        this.formatDouble(d, stringBuilder, picture, string, decimalFormatProperties);
    }

    public void formatFloat(float f, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        if (Float.isNaN(f)) {
            stringBuilder.append(decimalFormatProperties.getNan());
            return;
        }
        this.formatDouble((double)f, stringBuilder, picture, string, decimalFormatProperties);
    }

    public void formatDecimal(BigDecimal bigDecimal, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        SubPicture subPicture;
        if (bigDecimal == null) {
            stringBuilder.append(decimalFormatProperties.getNan());
            return;
        }
        boolean bl = bigDecimal.compareTo(BigDecimal.ZERO) == -1;
        SubPicture subPicture2 = subPicture = picture.subPicture2 != null && bl ? picture.subPicture2 : picture.subPicture1;
        if (subPicture.percentPos != -1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(100L));
        } else if (subPicture.perMillePos != -1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(1000L));
        }
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigDecimal bigDecimal3 = this.roundHalfToEven(bigDecimal2, subPicture.maximumFractionalPartSize);
        String string2 = this.format(subPicture, bigDecimal3, decimalFormatProperties);
        this.prefix(subPicture, picture.subPicture1, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append(string2);
        this.suffix(subPicture, stringBuilder, string);
    }

    public void formatLong(long l, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        int n;
        int n2;
        SubPicture subPicture;
        boolean bl = l < 0L;
        SubPicture subPicture2 = subPicture = picture.subPicture2 != null && bl ? picture.subPicture2 : picture.subPicture1;
        if (subPicture.percentPos != -1) {
            l *= 100L;
        } else if (subPicture.perMillePos != -1) {
            l *= 1000L;
        }
        if (l < 0L && !bl || l >= 0L && bl) {
            this.infinity(stringBuilder, bl, subPicture, picture.subPicture1, string, decimalFormatProperties);
            return;
        }
        int n3 = (l = Math.abs(l)) > 0L ? (int)(Math.log10(l) + 1.0) : 0;
        StringBuilder stringBuilder2 = new StringBuilder(n3 + (n2 > 0 ? n2 : 0));
        for (n2 = subPicture.minimumIntegerPartSize - n3; n2 > 0; --n2) {
            stringBuilder2.appendCodePoint(decimalFormatProperties.getZeroDigit());
        }
        if (l != 0L) {
            StringBuilder stringBuilder3 = new StringBuilder(n3);
            while (l != 0L) {
                n = (int)(l % 10L);
                stringBuilder3.appendCodePoint(decimalFormatProperties.getZeroDigit() + n);
                l /= 10L;
            }
            int n4 = n = this.previousIndex(stringBuilder3.length(), stringBuilder3);
            while (n4 >= 0) {
                stringBuilder2.appendCodePoint(stringBuilder3.codePointAt(n4));
                n4 = this.previousIndex(n4, stringBuilder3);
            }
        }
        int n5 = -1;
        if (subPicture.minimumFractionalPartSize > 0 && subPicture.decimalSepPos != -1) {
            n5 = stringBuilder2.length();
            stringBuilder2.appendCodePoint(decimalFormatProperties.getDecimalSeparator());
            for (n = 0; n < subPicture.minimumFractionalPartSize; ++n) {
                stringBuilder2.appendCodePoint(decimalFormatProperties.getZeroDigit());
            }
        }
        this.addGroupingSeparators(n5, stringBuilder2, subPicture, decimalFormatProperties);
        this.prefix(subPicture, picture.subPicture1, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append((CharSequence)stringBuilder2);
        this.suffix(subPicture, stringBuilder, string);
    }

    private void formatDouble(double d, StringBuilder stringBuilder, Picture picture, String string, DecimalFormatProperties<E> decimalFormatProperties) {
        SubPicture subPicture;
        boolean bl = d < 0.0 || this.isNegativeZero(d);
        SubPicture subPicture2 = subPicture = picture.subPicture2 != null && bl ? picture.subPicture2 : picture.subPicture1;
        if (subPicture.percentPos != -1) {
            d *= 100.0;
        } else if (subPicture.perMillePos != -1) {
            d *= 1000.0;
        }
        if (Double.isInfinite(d)) {
            this.infinity(stringBuilder, bl, subPicture, picture.subPicture1, string, decimalFormatProperties);
            return;
        }
        double d2 = Math.abs(d);
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d2));
        BigDecimal bigDecimal2 = this.roundHalfToEven(bigDecimal, subPicture.maximumFractionalPartSize);
        String string2 = this.format(subPicture, bigDecimal2, decimalFormatProperties);
        this.prefix(subPicture, picture.subPicture1, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append(string2);
        this.suffix(subPicture, stringBuilder, string);
    }

    private String format(SubPicture subPicture, BigDecimal bigDecimal, DecimalFormatProperties<E> decimalFormatProperties) {
        int n;
        char c;
        char c2;
        String string = bigDecimal.abs().toPlainString();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        boolean bl = true;
        int n5 = -1;
        int n6 = 0;
        for (c2 = '\u0000'; c2 < string.length(); ++c2) {
            c = string.charAt(c2);
            if (c >= '0' && c <= '9') {
                if (bl && c == '0') continue;
                bl = false;
                n = this.getCorrespondingDecimalDigit(c, decimalFormatProperties.getZeroDigit());
                stringBuilder.appendCodePoint(n);
                if (c != '0') {
                    n5 = stringBuilder.length();
                }
            } else if (c == '.') {
                n4 = stringBuilder.length();
                stringBuilder.append(Character.toChars(decimalFormatProperties.getDecimalSeparator()));
                bl = false;
                n5 = stringBuilder.length();
                continue;
            }
            if (n4 == -1) {
                ++n2;
                continue;
            }
            if (c != '0') {
                n3 += 1 + n6;
                n6 = 0;
                continue;
            }
            ++n6;
        }
        if (n4 == -1) {
            stringBuilder.append(Character.toChars(decimalFormatProperties.getDecimalSeparator()));
            n4 = stringBuilder.length() - Character.charCount(decimalFormatProperties.getDecimalSeparator());
        } else if (n6 > 0 && n5 >= 0 && n5 < stringBuilder.length()) {
            stringBuilder.setLength(n5);
        }
        while (n2 < subPicture.minimumIntegerPartSize) {
            stringBuilder.insert(0, Character.toChars(decimalFormatProperties.getZeroDigit()));
            n4 += Character.charCount(decimalFormatProperties.getZeroDigit());
            ++n2;
        }
        while (n3 < subPicture.minimumFractionalPartSize) {
            stringBuilder.append(Character.toChars(decimalFormatProperties.getZeroDigit()));
            ++n3;
        }
        this.addGroupingSeparators(n4, stringBuilder, subPicture, decimalFormatProperties);
        if (subPicture.decimalSepPos == -1 || n3 == 0) {
            c2 = stringBuilder.charAt(stringBuilder.length() - 1);
            c = (char)(this.isSurrogate(c2) ? 1 : 0);
            n = stringBuilder.length() - (c != '\u0000' ? 2 : 1);
            stringBuilder.setLength(n);
        }
        return stringBuilder.toString();
    }

    private void addGroupingSeparators(int n, StringBuilder stringBuilder, SubPicture subPicture, DecimalFormatProperties<E> decimalFormatProperties) {
        int n2;
        int n3;
        if (n == -1) {
            return;
        }
        int n4 = 0;
        int n5 = this.previousIndex(n, stringBuilder);
        int n6 = subPicture.integerPartGroupingPositions.size() - 1;
        int n7 = subPicture.regularGroupingMultiple;
        if (n5 != -1) {
            for (n2 = n5; n2 >= 0 && (n7 != -1 || n6 >= 0); n2 -= Character.charCount(n3)) {
                n3 = stringBuilder.codePointAt(n2);
                if (!this.isMemberOfDecimalDigitFamily(n3, decimalFormatProperties)) continue;
                ++n4;
                if (n7 != -1) {
                    if (n4 % n7 != 0 || n2 == 0) continue;
                    stringBuilder.insert(n2, Character.toChars(decimalFormatProperties.getGroupingSeparator()));
                    n += Character.charCount(decimalFormatProperties.getGroupingSeparator());
                    continue;
                }
                if (n6 < 0 || n4 != subPicture.integerPartGroupingPositions.get(n6)) continue;
                stringBuilder.insert(n2, Character.toChars(decimalFormatProperties.getGroupingSeparator()));
                n += Character.charCount(decimalFormatProperties.getGroupingSeparator());
                --n6;
            }
        }
        n4 = 0;
        n6 = 0;
        for (n2 = n; n2 < stringBuilder.length() && n6 < subPicture.fractionalPartGroupingPositions.size(); n2 += Character.charCount(n3)) {
            n3 = stringBuilder.codePointAt(n2);
            if (!this.isMemberOfDecimalDigitFamily(n3, decimalFormatProperties) || ++n4 != subPicture.fractionalPartGroupingPositions.get(n6)) continue;
            stringBuilder.insert(this.nextIndex(n2, n3), Character.toChars(decimalFormatProperties.getGroupingSeparator()));
            ++n6;
        }
    }
}

