/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Stack;
import oracle.xml.parser.schema.XSDCharClass;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDRegexProgram;

class XSDRegexVM
implements XSDConstantValues {
    private final XSDRegexProgram program;
    private String value;
    private int len;
    private long MATCH_NODES_LIMIT = 0x10000000L;

    XSDRegexVM(XSDRegexProgram xSDRegexProgram) {
        this.program = xSDRegexProgram;
    }

    static boolean isXMLSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static boolean isWEsc(char c) {
        int n = 1643118592;
        int n2 = Character.getType(c);
        if ((n & 1 << n2) != 0) {
            return false;
        }
        n = 28672;
        if ((n & 1 << n2) != 0) {
            return false;
        }
        n = 360449;
        return (n & 1 << n2) == 0;
    }

    protected int matchNodes() throws XSDException {
        int[] nArray = this.program.instruction;
        XSDCharClass[] xSDCharClassArray = this.program.chClass;
        Stack<State> stack = new Stack<State>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        block12: while ((long)n < this.MATCH_NODES_LIMIT) {
            int n3 = nArray[n];
            int n4 = n + nArray[n + 2];
            int n5 = nArray[n + 1];
            bl = false;
            int n6 = 88;
            block0 : switch (n3) {
                case 71: 
                case 78: {
                    bl = true;
                    break;
                }
                case 40: {
                    n = n4;
                    continue block12;
                }
                case 41: {
                    n = n4;
                    continue block12;
                }
                case 92: {
                    if (n2 >= this.len || !xSDCharClassArray[n5].match(this.value.charAt(n2++))) break;
                    bl = true;
                    break;
                }
                case 46: {
                    if (n2 >= this.len || this.value.charAt(n2++) == '\n') break;
                    bl = true;
                    break;
                }
                case 65: {
                    if (n2 >= this.len) break;
                    int n7 = n5;
                    int n8 = n + 3;
                    if (this.len - n2 < n7) break;
                    bl = true;
                    for (int i = 0; i < n7; ++i) {
                        if (this.value.charAt(n2++) == nArray[n8 + i]) continue;
                        bl = false;
                        break block0;
                    }
                    break;
                }
                case 80: 
                case 112: {
                    if (n2 >= this.len) break;
                    bl = xSDCharClassArray[n5].match(this.value.charAt(n2++));
                    break;
                }
                case 91: {
                    if (n2 >= this.len) break;
                    bl = xSDCharClassArray[nArray[n + 3]].match(this.value.charAt(n2++));
                    break;
                }
                case 124: {
                    if (this.len == 0 && n == 3) {
                        return this.len;
                    }
                    if (nArray[n4] == 124) {
                        stack.push(new State(n4, n2));
                    }
                    n += 3;
                    continue block12;
                }
                case 69: {
                    if (n2 != this.len) break;
                    return n2;
                }
                default: {
                    this.error(24000, "Invalid opcode.");
                }
            }
            if (!bl) {
                if (stack.size() > 0) {
                    State state = (State)stack.pop();
                    n = state.instr;
                    n2 = state.vPos;
                    continue;
                }
                return -1;
            }
            n = n4;
        }
        this.error(24000, "Reach an invalid state.");
        return -1;
    }

    boolean match(String string) throws XSDException {
        if (this.program == null) {
            this.error(24000, "Invalid state.");
        }
        this.value = string;
        this.len = string.length();
        if (this.program.hasInvalidChar(string)) {
            return false;
        }
        int n = this.matchNodes();
        return n == this.len;
    }

    private void error(int n, String string) throws XSDException {
        throw new XSDException(n, string);
    }

    private void error2(int n, String string, String string2) throws XSDException {
        throw new XSDException(n, string, string2);
    }

    class State {
        int instr;
        int vPos;

        State(int n, int n2) {
            this.instr = n;
            this.vPos = n2;
        }
    }
}

