/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.PagedNodeList;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public class XSLSort
extends XSLNode
implements XSLConstants {
    private static final String SELECT_ATTR = "select";
    private static final String ORDER_ATTR = "order";
    private static final String LANG_ATTR = "lang";
    private static final String STABLE_ATTR = "stable";
    private static final String DATA_TYPE_ATTR = "data-type";
    private static final String CASE_ORDER_ATTR = "case-order";
    private static final String UPPER_FIRST = "upper-first";
    private static final String LOWER_FIRST = "lower-first";
    private static final String ASCENDING_ORDER = "ascending";
    private static final String DESCENDING_ORDER = "descending";
    private static final String TEXT_TYPE = "text";
    private static final String NUMBER_TYPE = "number";
    private static final String XSL_SORT = "xsl:sort";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String LEFT_BRACKET = "{";
    private static final String COLON = ":";
    private XSLSort m_seckey;
    XSLExprBase m_selectexpr;
    private String m_strTextType = "text";
    private String m_strAscending = "ascending";
    private String m_strCaseOrder = null;
    private static final String UNICODE_TBL_BEFORE_ZERO = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/'";
    private static final String UNICODE_TBL_BETWEEN_9_AND_A = " < ':' < ';' < '<' < '=' < '>' < '?' < '@'";
    private static final String UNICODE_TBL_BETWEEN_Z_AND_a = " < '[' < '\\' < ']' < '^' < '_' < '`'";
    private static final String UNICODE_TBL_BETWEEN_0_AND_9 = " < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9";
    private XSLNode.AttrValueTmpl m_atvText;
    private XSLNode.AttrValueTmpl m_atvAsc;
    private XSLNode.AttrValueTmpl m_atvCaseOrder;
    private XSLNode.AttrValueTmpl m_atvCollationURI;
    private XSLNode.AttrValueTmpl m_atvStable;
    private String m_strLang = "";
    private boolean m_blnIsEnglish;
    private Collator m_collator;
    private boolean m_isNonEmptyContent = false;
    private boolean m_isSecKey = false;
    private int level = 0;

    XSLSort(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            if (string3 == SELECT_ATTR) {
                this.m_selectexpr = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
            } else if (string3 == "collation" && this.version >= 20) {
                this.m_atvCollationURI = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == DATA_TYPE_ATTR) {
                this.m_strTextType = string4;
                this.m_atvText = new XSLNode.AttrValueTmpl(this.m_strTextType, this);
                if (string4 != TEXT_TYPE && string4 != NUMBER_TYPE && !string4.startsWith(LEFT_BRACKET) && !string4.contains(COLON)) {
                    this.xss.err.error3(22222, 1, XSL_SORT, DATA_TYPE_ATTR, string4);
                }
            } else if (string3 == ORDER_ATTR) {
                this.m_strAscending = string4;
                this.m_atvAsc = new XSLNode.AttrValueTmpl(this.m_strAscending, this);
                if (string4 != ASCENDING_ORDER && string4 != DESCENDING_ORDER && !string4.startsWith(LEFT_BRACKET)) {
                    this.xss.err.error3(22222, 1, XSL_SORT, ORDER_ATTR, string4);
                }
            } else if (string3 == LANG_ATTR) {
                this.m_strLang = string4.intern();
            } else if (string3 == CASE_ORDER_ATTR) {
                this.m_strCaseOrder = string4;
                this.m_atvCaseOrder = new XSLNode.AttrValueTmpl(this.m_strCaseOrder, this);
                if (string4 != UPPER_FIRST && string4 != LOWER_FIRST && !string4.startsWith(LEFT_BRACKET)) {
                    this.xss.err.error3(22222, 1, XSL_SORT, CASE_ORDER_ATTR, string4);
                }
            } else if (string3 == STABLE_ATTR) {
                if (this.m_isSecKey) {
                    this.xss.err.error0(1068, 1);
                } else {
                    this.m_atvStable = new XSLNode.AttrValueTmpl(string4, this);
                    if (string4 != YES && string4 != NO && !string4.startsWith(LEFT_BRACKET)) {
                        this.xss.err.error3(22222, 1, XSL_SORT, STABLE_ATTR, string4);
                    }
                }
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException, XQException {
        this.handleLanguageCollator();
        if (this.getXSLTVersion() >= 20) {
            this.elementType = 6;
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        this.m_isNonEmptyContent = true;
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
        if (this.m_isNonEmptyContent && this.m_selectexpr != null) {
            this.xss.err.error0(22274, 1);
        } else if (!this.m_isNonEmptyContent && this.m_selectexpr == null) {
            this.m_selectexpr = XSLExprBase.createExpression(".", (NSResolver)this, this.xss);
        }
    }

    void addSecondaryKey(XSLSort xSLSort) throws XSLException {
        xSLSort.m_isSecKey = true;
        if (this.m_seckey == null) {
            xSLSort.level = this.level + 1;
            this.m_seckey = xSLSort;
        } else {
            this.m_seckey.addSecondaryKey(xSLSort);
        }
    }

    XSLSort getSecondaryKey() {
        return this.m_seckey;
    }

    private OXMLSequence getValue(XSLTContext xSLTContext) throws XSLException {
        OXMLSequence oXMLSequence;
        if (this.m_selectexpr != null) {
            this.m_selectexpr.evaluate(xSLTContext);
            oXMLSequence = xSLTContext.popExprValue();
        } else {
            oXMLSequence = new XPathSequence(xSLTContext);
            XSLDocumentBuilder xSLDocumentBuilder = xSLTContext.allocXSLDocumentBuilder();
            xSLDocumentBuilder.setSequenceConstructor(xSLTContext, null);
            XSLEventHandler xSLEventHandler = xSLTContext.allocXSLEventHandler();
            xSLEventHandler.reset(xSLDocumentBuilder, xSLDocumentBuilder, xSLTContext);
            xSLDocumentBuilder.setVariableContext(true);
            XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler();
            xSLTContext.setEventHandler(xSLEventHandler);
            this.processChildren(xSLTContext);
            xSLEventHandler.flushEvents();
            oXMLSequence = xSLDocumentBuilder.getResultSequence();
            xSLTContext.setEventHandler(xSLEventHandler2);
            xSLDocumentBuilder.setVariableContext(false);
            xSLTContext.freeXSLDocumentBuilder(xSLDocumentBuilder);
            xSLTContext.freeXSLEventHandler(xSLEventHandler);
        }
        return oXMLSequence;
    }

    private void prepareAttributeTemplateValue(XSLTContext xSLTContext, SortProperties sortProperties) throws XSLException, XQException {
        String string = null;
        XMLError xMLError = xSLTContext.getError();
        if (this.m_atvCollationURI != null) {
            string = this.m_atvCollationURI.getValue(xSLTContext);
            sortProperties.oraCollator = xSLTContext.getCollator(string);
            if (sortProperties.oraCollator == null) {
                throw new XQException("FOCH0002");
            }
        }
        if (this.m_atvText != null && (string = this.m_atvText.getValue(xSLTContext).intern()) != TEXT_TYPE && string != NUMBER_TYPE && !string.contains(COLON)) {
            xMLError.error3(22222, 1, XSL_SORT, DATA_TYPE_ATTR, string);
        }
        if (string == TEXT_TYPE) {
            sortProperties.isTextType = Boolean.TRUE;
        } else if (string == NUMBER_TYPE) {
            sortProperties.isTextType = Boolean.FALSE;
        }
        if (this.m_atvAsc != null) {
            string = this.m_atvAsc.getValue(xSLTContext).intern();
            if (string != ASCENDING_ORDER && string != DESCENDING_ORDER) {
                xMLError.error3(22222, 1, XSL_SORT, ORDER_ATTR, string);
            }
        } else {
            string = this.m_strAscending;
        }
        boolean bl = sortProperties.ascending = string == ASCENDING_ORDER;
        if (sortProperties.oraCollator == null) {
            string = this.m_strCaseOrder;
            int n = 0;
            if (this.m_atvCaseOrder != null && (string = this.m_atvCaseOrder.getValue(xSLTContext).intern()) != UPPER_FIRST && string != LOWER_FIRST) {
                xMLError.error3(22222, 1, XSL_SORT, CASE_ORDER_ATTR, string);
            }
            if (string == UPPER_FIRST) {
                n = 1;
            } else if (string == LOWER_FIRST) {
                n = 2;
            }
            RuleBasedCollator ruleBasedCollator = null;
            ruleBasedCollator = this.fillRuleBaseTables(xSLTContext, n);
            sortProperties.jdkCollator = ruleBasedCollator == null ? Collator.getInstance() : ruleBasedCollator;
        }
        if (sortProperties.oraCollator == null && sortProperties.jdkCollator == null) {
            sortProperties.jdkCollator = this.m_collator;
        }
        if (sortProperties.oraCollator == null && sortProperties.jdkCollator != null) {
            sortProperties.oraCollator = OXMLCollator.newInstance(sortProperties.jdkCollator);
        }
        string = YES;
        if (this.m_atvStable != null && (string = this.m_atvStable.getValue(xSLTContext).intern()) != YES && string != NO) {
            xMLError.error3(22222, 1, XSL_SORT, STABLE_ATTR, string);
        }
        sortProperties.isStable = string == YES;
    }

    @Deprecated
    public void sortNodes(XSLTContext xSLTContext) throws XSLException, XQException {
        this.sortSequence(xSLTContext);
    }

    public void sortSequence(XSLTContext xSLTContext) throws XSLException, XQException {
        Cloneable cloneable;
        XPathSequence xPathSequence = (XPathSequence)xSLTContext.peekExprValue();
        XMLNode xMLNode = xSLTContext.getContextNode();
        if (xMLNode != null && ((XMLNode)(cloneable = xMLNode.getSrcRoot())).isScalable() && !((XMLNode)cloneable).isScalableDOMDirty() && this.m_seckey == null && xSLTContext.getPageManager() != null && !xSLTContext.isSortingGroup() && xPathSequence.isStreaming() && !this.xss.getPrecedingAxis()) {
            this.sortNodesLazy(xSLTContext);
            return;
        }
        this.setContextBaseURL(xSLTContext);
        cloneable = new ArrayList();
        while (xPathSequence.next()) {
            ((ArrayList)cloneable).add((XPathItem)xPathSequence.getItem());
        }
        int n = ((ArrayList)cloneable).size();
        xSLTContext.setContextSize(n);
        Integer[] integerArray = this.sorting(xSLTContext, ((ArrayList)cloneable).toArray());
        xPathSequence.reset(false);
        for (int i = 0; i < n; ++i) {
            xPathSequence.appendItem((OXMLItem)((ArrayList)cloneable).get(integerArray[i]));
        }
    }

    public void dataTypeAttributeConversion(OXMLItem oXMLItem, SortProperties sortProperties) {
        if (oXMLItem.getPrimitiveType() == 90) {
            oXMLItem.atomize(null);
        }
        if (sortProperties.isTextType == Boolean.TRUE) {
            oXMLItem.convert(OXMLSequenceType.TSTRING);
        } else if (sortProperties.isTextType == Boolean.FALSE) {
            try {
                oXMLItem.convert(OXMLSequenceType.TDOUBLE);
            }
            catch (XQException xQException) {
                oXMLItem.setDouble(OXMLSequenceType.TDOUBLE, Double.NEGATIVE_INFINITY);
            }
        }
    }

    private boolean sortCollationKey(SortProperties sortProperties) {
        if (sortProperties.jdkCollator == null) {
            return false;
        }
        if (sortProperties.isTextType == Boolean.FALSE) {
            return false;
        }
        if (sortProperties.isTextType != Boolean.TRUE) {
            if (this.m_selectexpr != null) {
                int n = this.m_selectexpr.getExprType();
                if (n != 0x2200000) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    Integer[] sorting(XSLTContext xSLTContext, Object[] objectArray) throws XSLException, XQException {
        Integer[] integerArray;
        int n = objectArray.length;
        ArrayList<SortProperties> arrayList = new ArrayList<SortProperties>(5);
        XSLSort xSLSort = this;
        while (xSLSort != null) {
            integerArray = new SortProperties();
            xSLSort.prepareAttributeTemplateValue(xSLTContext, (SortProperties)integerArray);
            arrayList.add((SortProperties)integerArray);
            xSLSort = xSLSort.m_seckey;
        }
        xSLTContext.setSortPropertiesArray(arrayList);
        integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = new Integer(i);
        }
        Object[] objectArray2 = new Object[n];
        this.sorting(xSLTContext, objectArray, integerArray, objectArray2, 0, n);
        return integerArray;
    }

    void sorting(XSLTContext xSLTContext, Object[] objectArray, Integer[] integerArray, final Object[] objectArray2, int n, int n2) throws XSLException, XQException {
        int n3;
        final SortProperties sortProperties = xSLTContext.getSortProperties(this.level);
        final boolean bl = this.sortCollationKey(sortProperties);
        for (int i = n; i < n2; ++i) {
            Object object;
            n3 = integerArray[i];
            XMLNode xMLNode = null;
            if (objectArray[n3] instanceof XMLNode) {
                xMLNode = (XMLNode)objectArray[n3];
                xSLTContext.setContextNode(xMLNode);
            } else {
                xSLTContext.setContextItem((XPathItem)objectArray[n3]);
            }
            xSLTContext.setContextPosition(n3 + 1);
            if (xSLTContext.isSortingGroup()) {
                xSLTContext.setSortingGrpIdx(n3);
            }
            xSLTContext.setCurrentNode(xSLTContext.getContextNode());
            XPathItem xPathItem = null;
            if (this.m_selectexpr == null && this.children == null) {
                if (xMLNode != null) {
                    xPathItem = xSLTContext.allocItem();
                    xPathItem.setNode(xSLTContext.getContextNode());
                } else {
                    xPathItem = (XPathItem)objectArray[n3];
                }
            } else {
                object = this.getValue(xSLTContext);
                ((OXMLSequence)object).next();
                xPathItem = (XPathItem)((OXMLSequence)object).getItem();
            }
            if (xPathItem != null) {
                xPathItem = xPathItem.copy();
                this.dataTypeAttributeConversion(xPathItem, sortProperties);
                if (bl) {
                    object = xPathItem.getString();
                    objectArray2[n3] = sortProperties.jdkCollator.getCollationKey((String)object);
                    continue;
                }
                objectArray2[n3] = xPathItem;
                continue;
            }
            objectArray2[n3] = null;
        }
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public final int compare(Integer n, Integer n2) {
                int n3 = 0;
                n3 = bl ? XSLSort.this.compareCollationKeys((CollationKey)objectArray2[n], (CollationKey)objectArray2[n2], sortProperties.ascending) : XSLSort.this.compareItems((XPathItem)objectArray2[n], (XPathItem)objectArray2[n2], sortProperties);
                return n3;
            }
        };
        Arrays.sort(integerArray, n, n2, comparator);
        if (this.m_seckey != null) {
            n3 = n;
            while (n3 < n2 - 1) {
                int n4;
                for (n4 = n3 + 1; n4 < n2 && comparator.compare(integerArray[n4], integerArray[n3]) == 0; ++n4) {
                }
                if (n4 > n3 + 1) {
                    this.m_seckey.sorting(xSLTContext, objectArray, integerArray, objectArray2, n3, n4);
                }
                n3 = n4;
            }
        }
    }

    private void sortNodesLazy(XSLTContext xSLTContext) throws XSLException {
        int n = 1;
        PagedNodeList pagedNodeList = null;
        XPathSequence xPathSequence = (XPathSequence)xSLTContext.peekExprValue();
        SortProperties sortProperties = new SortProperties();
        this.prepareAttributeTemplateValue(xSLTContext, sortProperties);
        if (xPathSequence.next()) {
            XMLNode xMLNode = XPathSequence.nextNode(xPathSequence);
            XMLDocument xMLDocument = (XMLDocument)xMLNode.getOwnerDocument();
            pagedNodeList = new PagedNodeList(xSLTContext.getPageManager(), xMLDocument.getInfosetReader(), (XMLElement)xMLNode.getParentNode());
            pagedNodeList.setSort(xSLTContext, this);
            xSLTContext.setContextPosition(n++);
            xSLTContext.setContextNode(xMLNode);
            this.m_selectexpr.evaluate(xSLTContext);
            pagedNodeList.addNode(xMLNode, xSLTContext.popExprValue(), sortProperties);
            while (xPathSequence.next()) {
                xMLNode = XPathSequence.nextNode(xPathSequence);
                xSLTContext.setContextPosition(n++);
                xSLTContext.setContextNode(xMLNode);
                this.m_selectexpr.evaluate(xSLTContext);
                pagedNodeList.addNode(xMLNode, xSLTContext.popExprValue(), sortProperties);
            }
            pagedNodeList.flushPage();
            pagedNodeList.finishSort(sortProperties);
            pagedNodeList.start();
            xPathSequence.reset();
            xPathSequence.setPagedNodeList(pagedNodeList);
        }
    }

    public OXMLItem getCompareItem(XSLTContext xSLTContext, XMLNode xMLNode, SortProperties sortProperties) throws XSLException {
        xSLTContext.setContextNode(xMLNode);
        this.m_selectexpr.evaluate(xSLTContext);
        OXMLSequence oXMLSequence = xSLTContext.popExprValue();
        oXMLSequence.atomizeInPlace();
        oXMLSequence.next();
        XPathItem xPathItem = (XPathItem)oXMLSequence.getItem();
        if (xPathItem != null) {
            this.dataTypeAttributeConversion(xPathItem, sortProperties);
            return xPathItem.copy();
        }
        return null;
    }

    int compareCollationKeys(CollationKey collationKey, CollationKey collationKey2, boolean bl) {
        if (collationKey == null && collationKey2 == null) {
            return 0;
        }
        if (collationKey == null) {
            return -1;
        }
        if (collationKey2 == null) {
            return 1;
        }
        int n = collationKey.compareTo(collationKey2);
        if (bl) {
            return n;
        }
        return -n;
    }

    public int compareItems(OXMLItem oXMLItem, OXMLItem oXMLItem2, SortProperties sortProperties) {
        if (oXMLItem == null && oXMLItem2 == null) {
            return 0;
        }
        if (oXMLItem == null) {
            return -1;
        }
        if (oXMLItem2 == null) {
            return 1;
        }
        int n = oXMLItem.compareValue(oXMLItem2, sortProperties.oraCollator);
        if (n == -2) {
            int n2 = oXMLItem.getPrimitiveType();
            int n3 = oXMLItem2.getPrimitiveType();
            if (n2 == 4 || n3 == 4) {
                boolean bl = Double.isNaN(oXMLItem.getDouble());
                boolean bl2 = Double.isNaN(oXMLItem2.getDouble());
                n = bl && bl2 ? 0 : (bl ? -1 : 1);
            }
        }
        if (!sortProperties.ascending) {
            n = -n;
        }
        return n;
    }

    private Locale getLocale() throws XSLException {
        Locale locale = Locale.getDefault();
        if (this.m_strLang == "") {
            return locale;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_strLang, "-");
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return new Locale(string, string2);
    }

    void handleLanguageCollator() throws XSLException {
        Locale locale = this.getLocale();
        String string = locale.getLanguage();
        if (string == null || string.length() == 0 || string.equals("en")) {
            this.m_blnIsEnglish = true;
        } else {
            this.m_collator = Collator.getInstance(locale);
            this.m_collator.setStrength(2);
            this.m_blnIsEnglish = false;
        }
    }

    private RuleBasedCollator fillRuleBaseTables(XSLTContext xSLTContext, int n) throws XSLException {
        String string;
        String string2;
        RuleBasedCollator ruleBasedCollator = null;
        if (n == 1) {
            string2 = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < ':' < ';' < '<' < '=' < '>' < '?' < '@' < A , a < B , b < C , c < D , d < E , e < F , f < G , g < H , h < I , i < J , j < K , k < L , l < M , m < N , n < O , o < P , p < Q , q < R , r < S , s < T , t < U , u < V , v < W , w < X , x < Y , y < Z , z  < '[' < '\\' < ']' < '^' < '_' < '`'";
            string = UPPER_FIRST;
        } else if (n == 2) {
            string2 = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < ':' < ';' < '<' < '=' < '>' < '?' < '@' < a , A < b , B < c , C < d , D < e , E < f , F < g , G < h , H < i , I < j , J < k , K < l , L < m , M < n , N < o , O < p , P < q , Q < r , R < s , S < t , T < u , U < v , V < w , W < x , X < y , Y < z , Z  < '[' < '\\' < ']' < '^' < '_' < '`'";
            string = LOWER_FIRST;
        } else {
            string2 = " < ' ' < '!' < '\"' < '#' < '$' < '%' < '&' < ''' < '(' < ')' < '*' < '+' < ',' < '-' < '.' < '/' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < ':' < ';' < '<' < '=' < '>' < '?' < '@' < A < B < C < D < E < F < G < H < I < J < K < L < M < N < O < P < Q < R < S < T < U < V < W < X < Y < Z < '[' < '\\' < ']' < '^' < '_' < '`' < a < b < c < d < e < f < g < h < i < j < k < l < m < n < o < p < q < r < s < t < u < v < w < x < y < z ";
            string = "no case-order";
        }
        try {
            ruleBasedCollator = new RuleBasedCollator(string2);
        }
        catch (Exception exception) {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error2(1030, 2, string, CASE_ORDER_ATTR);
        }
        return ruleBasedCollator;
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        if (this.m_seckey != null) {
            this.m_seckey.finalizeXSLNode();
        }
        super.finalizeXSLNode();
    }

    @Override
    void printChildren(PrintWriter printWriter, int n) {
        if (this.m_seckey != null) {
            this.m_seckey.printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }

    public static class SortProperties {
        boolean isStable = true;
        int isUserDefinedCollator = 0;
        OXMLCollator oraCollator;
        Collator jdkCollator;
        boolean ascending = true;
        Boolean isTextType;
    }
}

