/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNPatternMatch;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNReplace
extends FNPatternMatch {
    boolean hasFlag;

    FNReplace(boolean bl) {
        this.hasFlag = bl;
    }

    @Override
    public String getFunctionName() {
        return "replace";
    }

    @Override
    public int getNumberArgs() {
        if (this.hasFlag) {
            return 4;
        }
        return 3;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(1, 1);
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.getConstantType(2, 1);
        }
        if (n <= 2 || n == 3 && this.hasFlag) {
            return OXMLSequenceType.getConstantType(1, 1);
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        int n = 0;
        if (oXMLSequenceArray.length == 3 && !this.hasFlag || oXMLSequenceArray.length == 4 && this.hasFlag) {
            OXMLItem oXMLItem;
            if (oXMLSequenceArray.length == 4 && (oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[3])) != null) {
                n = FNReplace.getFlag(oXMLItem.getString());
            }
            OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
            oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[0]);
            OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[1]);
            OXMLItem oXMLItem3 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[2]);
            String string = "";
            if (oXMLItem != null) {
                string = oXMLItem.getString();
            }
            if (oXMLItem2 == null || oXMLItem3 == null) {
                throw new XQException("FORG0005");
            }
            try {
                Pattern pattern = Pattern.compile(oXMLItem2.getString(), n);
                String string2 = pattern.matcher(string).replaceAll(oXMLItem3.getString());
                OXMLItem oXMLItem4 = oXMLFunctionContext.createItem();
                oXMLItem4.setString(this.getReturnType(), string2);
                oXMLSequence.appendItem(oXMLItem4);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XQException("FORX0002");
            }
            return oXMLSequence;
        }
        throw new XQException("FORT0001");
    }
}

