/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.xml.jaxp.JXSAXParser;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.util.XMLError;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JXSAXParserFactory
extends SAXParserFactory {
    private static final XMLError err = new XMLError();
    private final Map<String, Boolean> features = new Hashtable<String, Boolean>(5);
    private boolean isSecure = false;
    private boolean deterministic = true;
    private boolean ignoreSchemaDuplicate = false;
    private boolean resolveEntityDefault = true;

    @Override
    public javax.xml.parsers.SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        JXSAXParser jXSAXParser = new JXSAXParser();
        SAXParser sAXParser = jXSAXParser.getSAXParser();
        sAXParser.setValidationMode(this.isValidating());
        if (this.ignoreSchemaDuplicate) {
            sAXParser.setXMLProperty("oracle.xml.schema/Ignore_Duplicate_Components", Boolean.TRUE);
        }
        if (!this.resolveEntityDefault) {
            sAXParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", (Object)Boolean.FALSE);
        }
        if (this.isSecure) {
            sAXParser.setEntityDepth(11);
            sAXParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", (Object)Boolean.FALSE);
            sAXParser.setAttribute("oracle.xdkjava.security.entityExpansionCountLimit", (Object)64000);
        } else {
            sAXParser.setEntityDepth(16);
            sAXParser.setAttribute("oracle.xdkjava.security.entityExpansionCountLimit", (Object)64000);
        }
        if (!this.deterministic) {
            sAXParser.setAttribute("oracle.xml.parser.XMLParser.ContentModelDeterministic", (Object)Boolean.FALSE);
        }
        Set<String> set = this.features.keySet();
        for (String string : set) {
            boolean bl = this.features.get(string);
            sAXParser.setFeature(string, bl);
        }
        return jXSAXParser;
    }

    @Override
    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.isSecure = bl;
            return;
        }
        if (string.equals("oracle.xml.parser.XMLParser.ContentModelDeterministic")) {
            this.deterministic = bl;
            return;
        }
        if (string.equals("oracle.xml.schema/Ignore_Duplicate_Components")) {
            this.ignoreSchemaDuplicate = bl;
        } else if (string.equals("oracle.xdkjava.security.resolveEntityDefault")) {
            this.resolveEntityDefault = bl;
            return;
        }
        if (!SAXParser.isFeatureRecognized(string)) {
            String string2 = err.getMessage1(20500, string);
            throw new SAXNotRecognizedException(string2);
        }
        if (!SAXParser.isFeatureSupported(string)) {
            String string3 = err.getMessage1(20501, string);
            throw new SAXNotSupportedException(string3);
        }
        if (!SAXParser.canSetFeature(string, bl)) {
            String string4 = err.getMessage1(20501, string);
            throw new ParserConfigurationException(string4);
        }
        this.features.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.isSecure;
        }
        if (string.equals("oracle.xml.parser.XMLParser.ContentModelDeterministic")) {
            return this.deterministic;
        }
        if (string.equals("oracle.xml.schema/Ignore_Duplicate_Components")) {
            return this.ignoreSchemaDuplicate;
        }
        if (string.equals("oracle.xdkjava.security.resolveEntityDefault")) {
            return this.resolveEntityDefault;
        }
        if (!SAXParser.isFeatureRecognized(string)) {
            String string2 = err.getMessage1(20500, string);
            throw new SAXNotRecognizedException(string2);
        }
        if (!SAXParser.isFeatureSupported(string)) {
            String string3 = err.getMessage1(20501, string);
            throw new SAXNotSupportedException(string3);
        }
        if (!SAXParser.canSetFeature(string, true) && !SAXParser.canSetFeature(string, false)) {
            String string4 = err.getMessage1(20501, string);
            throw new ParserConfigurationException(string4);
        }
        Boolean bl = this.features.get(string);
        if (bl == null) {
            bl = SAXParser.getFeatureDefault(string);
        }
        return bl;
    }
}

