/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.math.BigDecimal;
import java.util.ArrayList;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathCompileEventsHandler;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprBase;

public class XPathCompileEvents {
    private XPathCompileEventsHandler handler;
    private ArrayList<XPathStep> steps;

    public void setXPathCompileEventsHandler(XPathCompileEventsHandler xPathCompileEventsHandler) {
        this.handler = xPathCompileEventsHandler;
    }

    public XPathCompileEventsHandler getXPathCompileEventsHandler() {
        return this.handler;
    }

    ArrayList makeXSLExprBaseList(FastVector fastVector) {
        if (fastVector == null || fastVector.size() == 0) {
            return null;
        }
        int n = fastVector.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(fastVector.elementAt(i));
        }
        return arrayList;
    }

    ArrayList addXPathStep(XPathStep xPathStep) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        this.steps.add(xPathStep);
        return this.steps;
    }

    void reportEventsNoParam(int n, int n2) {
        this.reportEvents(n, n2, 0, 0, 0.0, null, false, false, null, null, null, null, null, null);
    }

    void reportEventsWithIntParam(int n, int n2, int n3, int n4) {
        this.reportEvents(n, n2, n3, n4, 0.0, null, false, false, null, null, null, null, null, null);
    }

    void reportEventsWithDoubleParam(int n, int n2, double d, BigDecimal bigDecimal) {
        this.reportEvents(n, n2, 0, 0, d, bigDecimal, false, false, null, null, null, null, null, null);
    }

    void reportEventsWithBooleanParam(int n, int n2, boolean bl, boolean bl2) {
        this.reportEvents(n, n2, 0, 0, 0.0, null, bl, bl2, null, null, null, null, null, null);
    }

    void reportEventsWithStringParam(int n, int n2, String string, String string2, String string3) {
        this.reportEvents(n, n2, 0, 0, 0.0, null, false, false, string, string2, string3, null, null, null);
    }

    void reportEventsWithObjectParam(int n, int n2, XSLExprBase xSLExprBase, ArrayList arrayList, Object object) {
        this.reportEvents(n, n2, 0, 0, 0.0, null, false, false, null, null, null, xSLExprBase, arrayList, object);
    }

    void reportEventsWithStringList(int n, int n2, String string, String string2, String string3, ArrayList arrayList) {
        this.reportEvents(n, n2, 0, 0, 0.0, null, false, false, string, string2, string3, null, arrayList, null);
    }

    void reportEventsWithIntStringParam(int n, int n2, int n3, int n4, String string, String string2, String string3) {
        this.reportEvents(n, n2, n3, n4, 0.0, null, false, false, string, string2, string3, null, null, null);
    }

    void reportEvents(int n, int n2, int n3, int n4, double d, BigDecimal bigDecimal, boolean bl, boolean bl2, String string, String string2, String string3, XSLExprBase xSLExprBase, ArrayList arrayList, Object object) {
        switch (n) {
            case 102: {
                if (n2 == 0) {
                    this.handler.startAdditiveExpr();
                    break;
                }
                this.handler.endAdditiveExpr(n3);
                break;
            }
            case 103: {
                if (n2 == 0) {
                    this.handler.startAllNodeStep(n3);
                    break;
                }
                this.handler.endAllNodeStep();
                break;
            }
            case 104: {
                if (n2 == 0) {
                    this.handler.startAndExpr();
                    break;
                }
                this.handler.endAndExpr(bl);
                break;
            }
            case 105: {
                if (n2 == 0) {
                    this.handler.startCommentNodeStep(n3);
                    break;
                }
                this.handler.endCommentNodeStep();
                break;
            }
            case 106: {
                if (n2 == 0) {
                    this.handler.startEqualityExpr();
                    break;
                }
                this.handler.endEqualityExpr(n3);
                break;
            }
            case 107: {
                if (n2 == 0) {
                    this.handler.startFilterExpr();
                    break;
                }
                this.handler.endFilterExpr();
                break;
            }
            case 108: 
            case 302: {
                if (n2 == 0) {
                    this.handler.startFunction(string, string2);
                    break;
                }
                this.handler.endFunction();
                break;
            }
            case 109: {
                if (n2 != 1) break;
                this.handler.endLocationPath();
                break;
            }
            case 110: {
                if (n2 == 0) {
                    this.handler.startMultiplicativeExpr();
                    break;
                }
                this.handler.endMultiplicativeExpr(n3);
                break;
            }
            case 112: {
                if (n2 == 0) {
                    this.handler.startOrExpr();
                    break;
                }
                this.handler.endOrExpr(bl);
                break;
            }
            case 113: {
                if (n2 == 0) {
                    this.handler.startPathExpr();
                    break;
                }
                this.handler.endPathExpr();
                break;
            }
            case 114: {
                if (n2 == 0) {
                    this.handler.startPredicate();
                    break;
                }
                this.handler.endPredicate();
                break;
            }
            case 115: {
                if (n2 == 0) {
                    this.handler.startProcessingInstructionNodeStep(n3, string);
                    break;
                }
                this.handler.endProcessingInstructionNodeStep();
                break;
            }
            case 116: {
                if (n2 == 0) {
                    this.handler.startRelationalExpr();
                    break;
                }
                this.handler.endRelationalExpr(n3);
                break;
            }
            case 118: {
                if (n2 != 1) break;
                this.handler.endStep();
                break;
            }
            case 119: {
                if (n2 == 0) {
                    this.handler.startTextNodeStep(n3);
                    break;
                }
                this.handler.endTextNodeStep();
                break;
            }
            case 120: {
                if (n2 == 0) {
                    this.handler.startUnaryExpr();
                    break;
                }
                this.handler.endUnaryExpr(n3);
                break;
            }
            case 121: {
                if (n2 == 0) {
                    this.handler.startUnionExpr();
                    break;
                }
                this.handler.endUnionExpr(bl);
                break;
            }
            case 122: {
                if (n2 == 0) {
                    this.handler.startXPath();
                    break;
                }
                this.handler.endXPath();
                break;
            }
            case 123: {
                this.handler.literal(string);
                break;
            }
            case 126: {
                this.handler.number(n3);
                break;
            }
            case 236: {
                this.handler.NumericLiteral(n3);
                break;
            }
            case 124: {
                this.handler.number(d);
                break;
            }
            case 238: {
                this.handler.NumericLiteral(d);
                break;
            }
            case 125: {
                this.handler.number(bigDecimal);
                break;
            }
            case 237: {
                this.handler.NumericLiteral(bigDecimal);
                break;
            }
            case 127: {
                this.handler.variableReference(string, string2);
                break;
            }
            case 235: {
                this.handler.VarRef(string, string2);
                break;
            }
            case 201: {
                if (n2 == 0) {
                    this.handler.startCastExpr();
                    break;
                }
                this.handler.endCastExpr();
                break;
            }
            case 202: {
                if (n2 == 0) {
                    this.handler.startContextItemExpr();
                    break;
                }
                this.handler.endContextItemExpr();
                break;
            }
            case 301: {
                if (n2 == 0) {
                    this.handler.startOracleExtFunction(string, string2, string3);
                    break;
                }
                this.handler.endOracleExtFunction();
                break;
            }
            case 203: {
                if (n2 == 0) {
                    this.handler.startPrimaryExpr();
                    break;
                }
                this.handler.endPrimaryExpr();
                break;
            }
            case 204: {
                if (n2 == 0) {
                    this.handler.startDocumentTest();
                    break;
                }
                this.handler.endDocumentTest();
                break;
            }
            case 205: {
                if (n2 == 0) {
                    this.handler.startAnyKindTest();
                    break;
                }
                this.handler.endAnyKindTest();
                break;
            }
            case 206: {
                if (n2 == 0) {
                    this.handler.startAttributeTest();
                    break;
                }
                this.handler.endAttributeTest();
                break;
            }
            case 207: {
                if (n2 == 0) {
                    this.handler.startCommentTest();
                    break;
                }
                this.handler.endCommentTest();
                break;
            }
            case 208: {
                if (n2 == 0) {
                    this.handler.startElementTest();
                    break;
                }
                this.handler.endElementTest();
                break;
            }
            case 209: {
                if (n2 == 0) {
                    this.handler.startPITest();
                    break;
                }
                this.handler.endPITest();
                break;
            }
            case 210: {
                if (n2 == 0) {
                    this.handler.startSchemaAttributeTest();
                    break;
                }
                this.handler.endSchemaAttributeTest();
                break;
            }
            case 211: {
                if (n2 == 0) {
                    this.handler.startSchemaElementTest();
                    break;
                }
                this.handler.endSchemaElementTest();
                break;
            }
            case 212: {
                if (n2 == 0) {
                    this.handler.startTextTest();
                    break;
                }
                this.handler.endTextTest();
                break;
            }
            case 213: {
                if (n2 == 0) {
                    this.handler.startKindTest();
                    break;
                }
                this.handler.endKindTest();
                break;
            }
            case 214: {
                if (n2 == 0) {
                    this.handler.startItemType();
                    break;
                }
                this.handler.endItemType();
                break;
            }
            case 215: {
                if (n2 == 0) {
                    this.handler.startAtomicType();
                    break;
                }
                this.handler.endAtomicType();
                break;
            }
            case 216: {
                this.handler.OccurrenceIndicator(n3);
                break;
            }
            case 217: {
                if (n2 == 0) {
                    this.handler.startExprSingle();
                    break;
                }
                this.handler.endExprSingle();
                break;
            }
            case 218: {
                if (n2 == 0) {
                    this.handler.startForExpr();
                    break;
                }
                this.handler.endForExpr();
                break;
            }
            case 219: {
                if (n2 == 0) {
                    this.handler.startQuantifiedExpr(n3);
                    break;
                }
                this.handler.endQuantifiedExpr();
                break;
            }
            case 220: {
                if (n2 == 0) {
                    this.handler.startIfExpr();
                    break;
                }
                this.handler.endIfExpr();
                break;
            }
            case 221: {
                if (n2 == 0) {
                    this.handler.startInstanceOfExpr();
                    break;
                }
                this.handler.endInstanceOfExpr();
                break;
            }
            case 222: {
                if (n2 == 0) {
                    this.handler.startTreatExpr();
                    break;
                }
                this.handler.endTreatExpr();
                break;
            }
            case 223: {
                if (n2 == 0) {
                    this.handler.startCastableAsExpr();
                    break;
                }
                this.handler.endCastableAsExpr();
                break;
            }
            case 224: {
                if (n2 == 0) {
                    this.handler.startComparisonExpr();
                    break;
                }
                this.handler.endComparisonExpr(n3);
                break;
            }
            case 225: {
                if (n2 == 0) {
                    this.handler.startRangeExpr();
                    break;
                }
                this.handler.endRangeExpr();
                break;
            }
            case 226: {
                if (n2 == 0) {
                    this.handler.startIntersectExceptExpr();
                    break;
                }
                this.handler.endIntersectExceptExpr(n3);
                break;
            }
            case 227: {
                this.handler.OPGeneralComp(n3);
                break;
            }
            case 228: {
                this.handler.OPValueComp(n3);
                break;
            }
            case 229: {
                this.handler.OPNodeComp(n3);
                break;
            }
            case 230: {
                this.handler.hitForwardAxis(n3);
                break;
            }
            case 231: {
                this.handler.hitReverseAxis(n3);
                break;
            }
            case 232: {
                this.handler.hitQName(string, string2);
                break;
            }
            case 233: {
                this.handler.hitWildcard(n3, string, string2);
                break;
            }
            case 234: {
                this.handler.hitAbbrevReverseStep();
                break;
            }
            case 240: {
                if (n2 != 1) break;
                this.handler.endSingleType(string, string2);
                break;
            }
            case 241: {
                if (n2 == 0) {
                    this.handler.startSequenceType();
                    break;
                }
                this.handler.endSequenceType();
                break;
            }
            case 242: {
                this.handler.hitEmptySequence();
                break;
            }
            case 243: {
                if (n2 == 0) {
                    this.handler.startRelativePathExpr();
                    break;
                }
                this.handler.endRelativePathExpr();
                break;
            }
            case 101: {
                if (n2 == 0) {
                    this.handler.startAbsoluteLocationPath();
                    break;
                }
                this.handler.endAbsoluteLocationPath();
                break;
            }
            case 117: {
                if (n2 == 0) {
                    this.handler.startRelativeLocationPath();
                    break;
                }
                this.handler.endRelativeLocationPath();
                break;
            }
            case 401: {
                this.handler.addParameters(string, string2, arrayList);
                break;
            }
            case 402: {
                this.handler.addPredicates((XPathPredicate)object, arrayList);
                break;
            }
            case 403: {
                this.handler.addSteps((PathExpr)xSLExprBase, arrayList);
                this.steps = null;
                break;
            }
            default: {
                System.out.println("Unexpected event!!!!");
            }
        }
    }

    public static void printOccurence(int n) {
        switch (n) {
            case 0: {
                System.out.println("occ is: " + n + " and which is EMPTY.");
                break;
            }
            case 1: {
                System.out.println("occ is: " + n + " and which is EXACTLY_ONE.");
                break;
            }
            case 2: {
                System.out.println("occ is: " + n + " and which is ZERO_OR_ONE.");
                break;
            }
            case 3: {
                System.out.println("occ is: " + n + " and which is ONE_OR_MORE.");
                break;
            }
            case 4: {
                System.out.println("occ is: " + n + " and which is ZERO_OR_MORE.");
                break;
            }
            default: {
                System.out.println("occ is: " + n + " and which is INVALID.");
            }
        }
    }

    public static void printMathSign(int n) {
        switch (n) {
            case 200: {
                System.out.println("math sign is: " + n + " and which is PLUS.");
                break;
            }
            case 201: {
                System.out.println("math sign is: " + n + " and which is MINUS.");
                break;
            }
            case 216: {
                System.out.println("math sign is: " + n + " and which is EQUAL.");
                break;
            }
            case 217: {
                System.out.println("math sign is: " + n + " and which is NOTEQUAL.");
                break;
            }
            case 202: {
                System.out.println("math sign is: " + n + " and which is MULT.");
                break;
            }
            case 203: {
                System.out.println("math sign is: " + n + " and which is DIV.");
                break;
            }
            case 204: {
                System.out.println("math sign is: " + n + " and which is IDIV.");
                break;
            }
            case 205: {
                System.out.println("math sign is: " + n + " and which is MOD.");
                break;
            }
            case 220: {
                System.out.println("math sign is: " + n + " and which is GREATERTHAN.");
                break;
            }
            case 218: {
                System.out.println("math sign is: " + n + " and which is LESSTHAN.");
                break;
            }
            case 221: {
                System.out.println("math sign is: " + n + " and which is NOTLESSTHAN.");
                break;
            }
            case 219: {
                System.out.println("math sign is: " + n + " and which is NOTGREATERTHAN.");
                break;
            }
            case 208: {
                System.out.println("math sign is: " + n + " and which is IS.");
                break;
            }
            case 209: {
                System.out.println("math sign is: " + n + " and which is ISNOT.");
                break;
            }
            case 210: {
                System.out.println("math sign is: " + n + " and which is EQ.");
                break;
            }
            case 211: {
                System.out.println("math sign is: " + n + " and which is NE.");
                break;
            }
            case 212: {
                System.out.println("math sign is: " + n + " and which is LT.");
                break;
            }
            case 213: {
                System.out.println("math sign is: " + n + " and which is LE.");
                break;
            }
            case 214: {
                System.out.println("math sign is: " + n + " and which is GT.");
                break;
            }
            case 215: {
                System.out.println("math sign is: " + n + " and which is GE.");
                break;
            }
            case 222: {
                System.out.println("math sign is: " + n + " and which is NODEBEFORE.");
                break;
            }
            case 223: {
                System.out.println("math sign is: " + n + " and which is NODEAFTER.");
                break;
            }
            default: {
                System.out.println("math sign is: " + n + " and which is INVALID.");
            }
        }
    }

    public static void printOperator(int n) {
        switch (n) {
            case 14: {
                System.out.println("operator is: " + n + " and which is SOME_DOLLAR.");
                break;
            }
            case 15: {
                System.out.println("operator is: " + n + " and which is EVERY_DOLLAR.");
                break;
            }
            case 206: {
                System.out.println("operator is: " + n + " and which is INTERSECT.");
                break;
            }
            case 207: {
                System.out.println("operator is: " + n + " and which is EXCEPT.");
                break;
            }
            default: {
                System.out.println("operator is: " + n + " and which is INVALID.");
            }
        }
    }

    public static void printAxis(int n) {
        switch (n) {
            case 0: 
            case 508: {
                System.out.println("axis is: " + n + " and which is ANCESTOR.");
                break;
            }
            case 1: 
            case 513: {
                System.out.println("axis is: " + n + " and which is ANCESTOR_SELF.");
                break;
            }
            case 2: 
            case 503: {
                System.out.println("axis is: " + n + " and which is ATTRIBUTE.");
                break;
            }
            case 3: 
            case 501: {
                System.out.println("axis is: " + n + " and which is CHILD.");
                break;
            }
            case 4: 
            case 502: {
                System.out.println("axis is: " + n + " and which is DESCENDANT.");
                break;
            }
            case 5: 
            case 510: {
                System.out.println("axis is: " + n + " and which is DESC_SELF.");
                break;
            }
            case 6: 
            case 505: {
                System.out.println("axis is: " + n + " and which is FOLLOWING.");
                break;
            }
            case 7: 
            case 511: {
                System.out.println("axis is: " + n + " and which is FOLLOWING_SIBLING.");
                break;
            }
            case 8: 
            case 507: {
                System.out.println("axis is: " + n + " and which is PARENT.");
                break;
            }
            case 9: 
            case 509: {
                System.out.println("axis is: " + n + " and which is PRECEDING.");
                break;
            }
            case 10: 
            case 512: {
                System.out.println("axis is: " + n + " and which is PRECEDING_SIBLING.");
                break;
            }
            case 11: 
            case 504: {
                System.out.println("axis is: " + n + " and which is SELF.");
                break;
            }
            case 12: 
            case 506: {
                System.out.println("axis is: " + n + " and which is NAMESPACE.");
                break;
            }
            default: {
                System.out.println("axis is: " + n + " and which is INVALID.");
            }
        }
    }

    public static void printNodeTest(int n) {
        switch (n) {
            case 450: {
                System.out.println("nodetest is: " + n + " and which is STAR_NT.");
                break;
            }
            case 451: {
                System.out.println("nodetest is: " + n + " and which is QNAME_NT.");
                break;
            }
            case 452: {
                System.out.println("nodetest is: " + n + " and which is STARNS_NT.");
                break;
            }
            case 453: {
                System.out.println("nodetest is: " + n + " and which is NSSTAR_NT.");
                break;
            }
            default: {
                System.out.println("nodetest is: " + n + " and which is INVALID.");
            }
        }
    }
}

