/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathContextItemExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathExtFunction;
import oracle.xml.xpath.XPathFunctionCall;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathVarReference;
import oracle.xml.xpath.XPathXSLFunction;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;

class XPathFilterExpr
extends XSLExprBase {
    XPathFilterExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        if (xSLParseString.isPattern() && xSLParseString.peekToken() == 113) {
            String string = xSLParseString.getLocalName();
            if (string.equals("id") || string.equals("key")) {
                return XPathFunctionCall.parse(xSLParseString);
            }
            return null;
        }
        XSLExprBase xSLExprBase = XPathFilterExpr.getPrimaryExpr(xSLParseString);
        if (xSLExprBase == null) {
            return null;
        }
        if ((xSLExprBase.exprType & 0xA00000) > 0 && xSLParseString.peekToken() == 27) {
            xSLExprBase.predicates = new XPathPredicate(xSLParseString);
        }
        if (xSLExprBase instanceof XPathFilterExpr) {
            if (xSLExprBase.predicates != null) {
                if (xSLParseString.isCachingExpr() && !xSLExprBase.canCacheExpr()) {
                    xSLExprBase.cacheSubExpr();
                }
            } else {
                xSLExprBase = xSLExprBase.leftExpr;
            }
        }
        return xSLExprBase;
    }

    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.leftExpr.evaluate(xPathRuntimeContext);
        this.filterPredicates(xPathRuntimeContext);
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        this.predicates.cacheSubExpr();
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.predicates.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(')');
        stringBuffer.append(this.predicates.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN();
    }

    private static XSLExprBase getPrimaryExpr(XSLParseString xSLParseString) throws XSLException, XQException {
        int n = xSLParseString.peekToken();
        switch (n) {
            case 113: {
                String string = xSLParseString.getLocalName();
                String string2 = xSLParseString.getNamespace();
                int n2 = xSLParseString.getFunctionType();
                if (n2 == 600) {
                    if (string.equals("true") || string.equals("false")) {
                        return XPathConstantExpr.parse(xSLParseString);
                    }
                    return XPathFunctionCall.parse(xSLParseString);
                }
                if (n2 == 601) {
                    return XPathExtFunction.parse(xSLParseString);
                }
                return XPathXSLFunction.parse(xSLParseString);
            }
            case 7: {
                return XPathVarReference.parse(xSLParseString);
            }
            case 109: {
                return XPathConstantExpr.parse(xSLParseString);
            }
            case 3: {
                return XPathContextItemExpr.parse(xSLParseString);
            }
            case 25: {
                xSLParseString.nextToken();
                XPathFilterExpr xPathFilterExpr = new XPathFilterExpr();
                xPathFilterExpr.leftExpr = XSLExpr.parse(xSLParseString);
                xPathFilterExpr.setExprType(xPathFilterExpr.leftExpr.getExprType());
                if (xSLParseString.nextToken() != 26) {
                    throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                }
                return xPathFilterExpr;
            }
        }
        return null;
    }
}

