/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class XPathConvertAsExpr
extends XSLExprBase {
    OXMLSequenceType eType;
    boolean notgeneric;
    boolean atomic;
    boolean numeric;
    boolean flt;
    boolean dbl;
    boolean str;

    XPathConvertAsExpr(XSLExprBase xSLExprBase, OXMLSequenceType oXMLSequenceType) {
        this.leftExpr = xSLExprBase;
        this.eType = oXMLSequenceType;
        this.atomic = this.eType.isOfType(OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE);
        this.notgeneric = this.eType != OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE && this.eType != OXMLSequenceType.ANYATOMIC_ONE && this.eType != OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE;
        this.numeric = this.eType.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE) || this.eType.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_MORE) || this.eType.isOfType(OXMLSequenceType.NUMERIC_ONE);
        this.dbl = this.eType.isOfTypeIgnoreOccurence(OXMLSequenceType.TDOUBLE);
        this.flt = this.eType.isOfTypeIgnoreOccurence(OXMLSequenceType.TFLOAT);
        this.str = this.eType.isOfTypeIgnoreOccurence(OXMLSequenceType.TSTRING);
    }

    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.leftExpr.evaluate(xPathRuntimeContext);
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
        if (!this.atomic) {
            if (!xPathSequence.isOfType(this.eType)) {
                throw new XPathException(23006);
            }
            return;
        }
        xPathSequence.atomizeInPlace();
        if (this.notgeneric) {
            while (xPathSequence.next()) {
                OXMLItem oXMLItem = xPathSequence.getItem();
                if (oXMLItem.matchesType(OXMLSequenceType.TUNTYPED)) {
                    if (this.numeric) {
                        oXMLItem.convert(OXMLSequenceType.TDOUBLE);
                    } else {
                        oXMLItem.convert(this.eType);
                    }
                }
                if (this.numeric) {
                    int n = oXMLItem.getPrimitiveType();
                    if (this.dbl) {
                        if (n == 3 || n == 5 || n == 22) {
                            oXMLItem.convert(OXMLSequenceType.TDOUBLE);
                        }
                    } else if (this.flt && n == 5) {
                        oXMLItem.convert(OXMLSequenceType.TFLOAT);
                    }
                }
                if (!this.str || !oXMLItem.matchesType(OXMLSequenceType.TANYURI)) continue;
                oXMLItem.convert(OXMLSequenceType.TSTRING);
            }
        }
        if (!xPathSequence.isOfType(this.eType)) {
            throw new XPathException(23006);
        }
        XPathSequence.restart(xPathSequence);
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN();
    }

    String getNormalizedExpr() {
        return "";
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    void cacheSubExpr() {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }
}

