/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import oracle.i18n.text.OraNormalizer;

public class UnicodeUtil {
    static OraNormalizer uninormalizer = OraNormalizer.getInstance();
    private static String allHexDigits = "0123456789abcdefABCDEF";

    public static String normalizeUnicodeNFC(String string) {
        return uninormalizer.compose(string);
    }

    public static char[] normalizeUnicodeNFC(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if ((string = uninormalizer.compose(string)) != null) {
            return string.toCharArray();
        }
        return null;
    }

    public static String normalizeUnicode(String string, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return uninormalizer.normalize(string, n);
            }
            case 65536: {
                return string;
            }
            case 65537: {
                return uninormalizer.compose(string);
            }
        }
        return string;
    }

    public static char[] normalizeUnicode(char[] cArray, int n, int n2, int n3) {
        String string = new String(cArray, n, n2);
        if ((string = UnicodeUtil.normalizeUnicode(string, n3)) != null) {
            return string.toCharArray();
        }
        return null;
    }

    public static String normalize2RFC2396(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            if (c <= ' ' || c >= '\u007f') {
                UnicodeUtil.escape(c, i + 1 < string.length() ? string.charAt(i + 1) : (char)' ', stringBuffer);
                continue;
            }
            if (c == '%') {
                if (i + 2 < string.length() && allHexDigits.indexOf(string.charAt(i + 1)) >= 0 && allHexDigits.indexOf(string.charAt(i + 2)) >= 0) {
                    stringBuffer.append(c);
                    continue;
                }
                UnicodeUtil.escape(c, ' ', stringBuffer);
                continue;
            }
            if ("-_.!~*'();/?:@&=+$,#".indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            UnicodeUtil.escape(c, ' ', stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static void escape(char c, char c2, StringBuffer stringBuffer) {
        String string = "0123456789ABCDEF";
        byte[] byArray = new byte[4];
        int n = UnicodeUtil.getUTF8Encoding(c, c2, byArray);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] >= 0 ? byArray[i] : 256 + byArray[i];
            stringBuffer.append('%');
            stringBuffer.append(string.charAt(n2 / 16));
            stringBuffer.append(string.charAt(n2 % 16));
        }
    }

    private static int getUTF8Encoding(char c, char c2, byte[] byArray) {
        char c3 = c;
        if (c3 <= '\u007f') {
            byArray[0] = (byte)c3;
            return 1;
        }
        if (c3 <= '\u07ff') {
            byArray[0] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[1] = (byte)(0x80 | c & 0x3F);
            return 2;
        }
        if (c3 >= '\ud800' && c3 <= '\udbff') {
            char c4 = c2;
            if (c4 < '\udc00' || c4 > '\udfff') {
                throw new IllegalArgumentException("Malformed Unicode Surrogate Pair (" + c3 + "," + c4 + ")");
            }
            byte by = (byte)(c4 & 0x3F);
            byte by2 = (byte)((c3 & 3) << 4 | c4 >> 6 & 0xF);
            byte by3 = (byte)(c3 >> 2 & 0xF);
            byte by4 = (byte)((c3 >> 6 & 0xF) + 1);
            byArray[0] = (byte)(0xF0 | by4 >> 2 & 7);
            byArray[1] = (byte)(0x80 | (by4 & 3) << 4 | by3);
            byArray[2] = (byte)(0x80 | by2);
            byArray[3] = (byte)(0x80 | by);
            return 4;
        }
        if (c3 >= '\udc00' && c3 <= '\udfff') {
            return 0;
        }
        byArray[0] = (byte)(0xE0 | c >> 12 & 0xF);
        byArray[1] = (byte)(0x80 | c >> 6 & 0x3F);
        byArray[2] = (byte)(0x80 | c & 0x3F);
        return 3;
    }
}

