/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import oracle.xml.parser.v2.XMLDOMEvent;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLRangeEvent;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLTraversalEvent;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public class XMLNSNode
extends XMLNode
implements Externalizable {
    private static final long serialVersionUID = 2132947022094272960L;

    XMLNSNode() {
    }

    XMLNSNode(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    public NodeList getChildNodes() {
        return this.getDocument().nl_init(this);
    }

    public Node getFirstChild() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetFirstChild();
            }
            case 2: {
                long l = this.xdbGetFirstChild(this.xdbGetCtx(), this.nodeId);
                if (l == 0L) break;
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node getLastChild() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetLastChild();
            }
            case 2: {
                long l = this.xdbGetLastChild(this.xdbGetCtx(), this.nodeId);
                if (l == 0L) break;
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        XMLDocument xMLDocument = this.getDocument();
        XMLNode xMLNode = (XMLNode)node;
        if (this.getValidChecking() && this.canAppendChild(node) == 6) {
            throw new XMLDOMException(16);
        }
        switch (this.flags & 3) {
            case 1: {
                Object object;
                if (xMLNode instanceof XMLDocumentFragment) {
                    Node node2 = xMLNode.getFirstChild();
                    while (node2 != null) {
                        this.appendChild(node2);
                        node2 = xMLNode.getFirstChild();
                    }
                    return xMLNode;
                }
                if (this.getDocument().getAccessMode() > 0) {
                    throw new XMLDOMException(15, 21028, this.getXMLError(), this.getAccessString());
                }
                this.checkNodePermissions(xMLNode, null);
                if (this.isDocumentFlag(65536) && (object = xMLNode.xdkGetParentNode()) != null) {
                    this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode, (XMLNode)object, null, null, null, true, false, (short)0);
                    xMLNode.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
                }
                xMLNode.xdkRemoveNode();
                xMLNode.xdkSetPrevNode(null);
                xMLNode.xdkSetNextNode(null);
                if (this.xdkGetFirstChild() == null) {
                    if (this.getNodeType() == 2) {
                        object = this.xdkGetNodeValue();
                        if (object != "" && object != null) {
                            XMLText xMLText = (XMLText)this.getDocument().createTextNode((String)object);
                            this.xdkSetFirstChild(xMLText);
                            xMLNode.xdkSetPrevNode(xMLText);
                            xMLText.xdkSetNextNode(xMLNode);
                            this.xdkSetLastChild(xMLNode);
                        } else {
                            this.xdkSetFirstChild(xMLNode);
                        }
                        this.xdkSetNodeValue(null);
                    } else {
                        this.xdkSetFirstChild(xMLNode);
                    }
                } else {
                    object = this.xdkGetLastChild();
                    xMLNode.xdkSetPrevNode((XMLNode)object);
                    ((XMLNode)object).xdkSetNextNode(xMLNode);
                }
                xMLNode.xdkSetParentNode(this);
                this.xdkSetLastChild(xMLNode);
                if (this.isNodeFlag(32) && xMLDocument != null) {
                    xMLDocument.nl_reset(this);
                }
                if (this.isScalable()) {
                    xMLNode.xdkKeepNode();
                }
                if (this.isDocumentFlag(65536)) {
                    if (this.isDocumentFlag(131072)) {
                        object = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_INSERT_EVENT");
                        ((XMLRangeEvent)object).initRangeEvent("RANGE_INSERT_EVENT", false, false, xMLNode, null, null, null, null);
                        ((XMLDOMEvent)object).setTarget(xMLDocument);
                        xMLDocument.dispatchEvent((Event)object);
                    }
                    this.fireDOMMutationEvent("DOMNodeInserted", xMLNode, this, null, null, null, true, false, (short)0);
                    xMLNode.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
                    this.fireDOMMutationEvent("DOMSubtreeModified", this, null, null, null, null, true, false, (short)0);
                }
                return xMLNode;
            }
            case 2: {
                long l = this.xdbAppendChild(this.xdbGetCtx(), this.nodeId, xMLNode.nodeId);
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        XMLDocument xMLDocument = this.getDocument();
        XMLNode xMLNode = (XMLNode)node;
        if (this.getValidChecking() && this.canRemoveChild(node) == 6) {
            throw new XMLDOMException(16);
        }
        switch (this.flags & 3) {
            case 1: {
                Object object;
                if (xMLNode.getParentNode() != this) {
                    throw new XMLDOMException(8, 21012, this.getXMLError());
                }
                if (this.getDocument().getAccessMode() > 0) {
                    throw new XMLDOMException(15, 21028, this.getXMLError(), this.getAccessString());
                }
                if (this.isDocumentFlag(131072)) {
                    object = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_DELETE_EVENT");
                    ((XMLRangeEvent)object).initRangeEvent("RANGE_DELETE_EVENT", false, false, xMLNode, null, null, null, null);
                    ((XMLDOMEvent)object).setTarget(xMLDocument);
                    xMLDocument.dispatchEvent((Event)object);
                }
                if (this.isDocumentFlag(262144)) {
                    object = (XMLTraversalEvent)xMLDocument.createTraversalEvent("TRAVERSAL_DELETE_EVENT");
                    ((XMLTraversalEvent)object).initTraversalEvent("TRAVERSAL_DELETE_EVENT", false, false, xMLNode, null, null, null, null);
                    ((XMLDOMEvent)object).setTarget(xMLDocument);
                    xMLDocument.dispatchEvent((Event)object);
                }
                if (this.isDocumentFlag(65536)) {
                    this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode, this, null, null, null, true, false, (short)0);
                    xMLNode.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
                    this.fireDOMMutationEvent("DOMSubtreeModified", this, null, null, null, null, true, false, (short)0);
                }
                object = xMLNode.xdkGetNextNode();
                XMLNode xMLNode2 = xMLNode.xdkGetPrevNode();
                if (object == null) {
                    this.xdkSetLastChild(xMLNode2);
                } else {
                    ((XMLNode)object).xdkSetPrevNode(xMLNode2);
                }
                if (xMLNode2 == null) {
                    this.xdkSetFirstChild(object);
                } else {
                    xMLNode2.xdkSetNextNode(object);
                }
                xMLNode.xdkSetNextNode(null);
                xMLNode.xdkSetPrevNode(null);
                xMLNode.xdkSetParentNode(null);
                if (this.isScalable()) {
                    if (object != null) {
                        ((XMLNode)object).xdkKeepNode();
                    } else if (xMLNode2 != null) {
                        xMLNode2.xdkKeepNode();
                    } else {
                        this.xdkKeepNode();
                    }
                }
                if (this.isNodeFlag(32) && xMLDocument != null) {
                    xMLDocument.nl_reset(this);
                }
                return xMLNode;
            }
            case 2: {
                long l = this.xdbGetParentNode(this.xdbGetCtx(), xMLNode.nodeId);
                if (l != this.nodeId) {
                    throw new XMLDOMException(8, 21012, this.getXMLError());
                }
                l = this.xdbRemoveChild(this.xdbGetCtx(), this.nodeId, xMLNode.nodeId);
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        XMLDocument xMLDocument = this.getDocument();
        XMLNode xMLNode = (XMLNode)node2;
        XMLNode xMLNode2 = (XMLNode)node;
        if (this.getValidChecking() && this.canInsertBefore(node, node2) == 6) {
            throw new XMLDOMException(16);
        }
        switch (this.flags & 3) {
            case 1: {
                XMLNode xMLNode3;
                if (xMLNode == null) {
                    return this.appendChild(xMLNode2);
                }
                if (xMLNode2 instanceof XMLDocumentFragment) {
                    Node node3 = xMLNode2.getFirstChild();
                    while (node3 != null) {
                        this.insertBefore(node3, xMLNode);
                        node3 = xMLNode2.getFirstChild();
                    }
                    return xMLNode2;
                }
                if (this.getDocument().getAccessMode() > 0) {
                    throw new XMLDOMException(15, 21028, this.getXMLError(), this.getAccessString());
                }
                this.checkNodePermissions(xMLNode2, xMLNode);
                if (this.isDocumentFlag(65536) && (xMLNode3 = xMLNode2.xdkGetParentNode()) != null) {
                    this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode2, xMLNode3, null, null, null, true, false, (short)0);
                    xMLNode2.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
                }
                xMLNode2.xdkRemoveNode();
                xMLNode3 = xMLNode.xdkGetPrevNode();
                xMLNode2.xdkSetPrevNode(xMLNode3);
                xMLNode2.xdkSetNextNode(xMLNode);
                xMLNode.xdkSetPrevNode(xMLNode2);
                if (xMLNode3 == null) {
                    this.xdkSetFirstChild(xMLNode2);
                } else {
                    xMLNode3.xdkSetNextNode(xMLNode2);
                }
                xMLNode2.xdkSetParentNode(this);
                if (this.isNodeFlag(32) && xMLDocument != null) {
                    xMLDocument.nl_reset(this);
                }
                if (this.isScalable()) {
                    xMLNode2.xdkKeepNode();
                }
                if (this.isDocumentFlag(131072)) {
                    XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_INSERT_EVENT");
                    xMLRangeEvent.initRangeEvent("RANGE_INSERT_EVENT", false, false, xMLNode2, null, null, null, null);
                    xMLRangeEvent.setTarget(xMLDocument);
                    xMLDocument.dispatchEvent(xMLRangeEvent);
                }
                if (this.isDocumentFlag(65536)) {
                    this.fireDOMMutationEvent("DOMNodeInserted", xMLNode2, this, null, null, null, true, false, (short)0);
                    xMLNode2.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
                    this.fireDOMMutationEvent("DOMSubtreeModified", this, null, null, null, null, true, false, (short)0);
                }
                return xMLNode2;
            }
            case 2: {
                if (xMLNode == null) {
                    return this.appendChild(xMLNode2);
                }
                long l = this.xdbInsertBefore(this.xdbGetCtx(), this.nodeId, xMLNode2.nodeId, xMLNode.nodeId);
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        XMLDocument xMLDocument = this.getDocument();
        XMLNode xMLNode = (XMLNode)node;
        XMLNode xMLNode2 = (XMLNode)node2;
        if (this.getValidChecking() && this.canReplaceChild(node, node2) == 6) {
            throw new XMLDOMException(16);
        }
        switch (this.flags & 3) {
            case 1: {
                Object object;
                if (xMLNode instanceof XMLDocumentFragment) {
                    Node node3 = xMLNode.getFirstChild();
                    while (node3 != null) {
                        this.insertBefore(node3, xMLNode2);
                        node3 = xMLNode.getFirstChild();
                    }
                    return this.removeChild(xMLNode2);
                }
                if (this.getDocument().getAccessMode() > 0) {
                    throw new XMLDOMException(15, 21028, this.getXMLError(), this.getAccessString());
                }
                this.checkNodePermissions(xMLNode, xMLNode2);
                if (this.isDocumentFlag(131072)) {
                    object = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_REPLACE_EVENT");
                    ((XMLRangeEvent)object).initRangeEvent("RANGE_REPLACE_EVENT", false, false, xMLNode2, xMLNode, null, null, null);
                    ((XMLDOMEvent)object).setTarget(xMLDocument);
                    xMLDocument.dispatchEvent((Event)object);
                }
                if (this.isDocumentFlag(262144)) {
                    object = (XMLTraversalEvent)xMLDocument.createTraversalEvent("TRAVERSAL_REPLACE_EVENT");
                    ((XMLTraversalEvent)object).initTraversalEvent("TRAVERSAL_REPLACE_EVENT", false, false, xMLNode2, xMLNode, null, null, null);
                    ((XMLDOMEvent)object).setTarget(xMLDocument);
                    xMLDocument.dispatchEvent((Event)object);
                }
                if (this.isDocumentFlag(65536)) {
                    this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode2, this, null, null, null, true, false, (short)0);
                    xMLNode2.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
                    this.fireDOMMutationEvent("DOMSubtreeModified", this, null, null, null, null, true, false, (short)0);
                    object = xMLNode.xdkGetParentNode();
                    if (object != null) {
                        this.fireDOMMutationEvent("DOMNodeRemoved", xMLNode, (XMLNode)object, null, null, null, true, false, (short)0);
                        xMLNode.fireDocumentMutationEvent("DOMNodeRemovedFromDocument");
                    }
                }
                xMLNode.xdkRemoveNode();
                object = xMLNode2.xdkGetPrevNode();
                XMLNode xMLNode3 = xMLNode2.xdkGetNextNode();
                xMLNode.xdkSetNextNode(xMLNode3);
                xMLNode.xdkSetPrevNode((XMLNode)object);
                if (object == null) {
                    this.xdkSetFirstChild(xMLNode);
                } else {
                    ((XMLNode)object).xdkSetNextNode(xMLNode);
                }
                if (xMLNode3 == null) {
                    this.xdkSetLastChild(xMLNode);
                } else {
                    xMLNode3.xdkSetPrevNode(xMLNode);
                }
                xMLNode.xdkSetParentNode(this);
                xMLNode2.xdkSetNextNode(null);
                xMLNode2.xdkSetPrevNode(null);
                xMLNode2.xdkSetParentNode(null);
                if (this.isNodeFlag(32) && xMLDocument != null) {
                    xMLDocument.nl_reset(this);
                }
                if (this.isScalable()) {
                    xMLNode.xdkKeepNode();
                }
                if (this.isDocumentFlag(65536)) {
                    this.fireDOMMutationEvent("DOMNodeInserted", xMLNode, this, null, null, null, true, false, (short)0);
                    xMLNode.fireDocumentMutationEvent("DOMNodeInsertedIntoDocument");
                    this.fireDOMMutationEvent("DOMSubtreeModified", this, null, null, null, null, true, false, (short)0);
                }
                return xMLNode2;
            }
            case 2: {
                long l = this.xdbReplaceChild(this.xdbGetCtx(), this.nodeId, xMLNode.nodeId, xMLNode2.nodeId);
                return this.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public void normalize() {
        XMLNode xMLNode = null;
        for (XMLNode xMLNode2 = (XMLNode)this.getFirstChild(); xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
            if (xMLNode2.getNodeType() == 3) {
                xMLNode = (XMLNode)xMLNode2.getNextSibling();
                while (xMLNode != null && xMLNode.getNodeType() == 3) {
                    xMLNode2.setNodeValue(xMLNode2.getNodeValue() + xMLNode.getNodeValue());
                    this.removeChild(xMLNode);
                    xMLNode = (XMLNode)xMLNode2.getNextSibling();
                }
                if (xMLNode2.getText().equals("")) {
                    this.removeChild(xMLNode2);
                }
                if (xMLNode == null) {
                    return;
                }
                xMLNode2 = xMLNode;
            }
            xMLNode2.normalize();
        }
    }

    public XMLNode addText(String string) throws XMLDOMException {
        if (this.getDocument().getAccessMode() > 0) {
            throw new XMLDOMException(15, 21028, this.getXMLError(), this.getAccessString());
        }
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        this.addText(cArray, 0, n);
        return (XMLNode)this.getLastChild();
    }

    public void addText(char[] cArray, int n, int n2) throws XMLDOMException {
        boolean bl;
        if (this.getDocument().getAccessMode() > 0) {
            throw new XMLDOMException(15, 21028, this.getXMLError(), this.getAccessString());
        }
        XMLNode xMLNode = (XMLNode)this.getLastChild();
        boolean bl2 = bl = xMLNode == null || xMLNode.getNodeType() != 3;
        if (bl) {
            XMLDocument xMLDocument = this.getDocument();
            XMLText xMLText = (XMLText)xMLDocument.createTextNode(new String(cArray, n, n2));
            this.appendChild(xMLText);
        } else {
            if (xMLNode.isNodeFlag(2048)) {
                xMLNode.xdkKeepNode();
            }
            ((XMLText)xMLNode).addText(cArray, n, n2);
        }
    }

    public String getText() {
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        if (xMLNode != null) {
            String string = "";
            StringBuffer stringBuffer = null;
            while (xMLNode != null) {
                String string2;
                short s = xMLNode.getNodeType();
                if (s != 8 && s != 7 && (string2 = xMLNode.getText()) != null && string2 != "") {
                    if (string == "") {
                        string = string2;
                    } else {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(string2);
                    }
                }
                xMLNode = (XMLNode)xMLNode.getNextSibling();
            }
            if (stringBuffer != null) {
                return stringBuffer.toString();
            }
            return string;
        }
        return super.getText();
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        this.printChildren(xMLOutputStream, bl);
    }

    void printChildren(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        for (XMLNode xMLNode = (XMLNode)this.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            xMLNode.print(xMLOutputStream, bl);
        }
    }

    void checkChildType(int n) throws DOMException {
        throw new XMLDOMException(3, 21003, this.getXMLError(), XMLUtil.nodeTypeToString(n), XMLUtil.nodeTypeToString(this.getNodeType()));
    }

    protected void checkDocument(XMLNode xMLNode) throws DOMException {
        XMLDocument xMLDocument = xMLNode.getDocument();
        XMLDocument xMLDocument2 = this.getDocument();
        if (xMLDocument2 != xMLDocument) {
            if (xMLDocument.isNodeFlag(0x100000)) {
                xMLNode.setDescDocument(xMLDocument2);
                return;
            }
            if (xMLDocument2.isNodeFlag(0x100000)) {
                this.setDescDocument(xMLDocument);
                return;
            }
            throw new XMLDOMException(4, 21006, this.getXMLError());
        }
    }

    void checkAncestry(XMLNode xMLNode) throws DOMException {
        for (XMLNode xMLNode2 = this; xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getParentNode()) {
            if (xMLNode2 != xMLNode) continue;
            throw new XMLDOMException(3, 21002, this.getXMLError());
        }
    }

    void checkNodePermissions(XMLNode xMLNode, XMLNode xMLNode2) {
        this.checkChildType(xMLNode.getNodeType());
        XMLDocument xMLDocument = this.getDocument();
        XMLDocument xMLDocument2 = xMLNode.getDocument();
        if (xMLDocument != xMLDocument2) {
            if (xMLDocument2.isNodeFlag(0x100000)) {
                xMLNode.setDescDocument(xMLDocument);
                return;
            }
            if (xMLDocument.isNodeFlag(0x100000)) {
                this.setDescDocument(xMLDocument2);
                return;
            }
            throw new XMLDOMException(4, 21006, this.getXMLError());
        }
        for (XMLNode xMLNode3 = this; xMLNode3 != null; xMLNode3 = (XMLNode)xMLNode3.getParentNode()) {
            if (xMLNode3 != xMLNode) continue;
            throw new XMLDOMException(3, 21002, this.getXMLError());
        }
        if (xMLNode2 != null) {
            if (xMLNode == xMLNode2) {
                throw new XMLDOMException(3, 21002, this.getXMLError());
            }
            if (xMLNode2.getParentNode() != this) {
                throw new XMLDOMException(8, 21012, this.getXMLError());
            }
        }
        xMLDocument.setDocOrdered(false);
    }

    public String getNodeLocalName() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getLocalPart();
            }
            case 2: {
                return this.xdbGetLocalName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }
}

