/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.xdb.XMLType;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.DBBinXMLMetadataProvider;
import oracle.xml.util.XMLError;

class DBBinXMLMetadataProviderImpl
implements DBBinXMLMetadataProvider,
BinXMLConstants {
    Connection metaconn = null;
    Connection dataconn = null;
    Driver driver;
    HashMap map = new HashMap(1);
    Class cls = null;
    XMLError err;
    String guid = null;

    DBBinXMLMetadataProviderImpl() throws BinXMLException {
        try {
            this.cls = Class.forName("oracle.xdb.XMLTypeFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BinXMLException(this.err.getMessage1(35002, "oracle.xdb.XMLTypeFactory"));
        }
        this.map.put("SYS.XMLTYPE", this.cls);
    }

    public void setConnection(Connection connection) throws BinXMLException, SQLException {
        this.metaconn = connection;
        this.metaconn.setTypeMap(this.map);
    }

    public void setConnectionPool(OracleDataSource oracleDataSource) throws BinXMLException, SQLException {
        if (oracleDataSource instanceof OracleOCIConnectionPool) {
            Properties properties = oracleDataSource.getConnectionProperties();
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("connpool_increment", "0");
            properties.put("connpool_max_limit", "2");
            properties.put("connpool_min_limit", "1");
            oracleDataSource.setConnectionProperties(properties);
        }
        this.metaconn = oracleDataSource.getConnection();
        this.metaconn.setTypeMap(this.map);
    }

    public void setDriver(Driver driver) {
        this.driver = driver == null ? new OracleDriver() : driver;
    }

    public void setURL(URL uRL, String string, String string2) throws BinXMLException, SQLException {
        String string3 = uRL.getHost();
        String string4 = "";
        if (uRL.getPort() > 0) {
            string4 = new Integer(uRL.getPort()).toString();
        }
        String string5 = uRL.getPath();
        String string6 = string3;
        if (string4.length() > 0) {
            string6 = string6 + ":" + string4;
        }
        if (string5 != null) {
            string6 = string6 + "/" + string5;
        }
        if (this.driver == null) {
            DriverManager.registerDriver((Driver)new OracleDriver());
        } else {
            DriverManager.registerDriver(this.driver);
        }
        this.metaconn = DriverManager.getConnection(string6, string, string2);
        this.metaconn.setTypeMap(this.map);
    }

    public void setConnStr(String string, String string2, String string3) throws BinXMLException, SQLException {
        if (this.driver == null) {
            DriverManager.registerDriver((Driver)new OracleDriver());
        } else {
            DriverManager.registerDriver(this.driver);
        }
        this.metaconn = DriverManager.getConnection(string, string2, string3);
        this.metaconn.setTypeMap(this.map);
    }

    public void associateDataConnection(Connection connection) throws BinXMLException {
        this.dataconn = this.metaconn == null ? connection : this.metaconn;
    }

    public boolean isSchemaAnnotationAvailable() throws BinXMLException {
        return true;
    }

    public Reader getCompiledSchema(BinXMLVocabId binXMLVocabId) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string = "begin ? := dbms_csx_int.getCompiledSchemaByID(?); end;";
            CallableStatement callableStatement = connection.prepareCall(string);
            callableStatement.setBytes(2, binXMLVocabId.getVocabID());
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            String string2 = xMLType.getStringVal();
            char[] cArray = string2.toCharArray();
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            callableStatement.close();
            xMLType.close();
            return charArrayReader;
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    public Reader getCompiledSchema(String string) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string2 = "begin ? := dbms_csx_int.getCompiledSchema(?); end;";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(2, string);
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            if (xMLType == null) {
                return null;
            }
            String string3 = xMLType.getStringVal();
            char[] cArray = string3.toCharArray();
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            callableStatement.close();
            xMLType.close();
            return charArrayReader;
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    public BinXMLVocabId saveSchema(String string) throws BinXMLException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        this.saveSchema(string, uRL);
        return this.getSchemaID(string);
    }

    public BinXMLVocabId saveCompiledSchema(String string) throws BinXMLException {
        return null;
    }

    public BinXMLStream getDTD(BinXMLVocabId binXMLVocabId) throws BinXMLException {
        return null;
    }

    public BinXMLStream getDTD(String string) throws BinXMLException {
        return null;
    }

    public BinXMLVocabId saveDTD(String string) throws BinXMLException {
        return null;
    }

    public BinXMLStream getTokenSet(String string, boolean bl) throws BinXMLException {
        long l = bl ? 1L : 0L;
        return this.getTokenSet(string, l);
    }

    public Connection getConnection() {
        return this.metaconn;
    }

    BinXMLVocabId getSchemaID(String string) throws BinXMLException {
        Connection connection = this.getConnectionInUse();
        String string2 = "select SCHEMA_URL, SCHEMA_ID from ALL_XML_SCHEMAS";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (!string3.equals(string)) continue;
                byte[] byArray = (byte[])resultSet.getObject(2);
                BinXMLVocabId binXMLVocabId = new BinXMLVocabId();
                binXMLVocabId.setVocabID(byArray);
                statement.close();
                return binXMLVocabId;
            }
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
        return null;
    }

    private boolean isSchemaRegistered(String string) throws BinXMLException {
        Connection connection = this.getConnectionInUse();
        String string2 = "select SCHEMA_URL, SCHEMA_ID from USER_XML_SCHEMAS";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (!string3.equals(string)) continue;
                statement.close();
                return true;
            }
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
        return false;
    }

    private void saveSchema(String string, URL uRL) throws BinXMLException {
        if (uRL == null) {
            return;
        }
        if (this.isSchemaRegistered(string)) {
            return;
        }
        Connection connection = this.getConnectionInUse();
        String string2 = "begin dbms_xmlschema.registerSchema(?, ?, true, false, false, false, false, '', 2, 2); end;";
        try {
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            XMLType xMLType = this.createXMLType(uRL, connection);
            callableStatement.setObject(2, (Object)xMLType);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    private XMLType createXMLType(URL uRL, Connection connection) throws BinXMLException {
        try {
            InputStream inputStream = uRL.openStream();
            XMLType xMLType = XMLType.createXML((Connection)connection, (InputStream)inputStream);
            return xMLType;
        }
        catch (IOException iOException) {
            throw new BinXMLException(iOException);
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    private BinXMLStream getTokenSet(String string, long l) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string2 = null;
            string2 = this.guid != null ? "begin ? := dbms_csx_int.getVocabularyFromToken(?, ?, ?, ?,?); end;" : "begin ? := dbms_csx_int.getVocabularyFromToken(?, ?, ?, ?); end;";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(2, string);
            callableStatement.setLong(3, l);
            callableStatement.setLong(4, 0L);
            callableStatement.setLong(5, 0L);
            if (this.guid != null) {
                callableStatement.setString(6, this.guid);
            }
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            callableStatement.close();
            return xMLType.getBinXMLStream();
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    public BinXMLStream getTokenSet(long l) throws BinXMLException {
        return this.getTokenSet(l, false);
    }

    public BinXMLStream getTokenSet(long l, boolean bl) throws BinXMLException {
        long l2 = bl ? 0L : 1L;
        BinXMLStream binXMLStream = this.getTokenSet(l, l2);
        if (binXMLStream != null) {
            return binXMLStream;
        }
        return this.getTokenSet(l, l2);
    }

    private BinXMLStream getTokenSet(long l, long l2) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string = null;
            string = this.guid != null ? "begin ? := dbms_csx_int.getVocabulary(?, ?,?); end;" : "begin ? := dbms_csx_int.getVocabulary(?, ?); end;";
            CallableStatement callableStatement = connection.prepareCall(string);
            callableStatement.setLong(2, l);
            callableStatement.setLong(3, l2);
            if (this.guid != null) {
                callableStatement.setString(4, this.guid);
            }
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            callableStatement.close();
            return xMLType.getBinXMLStream();
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    BinXMLStream getNamespaceIDfromXDBByPLSQL(String string) throws BinXMLException {
        try {
            Connection connection = this.getConnectionInUse();
            String string2 = null;
            string2 = this.guid != null ? "begin ? := dbms_csx_int.getVocabularyFromToken(?, ?, ?, ?,?); end;" : "begin ? := dbms_csx_int.getVocabularyFromToken(?, ?, ?, ?); end;";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(2, string);
            callableStatement.setLong(3, 0L);
            callableStatement.setLong(4, 0L);
            callableStatement.setLong(5, 0L);
            if (this.guid != null) {
                callableStatement.setString(6, this.guid);
            }
            callableStatement.registerOutParameter(1, 2007, "SYS.XMLTYPE");
            callableStatement.execute();
            XMLType xMLType = (XMLType)callableStatement.getObject(1, this.map);
            callableStatement.close();
            return xMLType.getBinXMLStream();
        }
        catch (SQLException sQLException) {
            throw new BinXMLException(sQLException);
        }
    }

    public BinXMLVocabId saveTokenSet(String string) throws BinXMLException {
        return null;
    }

    private Connection getConnectionInUse() {
        if (this.metaconn != null) {
            return this.metaconn;
        }
        return this.dataconn;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void setGUID(String string) {
        this.guid = string;
    }
}

