/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CSocketInputStreamWrapper;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CMAREngineStream
extends T4CMAREngine {
    NetInputStream inStream;
    NetOutputStream outStream;
    byte[] nativeUB2Buffer = new byte[2];
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    T4CMAREngineStream(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        this.net = communication;
        try {
            this.outStream = new T4CSocketOutputStreamWrapper((NetOutputStream)communication.getOutputStream(), communication.getSessionAttributes());
            this.inStream = new T4CSocketInputStreamWrapper((NetInputStream)communication.getInputStream(), (T4CSocketOutputStreamWrapper)this.outStream, communication.getSessionAttributes());
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new T4CTypeRep(this, false);
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    @Override
    final void marshalSB1(byte by) throws IOException {
        this.marshalSB2(by);
    }

    @Override
    final void marshalUB1(short s2) throws IOException {
        this.outStream.write((byte)(s2 & 0xFF));
    }

    @Override
    final void marshalSB2(short s2) throws IOException {
        if (s2 == 0) {
            this.outStream.write(0);
        } else {
            if (s2 < 0 || s2 > 256) {
                this.tmpBuffer10[0] = 2;
                this.tmpBuffer10[2] = (byte)(s2 & 0xFF);
                this.tmpBuffer10[1] = (byte)(s2 >> 8 & 0xFF);
            } else {
                this.tmpBuffer10[0] = 1;
                this.tmpBuffer10[1] = (byte)(s2 & 0xFF);
            }
            this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
    }

    @Override
    void marshalNativeUB2(short s2, boolean bl) throws IOException {
        if (bl) {
            this.nativeUB2Buffer[0] = (byte)(s2 & 0xFF);
            this.nativeUB2Buffer[1] = (byte)(s2 >>> 8 & 0xFF);
        } else {
            this.nativeUB2Buffer[1] = (byte)(s2 & 0xFF);
            this.nativeUB2Buffer[0] = (byte)(s2 >>> 8 & 0xFF);
        }
        this.outStream.write(this.nativeUB2Buffer);
    }

    @Override
    final void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    @Override
    final void marshalSB4(int n2) throws IOException {
        if (n2 == 0) {
            this.outStream.write(0);
        } else {
            if (n2 < 0) {
                this.tmpBuffer10[0] = 4;
                this.tmpBuffer10[1] = (byte)(n2 >> 24 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 >> 16 & 0xFF);
                this.tmpBuffer10[3] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[4] = (byte)(n2 & 0xFF);
            } else if (n2 < 256) {
                this.tmpBuffer10[0] = 1;
                this.tmpBuffer10[1] = (byte)(n2 & 0xFF);
            } else if (n2 < 65536) {
                this.tmpBuffer10[0] = 2;
                this.tmpBuffer10[1] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 & 0xFF);
            } else if (n2 < 0x1000000) {
                this.tmpBuffer10[0] = 3;
                this.tmpBuffer10[1] = (byte)(n2 >> 16 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[3] = (byte)(n2 & 0xFF);
            } else {
                this.tmpBuffer10[0] = 4;
                this.tmpBuffer10[1] = (byte)(n2 >> 24 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 >> 16 & 0xFF);
                this.tmpBuffer10[3] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[4] = (byte)(n2 & 0xFF);
            }
            this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
    }

    @Override
    final void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    final void marshalUB8(long l2) throws IOException {
        this.marshalSB8(l2);
    }

    @Override
    final void marshalSB8(long l2) throws IOException {
        if (l2 == 0L) {
            this.outStream.write(0);
        } else {
            if (l2 < 0L) {
                this.tmpBuffer10[0] = 8;
                this.tmpBuffer10[1] = (byte)(l2 >> 56 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 48 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[7] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[8] = (byte)(l2 & 0xFFL);
            } else if (l2 < 256L) {
                this.tmpBuffer10[0] = 1;
                this.tmpBuffer10[1] = (byte)(l2 & 0xFFL);
            } else if (l2 < 65536L) {
                this.tmpBuffer10[0] = 2;
                this.tmpBuffer10[1] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x1000000L) {
                this.tmpBuffer10[0] = 3;
                this.tmpBuffer10[1] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x100000000L) {
                this.tmpBuffer10[0] = 4;
                this.tmpBuffer10[1] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x10000000000L) {
                this.tmpBuffer10[0] = 5;
                this.tmpBuffer10[1] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x1000000000000L) {
                this.tmpBuffer10[0] = 6;
                this.tmpBuffer10[1] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x100000000000000L) {
                this.tmpBuffer10[0] = 7;
                this.tmpBuffer10[1] = (byte)(l2 >> 48 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[7] = (byte)(l2 & 0xFFL);
            } else {
                this.tmpBuffer10[0] = 8;
                this.tmpBuffer10[1] = (byte)(l2 >> 56 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 48 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[7] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[8] = (byte)(l2 & 0xFFL);
            }
            this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
    }

    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n2, n3);
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalSB2();
        return by;
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            s2 = (short)this.inStream.read();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        if (s2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
        }
        return s2;
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        boolean bl;
        int n2 = 0;
        int n3 = this.inStream.readB1();
        boolean bl2 = bl = n3 > 128;
        if (bl) {
            n3 &= 0x7F;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2);
                n2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        if (bl) {
            n2 *= -1;
        }
        return (short)n2;
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        int n2 = 0;
        switch (this.inStream.readB1()) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2);
                n2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            case 3: {
                this.inStream.read(this.tmpBuffer4, 0, 3);
                n2 = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        return n2 & 0xFFFF;
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        boolean bl;
        int n2 = 0;
        int n3 = this.inStream.readB1();
        boolean bl2 = bl = n3 > 128;
        if (bl) {
            n3 &= 0x7F;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2, 0, 2);
                n2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            case 3: {
                this.inStream.read(this.tmpBuffer4, 0, 3);
                n2 = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                break;
            }
            case 4: {
                this.inStream.read(this.tmpBuffer4, 0, 4);
                n2 = this.tmpBuffer4[0] << 24 & 0xFF000000 | this.tmpBuffer4[1] << 16 & 0xFF0000 | this.tmpBuffer4[2] << 8 & 0xFF00 | this.tmpBuffer4[3] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        if (bl) {
            n2 *= -1;
        }
        return n2;
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        long l2 = 0L;
        switch (this.inStream.readB1()) {
            case 0: {
                break;
            }
            case 1: {
                l2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2, 0, 2);
                l2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            case 3: {
                this.inStream.read(this.tmpBuffer4, 0, 3);
                l2 = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                break;
            }
            case 4: {
                this.inStream.read(this.tmpBuffer4, 0, 4);
                l2 = this.tmpBuffer4[0] << 24 & 0xFF000000 | this.tmpBuffer4[1] << 16 & 0xFF0000 | this.tmpBuffer4[2] << 8 & 0xFF00 | this.tmpBuffer4[3] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        return l2;
    }

    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            try {
                if (this.inStream.read(byArray) < 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                throw socketTimeoutException;
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
        }
        return byArray;
    }

    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        for (n4 = 0; n4 < n3; n4 += this.getNBytes(byArray, n2 + n4, n3 - n4)) {
        }
        return n4;
    }

    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        int n4 = 0;
        try {
            n4 = this.inStream.read(byArray, n2, n3);
            if (n4 < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return n4;
    }

    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            if (this.inStream.read(byArray) < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            try {
                if (this.inStream.read(byArray2, n3, 1) < 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                throw socketTimeoutException;
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if (byArray2[n3++] != 0) continue;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    @Override
    final long buffer2Value(byte by) throws SQLException, IOException {
        try {
            long l2 = 0L;
            int n2 = 1;
            if ((this.types.rep[by] & 1) > 0) {
                n2 = this.inStream.readB1();
            } else {
                switch (by) {
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 4;
                        break;
                    }
                    case 3: {
                        n2 = 8;
                    }
                }
            }
            l2 = (this.types.rep[by] & 2) > 0 ? this.inStream.readLongLSB(n2) : this.inStream.readLongMSB(n2);
            return l2;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
    }

    @Override
    void setByteOrder(byte by) throws IOException {
    }

    @Override
    protected void flush() throws IOException {
        ((T4CSocketOutputStreamWrapper)this.outStream).flush(true);
    }

    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        this.outStream.flush();
        this.outStream.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        if (bl) {
            this.outStream.flush();
        }
        this.outStream.writeZeroCopyIOHeader(bl, n2, bl2);
    }

    @Override
    void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        this.outStream.writeZeroCopyIOData(byArray, n2, n3);
    }

    @Override
    void clearWriteBuffer() {
        ((T4CSocketOutputStreamWrapper)this.outStream).bIndex = 0;
    }

    @Override
    final void prepareForUnmarshalAsync(Consumer<Throwable> consumer) {
        consumer.accept(new UnsupportedOperationException("Asynchronous IO is not supported when oracle.jdbc.javaNetNio=false"));
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$31 = T4CMAREngineStream.class.getDeclaredConstructor(Communication.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CMAREngineStream.class.getDeclaredMethod("prepareForUnmarshalAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CMAREngineStream.class.getDeclaredMethod("clearWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CMAREngineStream.class.getDeclaredMethod("writeZeroCopyIOData", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CMAREngineStream.class.getDeclaredMethod("writeZeroCopyIOHeader", Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CMAREngineStream.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CMAREngineStream.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CMAREngineStream.class.getDeclaredMethod("setByteOrder", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CMAREngineStream.class.getDeclaredMethod("buffer2Value", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalTEXT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CMAREngineStream.class.getDeclaredMethod("getNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CMAREngineStream.class.getDeclaredMethod("getNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalUB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalSB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalSB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalUB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CMAREngineStream.class.getDeclaredMethod("unmarshalSB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CMAREngineStream.class.getDeclaredMethod("marshalB1Array", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CMAREngineStream.class.getDeclaredMethod("marshalB1Array", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB4", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CMAREngineStream.class.getDeclaredMethod("marshalNativeUB2", Short.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB2", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CMAREngineStream.class.getDeclaredMethod("marshalUB1", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CMAREngineStream.class.getDeclaredMethod("marshalSB1", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMAREngineStream.class.getDeclaredMethod("initBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

