/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.jdbc.diagnostics.EncryptionStream;
import oracle.jdbc.diagnostics.MessageFormatUtils;
import oracle.jdbc.diagnostics.Releaser;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.diagnostics.SecuredLoggerImpl;
import oracle.jdbc.internal.Monitor;

final class SecuredMemoryLogHandler
extends Handler
implements Monitor {
    private final String loggerId;
    private final X509Certificate certificate;
    private String dumpFileLocation;
    private int bufferMaxSize = 10000;
    private boolean isOpen = false;
    private Object[] buffer;
    private int head;
    private int tail;
    private int available;
    private ConcurrentHashMap<String, String> headers;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private Properties userProperties = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;

    SecuredMemoryLogHandler(SecuredLoggerImpl securedLoggerImpl) {
        this.loggerId = securedLoggerImpl.getId();
        this.certificate = securedLoggerImpl.getCertificate();
        this.headers = securedLoggerImpl.getHeaders();
        this.userProperties = securedLoggerImpl.getUserProperties();
        this.configure();
        this.available = this.bufferMaxSize;
        if (this.dumpFileLocation != null) {
            this.buffer = new Object[this.bufferMaxSize];
            this.isOpen = true;
        } else {
            this.isOpen = false;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    public boolean isEmpty() {
        return this.available == this.bufferMaxSize;
    }

    private void configure() {
        String string = SecuredLogger.class.getName();
        this.dumpFileLocation = SecuredLogger.getStringProperty(string + ".logLocation", SecuredLogger.DEFAULT_LOG_LOCATION, this.userProperties);
        this.setFilter(SecuredLogger.getFilterProperty(string + ".filter", SecuredLogger.DEFAULT_FILTER, this.userProperties));
        this.setFormatter(SecuredLogger.getFormatterProperty(string + ".formatter", new SimpleFormatter(), this.userProperties));
        try {
            this.setEncoding(SecuredLogger.getStringProperty(string + ".encoding", null, this.userProperties));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void add(Level level, long l2, long l3, String string, String string2, String string3) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.addEvent(level, l2, l3, string, string2, string3, null, 0);
        }
    }

    public void add(Level level, long l2, long l3, String string, String string2, String string3, Object object, Releaser releaser) {
        boolean bl;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            bl = this.addEvent(level, l2, l3, string, string2, string3, releaser, 1);
            if (bl) {
                this.addToBuffer(object);
            }
        }
        if (!bl && releaser != null) {
            this.releaseParam(releaser, 1, object);
        }
    }

    public void add(Level level, long l2, long l3, String string, String string2, String string3, Object object, Object object2, Releaser releaser) {
        boolean bl;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            bl = this.addEvent(level, l2, l3, string, string2, string3, releaser, 2);
            if (bl) {
                this.addToBuffer(object);
                this.addToBuffer(object2);
            }
        }
        if (!bl && releaser != null) {
            this.releaseParam(releaser, 1, object);
            this.releaseParam(releaser, 2, object2);
        }
    }

    public void add(Level level, long l2, long l3, String string, String string2, String string3, Object object, Object object2, Object object3, Releaser releaser) {
        boolean bl;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            bl = this.addEvent(level, l2, l3, string, string2, string3, releaser, 3);
            if (bl) {
                this.addToBuffer(object);
                this.addToBuffer(object2);
                this.addToBuffer(object3);
            }
        }
        if (!bl && releaser != null) {
            this.releaseParam(releaser, 1, object);
            this.releaseParam(releaser, 2, object2);
            this.releaseParam(releaser, 3, object3);
        }
    }

    public void add(Level level, long l2, long l3, String string, String string2, String string3, Object object, Object object2, Object object3, Object object4, Releaser releaser) {
        boolean bl;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            bl = this.addEvent(level, l2, l3, string, string2, string3, releaser, 4);
            if (bl) {
                this.addToBuffer(object);
                this.addToBuffer(object2);
                this.addToBuffer(object3);
                this.addToBuffer(object4);
            }
        }
        if (!bl && releaser != null) {
            this.releaseParam(releaser, 1, object);
            this.releaseParam(releaser, 2, object2);
            this.releaseParam(releaser, 3, object3);
            this.releaseParam(releaser, 4, object4);
        }
    }

    public void add(Level level, long l2, long l3, String string, String string2, String string3, Releaser releaser, Object ... objectArray) {
        boolean bl;
        if (!this.isOpen) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            bl = this.addEvent(level, l2, l3, string, string2, string3, releaser, 1);
            if (bl) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.addToBuffer(objectArray[i2]);
                }
            }
        }
        if (!bl && releaser != null) {
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                this.releaseParam(releaser, i3 + 1, objectArray[i3]);
            }
        }
    }

    private boolean addEvent(Level level, long l2, long l3, String string, String string2, String string3, Releaser releaser, int n2) {
        int n3 = 9 + n2;
        if (n3 > this.bufferMaxSize) {
            throw new RuntimeException("Data length more than buffer length : " + n3);
        }
        if (n3 > this.available) {
            this.free(n3 - this.available);
        }
        this.addToBuffer(n3);
        this.addToBuffer(l2);
        this.addToBuffer(Thread.currentThread().getId());
        this.addToBuffer(string);
        this.addToBuffer(string2);
        this.addToBuffer(level);
        this.addToBuffer(l3);
        this.addToBuffer(string3);
        this.addToBuffer(releaser);
        this.available -= n3;
        return true;
    }

    private void releaseResources(Releaser releaser, Object[] objectArray, int n2, int n3) {
        int n4 = 1;
        int n5 = n2;
        while (n4 <= n3) {
            this.releaseParam(releaser, n4++, objectArray[n5++]);
            if (n5 != this.bufferMaxSize) continue;
            n5 = 0;
        }
    }

    private void releaseParam(Releaser releaser, int n2, Object object) {
        releaser.release(n2, object);
    }

    private void addToBuffer(Object object) {
        this.buffer[this.tail++] = object;
        if (this.tail == this.bufferMaxSize) {
            this.tail = 0;
        }
    }

    private void free(int n2) {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = (Integer)this.buffer[this.head];
            this.head = (this.head + n4) % this.bufferMaxSize;
            Object object = this.buffer[(this.head + 9 - 1) % this.bufferMaxSize];
            if (object == null) continue;
            this.releaseResources((Releaser)object, this.buffer, (this.head + 9) % this.bufferMaxSize, n4 - 9);
        }
        this.available += n3;
    }

    @Override
    public void close() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.isOpen = false;
        }
        if (!this.isEmpty()) {
            this.free(this.bufferMaxSize - this.available);
        }
        this.buffer = null;
        this.headers.clear();
    }

    public void dumpLog() {
        if (!this.isOpen || this.isEmpty()) {
            return;
        }
        try {
            int n2;
            ConcurrentHashMap<String, String> concurrentHashMap;
            int n3;
            int n4;
            Object[] objectArray;
            EncryptionStream encryptionStream = this.initializeEncryptionStream();
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                objectArray = this.buffer;
                n4 = this.head;
                n3 = this.tail;
                concurrentHashMap = this.headers;
                n2 = this.bufferMaxSize - this.available;
                this.reset();
            }
            this.publishHeader(concurrentHashMap, encryptionStream);
            this.publishDebugEvents(objectArray, n4, n3, encryptionStream, n2);
            encryptionStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void publishHeader(ConcurrentHashMap<String, String> concurrentHashMap, EncryptionStream encryptionStream) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(System.lineSeparator());
        concurrentHashMap.forEach((string, string2) -> stringBuilder.append(string + " = " + string2 + System.lineSeparator()));
        LogRecord logRecord = new LogRecord(Level.CONFIG, stringBuilder.toString());
        logRecord.setSourceClassName("Configurations");
        this.publish(logRecord, encryptionStream);
    }

    private void publishDebugEvents(Object[] objectArray, int n2, int n3, EncryptionStream encryptionStream, int n4) throws Exception {
        int n5;
        int n6 = n2;
        for (int i2 = n4; i2 > 0; i2 -= n5) {
            n5 = this.publishEvent(encryptionStream, objectArray, n6);
            n6 = (n6 + n5) % objectArray.length;
        }
    }

    private int publishEvent(EncryptionStream encryptionStream, Object[] objectArray, int n2) throws Exception {
        int n3 = (Integer)objectArray[n2];
        this.publish(this.createLogRecord(n2, objectArray, n3), encryptionStream);
        Releaser releaser = (Releaser)objectArray[(n2 + 9 - 1) % this.bufferMaxSize];
        if (releaser != null) {
            this.releaseResources(releaser, objectArray, (n2 + 9) % objectArray.length, n3 - 9);
        }
        return n3;
    }

    private LogRecord createLogRecord(int n2, Object[] objectArray, int n3) {
        LogRecord logRecord = new LogRecord((Level)SecuredLogger.Attribute.LOG_LEVEL.getAttributeValue(n2, objectArray), (String)SecuredLogger.Attribute.DEBUG_MESSAGE.getAttributeValue(n2, objectArray));
        logRecord.setSequenceNumber((Long)SecuredLogger.Attribute.EVENT_ID.getAttributeValue(n2, objectArray));
        logRecord.setSourceClassName((String)SecuredLogger.Attribute.CLASS_NAME.getAttributeValue(n2, objectArray));
        logRecord.setSourceMethodName((String)SecuredLogger.Attribute.METHOD_NAME.getAttributeValue(n2, objectArray));
        logRecord.setThreadID(((Long)SecuredLogger.Attribute.THREAD_ID.getAttributeValue(n2, objectArray)).intValue());
        logRecord.setMillis((Long)SecuredLogger.Attribute.EVENT_TIME.getAttributeValue(n2, objectArray));
        if (n3 > 9) {
            logRecord.setParameters(this.getDebugMessageParams(objectArray, n2 + 9, n3 - 9));
        }
        return logRecord;
    }

    EncryptionStream initializeEncryptionStream() {
        String string = "alert_ojdbc_" + this.loggerId + "_" + System.currentTimeMillis() + ".log";
        try {
            return EncryptionStream.newEncryptionStream(new FileOutputStream(this.dumpFileLocation + string), this.certificate);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        throw new UnsupportedOperationException();
    }

    public void publish(LogRecord logRecord, EncryptionStream encryptionStream) {
        if (!this.getFilter().isLoggable(logRecord)) {
            return;
        }
        try {
            String string = this.getFormatter().format(logRecord);
            encryptionStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void flush() {
    }

    private Object[] getDebugMessageParams(Object[] objectArray, int n2, int n3) {
        int n4 = objectArray.length;
        Object[] objectArray2 = new Object[n3];
        int n5 = n3;
        int n6 = n2;
        int n7 = 0;
        while (n5-- > 0) {
            Object object = objectArray[n6++ % n4];
            objectArray2[n7++] = MessageFormatUtils.formatLogParam(object);
        }
        return objectArray2;
    }

    public void reset() {
        if (this.dumpFileLocation == null) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.buffer = new Object[this.bufferMaxSize];
            this.tail = 0;
            this.head = 0;
            this.available = this.bufferMaxSize;
            this.headers = new ConcurrentHashMap();
            this.isOpen = true;
        }
    }

    public void disable() {
        this.close();
    }

    public void enable() {
        this.reset();
    }

    static {
        try {
            $$$methodRef$$$29 = SecuredMemoryLogHandler.class.getDeclaredConstructor(SecuredLoggerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = SecuredMemoryLogHandler.class.getDeclaredMethod("lambda$publishHeader$0", StringBuilder.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = SecuredMemoryLogHandler.class.getDeclaredMethod("enable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = SecuredMemoryLogHandler.class.getDeclaredMethod("disable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = SecuredMemoryLogHandler.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = SecuredMemoryLogHandler.class.getDeclaredMethod("getDebugMessageParams", Object[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = SecuredMemoryLogHandler.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = SecuredMemoryLogHandler.class.getDeclaredMethod("publish", LogRecord.class, EncryptionStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = SecuredMemoryLogHandler.class.getDeclaredMethod("publish", LogRecord.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = SecuredMemoryLogHandler.class.getDeclaredMethod("initializeEncryptionStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = SecuredMemoryLogHandler.class.getDeclaredMethod("createLogRecord", Integer.TYPE, Object[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SecuredMemoryLogHandler.class.getDeclaredMethod("publishEvent", EncryptionStream.class, Object[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SecuredMemoryLogHandler.class.getDeclaredMethod("publishDebugEvents", Object[].class, Integer.TYPE, Integer.TYPE, EncryptionStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SecuredMemoryLogHandler.class.getDeclaredMethod("publishHeader", ConcurrentHashMap.class, EncryptionStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SecuredMemoryLogHandler.class.getDeclaredMethod("dumpLog", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SecuredMemoryLogHandler.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SecuredMemoryLogHandler.class.getDeclaredMethod("free", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SecuredMemoryLogHandler.class.getDeclaredMethod("addToBuffer", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SecuredMemoryLogHandler.class.getDeclaredMethod("releaseParam", Releaser.class, Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SecuredMemoryLogHandler.class.getDeclaredMethod("releaseResources", Releaser.class, Object[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SecuredMemoryLogHandler.class.getDeclaredMethod("addEvent", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Releaser.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Releaser.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SecuredMemoryLogHandler.class.getDeclaredMethod("add", Level.class, Long.TYPE, Long.TYPE, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SecuredMemoryLogHandler.class.getDeclaredMethod("configure", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SecuredMemoryLogHandler.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SecuredMemoryLogHandler.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

