/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

public abstract class AbstractConnectionBuilder<T extends AbstractConnectionBuilder<T, U>, U> {
    private final T self = this;
    private boolean isImmutable = false;
    private String user = null;
    private OpaqueString password = null;
    private String serviceName = null;
    private String instanceName = null;
    private OracleShardingKey shardingKey = null;
    private OracleShardingKey superShardingKey = null;
    private GSSCredential gssCredential = null;
    private SSLContext sslContext = null;
    private boolean allowSingleShardTransaction = false;
    private boolean readOnlyInstanceAllowed = false;
    private Executor executor = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    protected AbstractConnectionBuilder() {
    }

    public final T password(@Blind String string) {
        this.ensureMutableState();
        this.password = OpaqueString.newOpaqueString(string);
        return this.self;
    }

    public T password(OpaqueString opaqueString) {
        this.ensureMutableState();
        this.password = opaqueString;
        return this.self;
    }

    public final T user(String string) {
        this.ensureMutableState();
        this.user = string;
        return this.self;
    }

    public final T serviceName(String string) {
        this.ensureMutableState();
        this.serviceName = string;
        return this.self;
    }

    public final T instanceName(String string) {
        this.ensureMutableState();
        this.instanceName = string;
        return this.self;
    }

    public final T shardingKey(OracleShardingKey oracleShardingKey) {
        this.ensureMutableState();
        this.shardingKey = oracleShardingKey;
        return this.self;
    }

    public final T superShardingKey(OracleShardingKey oracleShardingKey) {
        this.ensureMutableState();
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this.self;
    }

    public final T gssCredential(GSSCredential gSSCredential) {
        this.ensureMutableState();
        if (gSSCredential == null) {
            throw new NullPointerException("Argument to gssCredential(GSSCredential) is null");
        }
        this.gssCredential = gSSCredential;
        return this.self;
    }

    public final T sslContext(SSLContext sSLContext) {
        this.ensureMutableState();
        this.sslContext = sSLContext;
        return this.self;
    }

    public final T singleShardTransactionSupport(boolean bl) {
        this.ensureMutableState();
        this.allowSingleShardTransaction = bl;
        return this.self;
    }

    public final T readOnlyInstanceAllowed(boolean bl) {
        this.ensureMutableState();
        this.readOnlyInstanceAllowed = bl;
        return this.self;
    }

    public final String getUser() {
        return this.user;
    }

    public final OpaqueString getPassword() {
        return this.password;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    public final OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public final OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public final GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public final boolean getAllowSingleShardTransaction() {
        return this.allowSingleShardTransaction;
    }

    public final boolean getReadOnlyInstanceAllowed() {
        return this.readOnlyInstanceAllowed;
    }

    public final T copy(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        this.ensureMutableState();
        this.user = abstractConnectionBuilder.user;
        this.password = abstractConnectionBuilder.password;
        this.instanceName = abstractConnectionBuilder.instanceName;
        this.serviceName = abstractConnectionBuilder.serviceName;
        this.shardingKey = abstractConnectionBuilder.shardingKey;
        this.superShardingKey = abstractConnectionBuilder.superShardingKey;
        this.sslContext = abstractConnectionBuilder.sslContext;
        this.allowSingleShardTransaction = abstractConnectionBuilder.allowSingleShardTransaction;
        this.executor = abstractConnectionBuilder.executor;
        if (this.gssCredential != null) {
            this.gssCredential = abstractConnectionBuilder.gssCredential;
        }
        return this.self;
    }

    public final T executorOracle(Executor executor) {
        this.ensureMutableState();
        this.executor = executor;
        return this.self;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public abstract U build() throws SQLException;

    protected final void setImmutable() {
        this.isImmutable = true;
    }

    protected final void ensureMutableState() {
        if (this.isImmutable) {
            throw new IllegalStateException("This builder is immutable");
        }
    }

    static {
        try {
            $$$methodRef$$$26 = AbstractConnectionBuilder.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = AbstractConnectionBuilder.class.getDeclaredMethod("ensureMutableState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = AbstractConnectionBuilder.class.getDeclaredMethod("setImmutable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = AbstractConnectionBuilder.class.getDeclaredMethod("getExecutor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = AbstractConnectionBuilder.class.getDeclaredMethod("executorOracle", Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = AbstractConnectionBuilder.class.getDeclaredMethod("copy", AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = AbstractConnectionBuilder.class.getDeclaredMethod("getReadOnlyInstanceAllowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = AbstractConnectionBuilder.class.getDeclaredMethod("getAllowSingleShardTransaction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = AbstractConnectionBuilder.class.getDeclaredMethod("getSSLContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = AbstractConnectionBuilder.class.getDeclaredMethod("getGSSCredential", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = AbstractConnectionBuilder.class.getDeclaredMethod("getSuperShardingKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = AbstractConnectionBuilder.class.getDeclaredMethod("getShardingKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = AbstractConnectionBuilder.class.getDeclaredMethod("getInstanceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = AbstractConnectionBuilder.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = AbstractConnectionBuilder.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AbstractConnectionBuilder.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AbstractConnectionBuilder.class.getDeclaredMethod("readOnlyInstanceAllowed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AbstractConnectionBuilder.class.getDeclaredMethod("singleShardTransactionSupport", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AbstractConnectionBuilder.class.getDeclaredMethod("sslContext", SSLContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AbstractConnectionBuilder.class.getDeclaredMethod("gssCredential", GSSCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AbstractConnectionBuilder.class.getDeclaredMethod("superShardingKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AbstractConnectionBuilder.class.getDeclaredMethod("shardingKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AbstractConnectionBuilder.class.getDeclaredMethod("instanceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AbstractConnectionBuilder.class.getDeclaredMethod("serviceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AbstractConnectionBuilder.class.getDeclaredMethod("user", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AbstractConnectionBuilder.class.getDeclaredMethod("password", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AbstractConnectionBuilder.class.getDeclaredMethod("password", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

