/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import oracle.jdbc.OracleXAConnectionBuilder;
import oracle.jdbc.datasource.OracleXAConnection;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.XA, Feature.HIGH_AVAILABILITY, Feature.CONN_POOL, Feature.APPLICATION_CONTINUITY})
public abstract class OracleXADataSource
extends OracleConnectionPoolDataSource
implements oracle.jdbc.datasource.OracleXADataSource,
oracle.jdbc.replay.internal.OracleXADataSource {
    protected boolean useNativeXA = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public OracleXADataSource() throws SQLException {
        this.dataSourceName = "OracleXADataSource";
    }

    @Override
    public abstract XAConnection getXAConnection() throws SQLException;

    @Override
    public abstract XAConnection getXAConnection(String var1, @Blind String var2) throws SQLException;

    public abstract XAConnection getXAConnection(Properties var1) throws SQLException;

    @Override
    public void setURL(String string) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            super.setURL(string);
            if (string != null) {
                if (string.startsWith("jdbc:oracle:thin")) {
                    this.useNativeXA = true;
                } else if (string.startsWith("jdbc:oracle:oci") || string.startsWith("jdbc:oracle:oci8")) {
                    this.useNativeXA = false;
                }
            }
        }
    }

    public void setNativeXA(boolean bl) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.useNativeXA = bl;
        }
    }

    public boolean getNativeXA() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            boolean bl = this.useNativeXA;
            return bl;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public OracleXAConnectionBuilder createXAConnectionBuilder() {
        return new OracleXAConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public OracleXAConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = (OracleConnectionBuilderImpl)OracleXADataSource.this.createConnectionBuilder().copy(this);
                if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null && oracleConnectionBuilderImpl.getPassword() != OpaqueString.NULL)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                return (OracleXAConnection)((Object)OracleXADataSource.this.getPooledConnection(oracleConnectionBuilderImpl));
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OracleXADataSource.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$6 = OracleXADataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = OracleXADataSource.class.getDeclaredMethod("access$000", OracleXADataSource.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = OracleXADataSource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = OracleXADataSource.class.getDeclaredMethod("getNativeXA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = OracleXADataSource.class.getDeclaredMethod("setNativeXA", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = OracleXADataSource.class.getDeclaredMethod("setURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

