/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={Blob.class, OracleBlob.class, oracle.jdbc.internal.OracleBlob.class})
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableBlob
extends NonTxnReplayableBase
implements Replayable {
    private static final Method GETBINSTREAM_METHOD;
    private static final Method GETBINSTREAM_LONG_METHOD;
    private static final Method GETBINSTREAM_LONG_LONG_METHOD;
    private static final Method SETBINSTREAM_LONG_METHOD;
    protected boolean isFreed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    private static final Method getGetBinaryStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("setBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="free", args={})})
    protected void preForFree(Method method, Object object, Object ... objectArray) {
        this.isFreed = true;
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="setBytes", args={long.class, byte[].class}), @Signature(name="setBytes", args={long.class, byte[].class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForBlobWrites(Method method, Object object, Object ... objectArray) {
        block1: {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)object;
            nonTxnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob oracleBlob = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleBlob.canReadBasicLobDataInLocator() ? oracleBlob.getBinaryStream() : oracleBlob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), oracleBlob.getBufferSize(), 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob oracleBlob = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleBlob.canReadBasicLobDataInLocator() ? oracleBlob.getBinaryStream(l2) : oracleBlob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        if (GETBINSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            InputStream inputStream;
            oracle.jdbc.internal.OracleBlob oracleBlob = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleBlob.canReadBasicLobDataInLocator()) {
                inputStream = oracleBlob.getBinaryStream(l2, l3);
            } else {
                long l4 = oracleBlob.length();
                if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleBlob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2, l3);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (SETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set binary stream");
        }
        Method method = SETBINSTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob oracleBlob = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OutputStream outputStream = oracleBlob.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2, true);
            return (OutputStream)this.postForAll(method, outputStream);
        }
        catch (SQLException sQLException) {
            return (OutputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        return this.setBinaryStream(l2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleBlob oracleBlob = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
        return oracleBlob.getInternalConnection();
    }

    static {
        try {
            $$$methodRef$$$17 = NonTxnReplayableBlob.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableBlob.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableBlob.class.getDeclaredMethod("getBinaryOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableBlob.class.getDeclaredMethod("getBinaryOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableBlob.class.getDeclaredMethod("setBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableBlob.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableBlob.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableBlob.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableBlob.class.getDeclaredMethod("preForBlobWrites", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableBlob.class.getDeclaredMethod("preForFree", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableBlob.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableBlob.class.getDeclaredMethod("getSetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamLongLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETBINSTREAM_METHOD = NonTxnReplayableBlob.getGetBinaryStreamMethod();
        GETBINSTREAM_LONG_METHOD = NonTxnReplayableBlob.getGetBinaryStreamLongMethod();
        GETBINSTREAM_LONG_LONG_METHOD = NonTxnReplayableBlob.getGetBinaryStreamLongLongMethod();
        SETBINSTREAM_LONG_METHOD = NonTxnReplayableBlob.getSetBinaryStreamLongMethod();
    }
}

