/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;
import oracle.sql.RAW;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class RawCommonAccessor
extends Accessor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    RawCommonAccessor(OracleStatement oracleStatement, int n2, boolean bl) {
        super(Representation.RAW, oracleStatement, n2, bl);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, short s2, int n5) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDataAccess(n5, n4, null);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, long l2, int n8, short s2) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDescribe(n2, n4, bl, n5, n6, n7, l2, n8, s2, null);
        int n9 = oracleStatement.maxFieldSize;
        if (n9 > 0 && (n4 == 0 || n9 < n4)) {
            n4 = n9;
        }
        this.initForDataAccess(0, n4, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        if (n3 == 0) {
            return null;
        }
        return RepConversion.bArray2String(byArray);
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        return physicalConnection.conversion.ConvertStream(new ByteArrayInputStream(byArray), 2);
    }

    @Override
    InputStream getUnicodeStream(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        return physicalConnection.conversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        char[] cArray = new char[n3 << 1];
        int n4 = DBConversion.RAWBytesToHexChars(byArray, n3, cArray);
        return new CharArrayReader(cArray, 0, n4);
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getBytes(n2);
    }

    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        return this.getBytes(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getRAW(n2);
    }

    @Override
    RAW getRAW(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return new RAW(byArray);
    }

    static {
        try {
            $$$methodRef$$$11 = RawCommonAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = RawCommonAccessor.class.getDeclaredMethod("getRAW", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = RawCommonAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = RawCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = RawCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = RawCommonAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = RawCommonAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = RawCommonAccessor.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = RawCommonAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = RawCommonAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = RawCommonAccessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = RawCommonAccessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

