/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.internal.Monitor;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSFile;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface,
Monitor {
    private String tnsDir;
    private long nextPollTime;
    private ArrayList<TNSFile> tnsFiles;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;
    private static final int MAX_DEPTH = 5;
    private static final Pattern regexp;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public TNSNamesNamingAdapter(String string) {
        this.tnsDir = string;
        this.resetAttr();
    }

    private void resetAttr() {
        this.tnsFiles = new ArrayList(3);
        this.nextPollTime = 0L;
    }

    @Override
    public String resolve(String string) throws NetException {
        NVPair nVPair = null;
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.checkAndReload();
            for (TNSFile tNSFile : this.tnsFiles) {
                nVPair = tNSFile.getEntries().getNLPListElement(string);
                if (nVPair == null) continue;
                break;
            }
        }
        if (nVPair == null) {
            throw new NetException(122, "\"" + string + "\"");
        }
        return nVPair.valueToString();
    }

    private void loadFiles() throws NetException {
        File file = new File(this.tnsDir, TNSFILE);
        String string = file.getAbsolutePath();
        this.loadFiles(string, 0);
    }

    private void loadFiles(String string, int n2) throws NetException {
        if (n2 >= 5) {
            return;
        }
        File file = new File(string);
        if (!file.isFile() || !file.canRead()) {
            return;
        }
        try {
            NLParamParser nLParamParser = new NLParamParser(string, 1);
            this.tnsFiles.add(new TNSFile(string, file.lastModified(), nLParamParser));
            NVPair nVPair = nLParamParser.getNLPListElement("ifile");
            if (nVPair != null) {
                ArrayList<String> arrayList = this.getIFile(string);
                for (String string2 : arrayList) {
                    this.loadFiles(string2, n2 + 1);
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (NLException nLException) {
            // empty catch block
        }
    }

    private ArrayList<String> getIFile(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Matcher matcher = regexp.matcher("");
        ArrayList<String> arrayList = new ArrayList<String>(2);
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            matcher.reset(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(2);
            File file = new File(string3 = string3.trim());
            if (!file.isAbsolute()) {
                file = new File(this.tnsDir, string3);
                string3 = file.getAbsolutePath();
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void checkAndReload() throws NetException {
        long l2 = System.currentTimeMillis();
        if (l2 > this.nextPollTime) {
            this.nextPollTime = 0L;
            this.reloadFiles();
        }
    }

    private void reloadFiles() throws NetException {
        if (this.tnsFiles.isEmpty()) {
            this.loadFiles();
        } else {
            for (TNSFile tNSFile : this.tnsFiles) {
                long l2 = tNSFile.getLastModifiedTime();
                String string = tNSFile.getFileName();
                File file = new File(string);
                boolean bl = !file.isFile() || !file.canRead() || file.lastModified() != l2;
                if (!bl) continue;
                this.resetAttr();
                this.loadFiles();
                break;
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    static {
        try {
            $$$methodRef$$$8 = TNSNamesNamingAdapter.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TNSNamesNamingAdapter.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TNSNamesNamingAdapter.class.getDeclaredMethod("reloadFiles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TNSNamesNamingAdapter.class.getDeclaredMethod("checkAndReload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TNSNamesNamingAdapter.class.getDeclaredMethod("getIFile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TNSNamesNamingAdapter.class.getDeclaredMethod("loadFiles", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TNSNamesNamingAdapter.class.getDeclaredMethod("loadFiles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TNSNamesNamingAdapter.class.getDeclaredMethod("resolve", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TNSNamesNamingAdapter.class.getDeclaredMethod("resetAttr", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        regexp = Pattern.compile("^(IFILE\\s*=\\s*)(.*)", 2);
    }
}

