/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonFloatImpl
extends OracleJsonNumberImpl
implements OracleJsonFloat {
    private static String NAN;
    float value;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public OracleJsonFloatImpl(float f2) {
        this.value = f2;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.FLOAT;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonFloat)) {
            return false;
        }
        OracleJsonFloat oracleJsonFloat = (OracleJsonFloat)object;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(oracleJsonFloat.floatValue());
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public String getString() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return OracleJsonDecimalImpl.POSITIVE_INF;
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return OracleJsonDecimalImpl.NEGATIVE_INF;
        }
        if (Float.isNaN(this.value)) {
            return NAN;
        }
        return Float.toString(this.value);
    }

    @Override
    public BINARY_FLOAT getFLOAT() {
        return new BINARY_FLOAT(this.value);
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        if (Jsonp.isJakartaJson(clazz)) {
            return clazz.cast(new JakartaPrimitive.JakartaFloatImpl(this.value));
        }
        return clazz.cast(new JsonpPrimitive.JsonpFloatImpl(this.value));
    }

    static {
        try {
            $$$methodRef$$$8 = OracleJsonFloatImpl.class.getDeclaredConstructor(Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonFloatImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonFloatImpl.class.getDeclaredMethod("getFLOAT", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonFloatImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonFloatImpl.class.getDeclaredMethod("floatValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonFloatImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonFloatImpl.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonFloatImpl.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonFloatImpl.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NAN = "\"Nan\"";
    }
}

