/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int precision;
    int scale;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int n2) {
        super(n2);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l2, n2);
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readUnsignedByte();
        this.scale = tDSReader.readByte();
    }

    protected static Object unpickle81NativeArray(PickleContext pickleContext, long l2, int n2, int n3) throws SQLException {
        int n4 = 1;
        while ((long)n4 < l2 && n2 > 0) {
            pickleContext.skipDataValue();
            ++n4;
        }
        byte[] byArray = null;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    nArray[i2] = NUMBER.toInt(byArray);
                }
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    dArray[i3] = NUMBER.toDouble(byArray);
                }
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n2];
                for (int i4 = 0; i4 < n2; ++i4) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    lArray[i4] = NUMBER.toLong(byArray);
                }
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n2];
                for (int i5 = 0; i5 < n2; ++i5) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    fArray[i5] = NUMBER.toFloat(byArray);
                }
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n2];
                for (int i6 = 0; i6 < n2; ++i6) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    sArray[i6] = NUMBER.toShort(byArray);
                }
                return sArray;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(23).fillInStackTrace();
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n2, map);
    }

    static Object toNumericObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new NUMBER(byArray);
            }
            case 2: {
                return NUMBER.toBigDecimal(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(23).fillInStackTrace();
    }

    public static NUMBER toNUMBER(Object object, OracleConnection oracleConnection) throws SQLException {
        NUMBER nUMBER = null;
        if (object != null) {
            try {
                nUMBER = object instanceof NUMBER ? (NUMBER)object : new NUMBER(object);
            }
            catch (SQLException sQLException) {
                throw (SQLException)DatabaseError.createSqlException(59, object).fillInStackTrace();
            }
        }
        return nUMBER;
    }

    public static Datum[] toNUMBERArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = OracleTypeNUMBER.toNUMBER(objectArray[(int)l2 + i2 - 1], oracleConnection);
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(object, oracleConnection, l2, n2);
            }
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n3 = (int)(n2 == -1 ? (long)sArray.length : Math.min((long)sArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = new NUMBER(sArray[(int)l2 + i2 - 1]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n4 = (int)(n2 == -1 ? (long)nArray.length : Math.min((long)nArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    datumArray[i3] = new NUMBER(nArray[(int)l2 + i3 - 1]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n5 = (int)(n2 == -1 ? (long)lArray.length : Math.min((long)lArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n5];
                for (int i4 = 0; i4 < n5; ++i4) {
                    datumArray[i4] = new NUMBER(lArray[(int)l2 + i4 - 1]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n6 = (int)(n2 == -1 ? (long)fArray.length : Math.min((long)fArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n6];
                for (int i5 = 0; i5 < n6; ++i5) {
                    datumArray[i5] = new NUMBER(fArray[(int)l2 + i5 - 1]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n7 = (int)(n2 == -1 ? (long)dArray.length : Math.min((long)dArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n7];
                for (int i6 = 0; i6 < n7; ++i6) {
                    datumArray[i6] = new NUMBER(dArray[(int)l2 + i6 - 1]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n8 = (int)(n2 == -1 ? (long)blArray.length : Math.min((long)blArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n8];
                for (int i7 = 0; i7 < n8; ++i7) {
                    datumArray[i7] = new NUMBER((Object)blArray[(int)l2 + i7 - 1]);
                }
            } else if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n9 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n9];
                for (int i8 = 0; i8 < n9; ++i8) {
                    datumArray[i8] = new NUMBER(new String(cArray[(int)l2 + i8 - 1]));
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(59, object).fillInStackTrace();
            }
        }
        return datumArray;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.scale);
        objectOutputStream.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.scale = objectInputStream.readInt();
        this.precision = objectInputStream.readInt();
    }

    static {
        try {
            $$$methodRef$$$14 = OracleTypeNUMBER.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleTypeNUMBER.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleTypeNUMBER.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleTypeNUMBER.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleTypeNUMBER.class.getDeclaredMethod("getScale", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleTypeNUMBER.class.getDeclaredMethod("getPrecision", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleTypeNUMBER.class.getDeclaredMethod("cArrayToNUMBERArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeNUMBER.class.getDeclaredMethod("toNUMBERArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeNUMBER.class.getDeclaredMethod("toNUMBER", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeNUMBER.class.getDeclaredMethod("toNumericObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeNUMBER.class.getDeclaredMethod("toObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeNUMBER.class.getDeclaredMethod("unpickle81NativeArray", PickleContext.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeNUMBER.class.getDeclaredMethod("parseTDSrec", TDSReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeNUMBER.class.getDeclaredMethod("toDatumArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeNUMBER.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

