/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public final class TimeoutInterruptHandler {
    static Timer interruptTimer;
    static ConcurrentHashMap<Thread, InterruptTask> outboundTimerTasksHash;
    static ConcurrentHashMap<Thread, InterruptTask> soTimerTasksHash;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public static Timer getTimer() {
        return interruptTimer;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread, SocketChannel socketChannel) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        if (map.get(thread) != null) {
            throw new IllegalStateException("Interrupt task is already scheduled for the thread " + thread + " and the type " + (Object)((Object)interruptTaskType));
        }
        if (n2 <= 0) {
            return null;
        }
        InterruptTask interruptTask = new InterruptTask(thread, n2, socketChannel);
        interruptTimer.schedule((TimerTask)interruptTask, n2);
        map.put(Thread.currentThread(), interruptTask);
        return interruptTask;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread) {
        return TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, n2, thread, null);
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = map.remove(thread);
        if (interruptTask != null) {
            interruptTask.cancel();
            interruptTimer.purge();
        }
        return interruptTask;
    }

    public static boolean isInterruptScheduled(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        return map.get(thread) != null;
    }

    public static void resetTimer(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(interruptTaskType, thread);
        if (interruptTask != null) {
            if (interruptTask.isInterrupted) {
                Thread.interrupted();
            }
            TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, interruptTask.time, thread);
        }
    }

    private static Map<Thread, InterruptTask> getMap(InterruptTaskType interruptTaskType) {
        if (interruptTaskType.equals((Object)InterruptTaskType.OUTBOUND_TIMEOUT)) {
            return outboundTimerTasksHash;
        }
        return soTimerTasksHash;
    }

    public static void stopTimer() {
        interruptTimer.cancel();
    }

    static {
        try {
            $$$methodRef$$$8 = TimeoutInterruptHandler.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimeoutInterruptHandler.class.getDeclaredMethod("stopTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimeoutInterruptHandler.class.getDeclaredMethod("getMap", InterruptTaskType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimeoutInterruptHandler.class.getDeclaredMethod("resetTimer", InterruptTaskType.class, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimeoutInterruptHandler.class.getDeclaredMethod("isInterruptScheduled", InterruptTaskType.class, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimeoutInterruptHandler.class.getDeclaredMethod("cancelInterrupt", InterruptTaskType.class, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleInterrupt", InterruptTaskType.class, Integer.TYPE, Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeoutInterruptHandler.class.getDeclaredMethod("scheduleInterrupt", InterruptTaskType.class, Integer.TYPE, Thread.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeoutInterruptHandler.class.getDeclaredMethod("getTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        interruptTimer = new Timer("InterruptTimer", true);
        outboundTimerTasksHash = new ConcurrentHashMap();
        soTimerTasksHash = new ConcurrentHashMap();
    }

    public static class IOReadTimeoutException
    extends InterruptedIOException {
        private static final long serialVersionUID = 1L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        IOReadTimeoutException(String string) {
            super(string);
        }

        static {
            try {
                $$$methodRef$$$0 = IOReadTimeoutException.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class InterruptTask
    extends TimerTask {
        private final Thread threadTobeInteruppted;
        private boolean isInterrupted = false;
        private final int time;
        private final SocketChannel socketChannel;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public InterruptTask(Thread thread, int n2) {
            this.threadTobeInteruppted = thread;
            this.time = n2;
            this.socketChannel = null;
        }

        public InterruptTask(Thread thread, int n2, SocketChannel socketChannel) {
            this.threadTobeInteruppted = thread;
            this.time = n2;
            this.socketChannel = socketChannel;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        private void sendAttentionMarker() {
            if (this.socketChannel == null) {
                return;
            }
            try {
                this.socketChannel.socket().sendUrgentData(33);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.isInterrupted = true;
            this.sendAttentionMarker();
            this.threadTobeInteruppted.interrupt();
        }

        static {
            try {
                $$$methodRef$$$6 = InterruptTask.class.getDeclaredConstructor(Thread.class, Integer.TYPE, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = InterruptTask.class.getDeclaredConstructor(Thread.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = InterruptTask.class.getDeclaredMethod("access$100", InterruptTask.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = InterruptTask.class.getDeclaredMethod("access$000", InterruptTask.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = InterruptTask.class.getDeclaredMethod("run", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InterruptTask.class.getDeclaredMethod("sendAttentionMarker", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InterruptTask.class.getDeclaredMethod("isInterrupted", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static final class InterruptTaskType
    extends Enum<InterruptTaskType> {
        public static final /* enum */ InterruptTaskType SO_TIMEOUT;
        public static final /* enum */ InterruptTaskType OUTBOUND_TIMEOUT;
        private static final /* synthetic */ InterruptTaskType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static InterruptTaskType[] values() {
            return (InterruptTaskType[])$VALUES.clone();
        }

        public static InterruptTaskType valueOf(String string) {
            return Enum.valueOf(InterruptTaskType.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = InterruptTaskType.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InterruptTaskType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InterruptTaskType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            SO_TIMEOUT = new InterruptTaskType();
            OUTBOUND_TIMEOUT = new InterruptTaskType();
            $VALUES = new InterruptTaskType[]{SO_TIMEOUT, OUTBOUND_TIMEOUT};
        }
    }
}

