/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

@DefaultLogger(value="oracle.jdbc")
public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance;
    protected Hashtable m_connCache = new Hashtable();
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    protected static AtomicInteger UNNAMED_CACHE_COUNT;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sun_Aug_24_22:53:50_PDT_2025";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    private OracleConnectionCacheManager() {
        UNNAMED_CACHE_COUNT = new AtomicInteger();
    }

    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        try {
            if (cacheManagerInstance == null) {
                cacheManagerInstance = new OracleConnectionCacheManager();
            }
        }
        catch (RuntimeException runtimeException) {
        }
        return cacheManagerInstance;
    }

    public String createCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        String string = null;
        if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
        string = oracleDataSource.connCacheName != null ? oracleDataSource.connCacheName : oracleDataSource.dataSourceName + "#0x" + Integer.toHexString(UNNAMED_CACHE_COUNT.getAndIncrement());
        this.createCache(string, oracleDataSource, properties);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache(String string, OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        Object object;
        if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(138).fillInStackTrace();
        }
        if (this.m_connCache.containsKey(string)) {
            throw (SQLException)DatabaseError.createSqlException(140).fillInStackTrace();
        }
        boolean bl = oracleDataSource.getFastConnectionFailoverEnabled();
        if (bl && this.failoverEventHandlerThread == null) {
            object = oracleDataSource.getONSConfiguration();
            if (object != null && !((String)object).equals("")) {
                OracleConnectionCacheManager oracleConnectionCacheManager = this;
                synchronized (oracleConnectionCacheManager) {
                    if (!isONSInitializedForRemoteSubscription) {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                                final /* synthetic */ String val$onsConfigStr;
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    this.val$onsConfigStr = string;
                                }

                                public Object run() throws ONSException {
                                    ONS oNS = new ONS(this.val$onsConfigStr);
                                    return null;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleConnectionCacheManager.class, String.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                    try {
                                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (SQLException)DatabaseError.createSqlException(175, (Object)privilegedActionException).fillInStackTrace();
                        }
                        isONSInitializedForRemoteSubscription = true;
                    }
                }
            }
            this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
        }
        object = new OracleImplicitConnectionCache(oracleDataSource, properties);
        ((OracleImplicitConnectionCache)object).cacheName = string;
        oracleDataSource.odsCache = object;
        this.m_connCache.put(string, object);
        if (bl) {
            this.checkAndStartThread(this.failoverEventHandlerThread);
        }
    }

    public void removeCache(String string, long l2) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(string) : null;
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.disableConnectionCache();
            if (l2 > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(l2 * 1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (oracleImplicitConnectionCache.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.cleanupFCFThreads(oracleImplicitConnectionCache);
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oracleImplicitConnectionCache.closeConnectionCache(l2 < 0L ? 32 : 1);
        oracleImplicitConnectionCache = null;
    }

    public void reinitializeCache(String string, Properties properties) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        this.disableCache(string);
        oracleImplicitConnectionCache.reinitializeCacheConnections(properties);
        this.enableCache(string);
    }

    public boolean existsCache(String string) throws SQLException {
        return this.m_connCache.containsKey(string);
    }

    public void enableCache(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oracleImplicitConnectionCache.enableConnectionCache();
    }

    public void disableCache(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oracleImplicitConnectionCache.disableConnectionCache();
    }

    public void refreshCache(String string, int n2) throws SQLException {
        block4: {
            block3: {
                OracleImplicitConnectionCache oracleImplicitConnectionCache;
                OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
                if (oracleImplicitConnectionCache == null) break block3;
                switch (n2) {
                    case 4096: 
                    case 8192: {
                        oracleImplicitConnectionCache.refreshCacheConnections(n2);
                        break block4;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    }
                }
            }
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
    }

    public void purgeCache(String string, boolean bl) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oracleImplicitConnectionCache.purgeCacheConnections(bl, 1);
    }

    public Properties getCacheProperties(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.getConnectionCacheProperties();
        }
        throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
    }

    public String[] getCacheNameList() throws SQLException {
        String[] stringArray = this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
        return stringArray;
    }

    public int getNumberOfAvailableConnections(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.cacheSize;
        }
        throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
    }

    public int getNumberOfActiveConnections(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.getNumberOfCheckedOutConnections();
        }
        throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
    }

    public synchronized void setConnectionPoolDataSource(String string, ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache;
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
        if (oracleImplicitConnectionCache != null) {
            if (oracleImplicitConnectionCache.cacheSize > 0) {
                throw (SQLException)DatabaseError.createSqlException(78).fillInStackTrace();
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        ((OracleConnectionPoolDataSource)connectionPoolDataSource).makeURL();
        ((OracleConnectionPoolDataSource)connectionPoolDataSource).setURL(((OracleConnectionPoolDataSource)connectionPoolDataSource).url);
        oracleImplicitConnectionCache.connectionPoolDS = (OracleConnectionPoolDataSource)connectionPoolDataSource;
    }

    protected void verifyAndHandleEvent(int n2, byte[] byArray) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n3 = 0;
        StringTokenizer stringTokenizer = null;
        boolean bl = true;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        String string6 = null;
        String string7 = null;
        String string8 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string7 = null;
            string6 = stringTokenizer.nextToken();
            if (string6.equals("=") && stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken();
            } else {
                string8 = string6;
            }
            if (string8.equalsIgnoreCase("version") && string7 != null && !string7.startsWith("1.")) {
                bl = false;
            }
            if (string8.equalsIgnoreCase("service") && string7 != null) {
                string = string7;
            }
            if (string8.equalsIgnoreCase("instance") && string7 != null && !string7.equals(" ")) {
                string2 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("database") && string7 != null) {
                string3 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("host") && string7 != null) {
                string4 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("status") && string7 != null) {
                string5 = string7;
            }
            if (!string8.equalsIgnoreCase("card") || string7 == null) continue;
            try {
                n3 = Integer.parseInt(string7);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (bl) {
            this.invokeFailoverProcessingThreads(n2, string, string2, string3, string4, string5, n3);
        }
        stringTokenizer = null;
    }

    private void invokeFailoverProcessingThreads(int n2, String string, String string2, String string3, String string4, String string5, int n3) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == 256) {
            bl = true;
        }
        if (n2 == 512) {
            bl2 = true;
        }
        for (OracleImplicitConnectionCache oracleImplicitConnectionCache2 : this.m_connCache.values()) {
            if ((!bl || !string.equalsIgnoreCase(oracleImplicitConnectionCache2.dataSourceServiceName)) && !bl2) continue;
            OracleFailoverWorkerThread oracleFailoverWorkerThread = new OracleFailoverWorkerThread(oracleImplicitConnectionCache2, n2, string2, string3, string4, string5, n3);
            this.checkAndStartThread(oracleFailoverWorkerThread);
            oracleImplicitConnectionCache2.failoverWorkerThread = oracleFailoverWorkerThread;
        }
    }

    protected void checkAndStartThread(Thread thread) throws SQLException {
        try {
            if (!thread.isAlive()) {
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
    }

    protected boolean failoverEnabledCacheExists() {
        return this.failoverEnabledCacheCount > 0;
    }

    protected void parseRuntimeLoadBalancingEvent(String string, byte[] byArray) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        Enumeration enumeration = this.m_connCache.elements();
        while (enumeration.hasMoreElements()) {
            try {
                oracleImplicitConnectionCache = (OracleImplicitConnectionCache)enumeration.nextElement();
                if (!string.equalsIgnoreCase(oracleImplicitConnectionCache.dataSourceServiceName)) continue;
                if (byArray == null) {
                    oracleImplicitConnectionCache.zapRLBInfo();
                    continue;
                }
                this.retrieveServiceMetrics(oracleImplicitConnectionCache, byArray);
            }
            catch (Exception exception) {
            }
        }
    }

    private void retrieveServiceMetrics(OracleImplicitConnectionCache oracleImplicitConnectionCache, byte[] byArray) throws SQLException {
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = null;
            string3 = stringTokenizer.nextToken();
            if (string3.equals("=") && stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            } else {
                if (string3.equals("}")) {
                    if (!bl) continue;
                    oracleImplicitConnectionCache.updateDatabaseInstance(string2, string, n2, n3);
                    bl = false;
                    continue;
                }
                if (string3.equals("{") || string3.equals(" ")) continue;
                string5 = string3;
                bl = true;
            }
            if (string5.equalsIgnoreCase("version") && string4 != null && !string4.equals("1.0")) {
                throw (SQLException)DatabaseError.createSqlException(146).fillInStackTrace();
            }
            if (string5.equalsIgnoreCase("database") && string4 != null) {
                string2 = string4.toLowerCase().intern();
            }
            if (string5.equalsIgnoreCase("instance") && string4 != null) {
                string = string4.toLowerCase().intern();
            }
            if (string5.equalsIgnoreCase("percent") && string4 != null) {
                try {
                    n2 = Integer.parseInt(string4);
                    if (n2 == 0) {
                        n2 = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            if (!string5.equalsIgnoreCase("flag") || string4 == null) continue;
            if (string4.equalsIgnoreCase("good")) {
                n3 = 1;
                continue;
            }
            if (string4.equalsIgnoreCase("violating")) {
                n3 = 3;
                continue;
            }
            if (string4.equalsIgnoreCase("NO_DATA")) {
                n3 = 4;
                continue;
            }
            if (string4.equalsIgnoreCase("UNKNOWN")) {
                n3 = 2;
                continue;
            }
            if (!string4.equalsIgnoreCase("BLOCKED")) continue;
            n3 = 5;
        }
        oracleImplicitConnectionCache.processDatabaseInstances();
    }

    protected void cleanupFCFThreads(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.cleanupFCFWorkerThread(oracleImplicitConnectionCache);
        oracleImplicitConnectionCache.cleanupRLBThreads();
        if (this.failoverEnabledCacheCount <= 0) {
            this.cleanupFCFEventHandlerThread();
        }
        --this.failoverEnabledCacheCount;
    }

    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        if (oracleImplicitConnectionCache.failoverWorkerThread != null) {
            try {
                if (oracleImplicitConnectionCache.failoverWorkerThread.isAlive()) {
                    oracleImplicitConnectionCache.failoverWorkerThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            oracleImplicitConnectionCache.failoverWorkerThread = null;
        }
    }

    protected void cleanupFCFEventHandlerThread() throws SQLException {
        if (this.failoverEventHandlerThread != null) {
            try {
                this.failoverEventHandlerThread.interrupt();
            }
            catch (Exception exception) {
            }
            this.failoverEventHandlerThread = null;
        }
    }

    public boolean isFatalConnectionError(SQLException sQLException) {
        boolean bl = false;
        int n2 = sQLException.getErrorCode();
        if (n2 == 3113 || n2 == 3114 || n2 == 1033 || n2 == 1034 || n2 == 1089 || n2 == 1090 || n2 == 17002) {
            bl = true;
        }
        if (!bl && this.fatalErrorCodes != null) {
            for (int i2 = 0; i2 < this.fatalErrorCodes.length; ++i2) {
                if (n2 != this.fatalErrorCodes[i2]) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public synchronized void setConnectionErrorCodes(int[] nArray) throws SQLException {
        if (nArray != null) {
            this.fatalErrorCodes = nArray;
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        return this.fatalErrorCodes;
    }

    public Map getStatistics(String string) throws SQLException {
        Map map = null;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        if (this.m_connCache != null && (oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string)) != null) {
            map = oracleImplicitConnectionCache.getStatistics();
        }
        return map;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$30 = OracleConnectionCacheManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleConnectionCacheManager.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleConnectionCacheManager.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleConnectionCacheManager.class.getDeclaredMethod("getStatistics", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleConnectionCacheManager.class.getDeclaredMethod("getConnectionErrorCodes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleConnectionCacheManager.class.getDeclaredMethod("setConnectionErrorCodes", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleConnectionCacheManager.class.getDeclaredMethod("isFatalConnectionError", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleConnectionCacheManager.class.getDeclaredMethod("cleanupFCFEventHandlerThread", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleConnectionCacheManager.class.getDeclaredMethod("cleanupFCFWorkerThread", OracleImplicitConnectionCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleConnectionCacheManager.class.getDeclaredMethod("cleanupFCFThreads", OracleImplicitConnectionCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleConnectionCacheManager.class.getDeclaredMethod("retrieveServiceMetrics", OracleImplicitConnectionCache.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleConnectionCacheManager.class.getDeclaredMethod("parseRuntimeLoadBalancingEvent", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleConnectionCacheManager.class.getDeclaredMethod("failoverEnabledCacheExists", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleConnectionCacheManager.class.getDeclaredMethod("checkAndStartThread", Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleConnectionCacheManager.class.getDeclaredMethod("invokeFailoverProcessingThreads", Integer.TYPE, String.class, String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleConnectionCacheManager.class.getDeclaredMethod("verifyAndHandleEvent", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleConnectionCacheManager.class.getDeclaredMethod("setConnectionPoolDataSource", String.class, ConnectionPoolDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleConnectionCacheManager.class.getDeclaredMethod("getNumberOfActiveConnections", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleConnectionCacheManager.class.getDeclaredMethod("getNumberOfAvailableConnections", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleConnectionCacheManager.class.getDeclaredMethod("getCacheNameList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleConnectionCacheManager.class.getDeclaredMethod("getCacheProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleConnectionCacheManager.class.getDeclaredMethod("purgeCache", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleConnectionCacheManager.class.getDeclaredMethod("refreshCache", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConnectionCacheManager.class.getDeclaredMethod("disableCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConnectionCacheManager.class.getDeclaredMethod("enableCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConnectionCacheManager.class.getDeclaredMethod("existsCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConnectionCacheManager.class.getDeclaredMethod("reinitializeCache", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConnectionCacheManager.class.getDeclaredMethod("removeCache", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConnectionCacheManager.class.getDeclaredMethod("createCache", String.class, OracleDataSource.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConnectionCacheManager.class.getDeclaredMethod("createCache", OracleDataSource.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConnectionCacheManager.class.getDeclaredMethod("getConnectionCacheManagerInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        cacheManagerInstance = null;
        isONSInitializedForRemoteSubscription = false;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

