/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CInputStream
extends OracleInputStream {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    native int t2cGetBytes(long var1, int var3, byte[] var4, int var5, Accessor[] var6, Object[] var7, Object[] var8, long var9);

    T2CInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, n2, accessor);
    }

    private int getRowNumber() {
        int n2 = 0;
        if (this.statement.isFetchStreams) {
            if (this.statement instanceof T2CStatement) {
                if (((T2CStatement)this.statement).needToRetainRows) {
                    n2 = this.statement.storedRowCount;
                }
            } else if (this.statement instanceof T2CPreparedStatement) {
                if (((T2CPreparedStatement)this.statement).needToRetainRows) {
                    n2 = this.statement.storedRowCount;
                }
            } else if (((T2CCallableStatement)this.statement).needToRetainRows) {
                n2 = this.statement.storedRowCount;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    public int getBytes(int n2, byte[] byArray) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            long l2 = this.statement.connection.useNio ? 1 : 0;
            if (this.statement.connection.useNio) {
                if (this.statement.nioBuffers[3] == null || this.statement.nioBuffers[3].capacity() < byArray.length) {
                    this.statement.nioBuffers[3] = ByteBuffer.allocateDirect(byArray.length);
                } else {
                    this.statement.nioBuffers[3].rewind();
                }
            }
            int n3 = 0;
            n3 = this.t2cGetBytes(this.statement.c_state, this.columnIndex, byArray, this.currentBufferSize, this.statement.accessors, this.statement.nioBuffers, this.statement.lobPrefetchMetaData, l2);
            boolean bl = false;
            try {
                int n4 = this.getRowNumber();
                if (n3 == -1) {
                    ((T2CConnection)this.statement.connection).checkError(n3, this.statement.sqlWarning);
                } else if (n3 == -2) {
                    bl = true;
                    this.accessor.setNull(n4, true);
                    n3 = 0;
                } else if (n3 >= 0) {
                    this.accessor.setNull(n4, false);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            if (n3 <= 0) {
                n3 = -1;
                bl = true;
            }
            if (this.statement.connection.useNio) {
                ByteBuffer byteBuffer = this.statement.nioBuffers[3];
                if (byteBuffer != null && n3 > 0) {
                    byteBuffer.get(byArray, 0, n3);
                }
                if (bl) {
                    try {
                        this.statement.extractNioDefineBuffers(this.columnIndex);
                    }
                    catch (SQLException sQLException) {
                        throw new IOException(sQLException.getMessage());
                    }
                }
            }
            if (bl && this.statement.lobPrefetchMetaData != null) {
                this.statement.processLobPrefetchMetaData(this.statement.lobPrefetchMetaData);
            }
            return n3;
        }
    }

    @Override
    public boolean isNull() throws IOException {
        if (!this.statement.isFetchStreams) {
            this.needBytes();
            return super.isNull();
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$3 = T2CInputStream.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CInputStream.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CInputStream.class.getDeclaredMethod("getBytes", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CInputStream.class.getDeclaredMethod("getRowNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

