/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class OracleBufferedStream
extends InputStream {
    private final IntFunction<byte[]> allocateFunction;
    private final Consumer<byte[]> cacheFunction;
    private byte[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition = Integer.MAX_VALUE;
    boolean closed;
    OracleStatement statement;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    protected OracleBufferedStream(int n2) {
        this(n2, byte[]::new, byArray -> {});
    }

    protected OracleBufferedStream(OracleStatement oracleStatement, int n2) {
        this(n2, oracleStatement.connection::getByteBufferSync, oracleStatement.connection::cacheBufferSync);
        this.statement = oracleStatement;
    }

    protected OracleBufferedStream(int n2, IntFunction<byte[]> intFunction, Consumer<byte[]> consumer) {
        this.allocateFunction = intFunction;
        this.cacheFunction = consumer;
        this.pos = 0;
        this.count = 0;
        this.closed = false;
        this.initialBufferSize = n2;
        this.currentBufferSize = 0;
        this.resizableBuffer = null;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.releaseBuffer();
    }

    public boolean needBytes() throws IOException {
        return this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize));
    }

    public abstract boolean needBytes(int var1) throws IOException;

    public int flushBytes(int n2) {
        int n3 = n2 > this.count - this.pos ? this.count - this.pos : n2;
        this.pos += n3;
        return n3;
    }

    public int writeBytes(byte[] byArray, int n2, int n3) {
        int n4 = n3 > this.count - this.pos ? this.count - this.pos : n3;
        System.arraycopy(this.resizableBuffer, this.pos, byArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal();
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.readInternal();
        }
    }

    private final int readInternal() throws IOException {
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.resizableBuffer[this.pos++] & 0xFF;
        }
        this.releaseBuffer();
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal(byArray, n2, n3);
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.readInternal(byArray, n2, n3);
        }
    }

    private final int readInternal(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        if (this.closed || this.isNull()) {
            return -1;
        }
        int n5 = n3 > byArray.length ? n4 + byArray.length : n4 + n3;
        if (!this.needBytes(n3)) {
            this.releaseBuffer();
            return -1;
        }
        n4 += this.writeBytes(byArray, n4, n5 - n4);
        while (n4 < n5 && this.needBytes(n5 - n4)) {
            n4 += this.writeBytes(byArray, n4, n5 - n4);
        }
        return n4 - n2;
    }

    @Override
    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    @Override
    public void mark(int n2) {
    }

    @Override
    public void reset() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            throw new IOException(DatabaseError.findMessage(194, null));
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(int n2) throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.skipInternal(n2);
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.skipInternal(n2);
        }
    }

    private final int skipInternal(int n2) throws IOException {
        int n3;
        int n4 = n2;
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (!this.needBytes()) {
            this.releaseBuffer();
            return -1;
        }
        for (n3 = 0; n3 < n4 && this.needBytes(); n3 += this.flushBytes(n4 - n3)) {
        }
        return n3;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }

    protected final byte[] getBuffer(int n2) {
        if (this.resizableBuffer == null) {
            this.resizableBuffer = this.allocateFunction.apply(n2);
        } else if (this.resizableBuffer.length < n2) {
            this.cacheFunction.accept(this.resizableBuffer);
            this.resizableBuffer = this.allocateFunction.apply(n2);
        }
        return this.resizableBuffer;
    }

    private void releaseBuffer() {
        if (this.resizableBuffer != null) {
            this.cacheFunction.accept(this.resizableBuffer);
            this.resizableBuffer = null;
            this.currentBufferSize = 0;
        }
    }

    static {
        try {
            $$$methodRef$$$23 = OracleBufferedStream.class.getDeclaredConstructor(Integer.TYPE, IntFunction.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleBufferedStream.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleBufferedStream.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleBufferedStream.class.getDeclaredMethod("lambda$new$0", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleBufferedStream.class.getDeclaredMethod("lambda$new$1", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleBufferedStream.class.getDeclaredMethod("releaseBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleBufferedStream.class.getDeclaredMethod("getBuffer", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleBufferedStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleBufferedStream.class.getDeclaredMethod("skipInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleBufferedStream.class.getDeclaredMethod("skip", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleBufferedStream.class.getDeclaredMethod("markSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleBufferedStream.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleBufferedStream.class.getDeclaredMethod("mark", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleBufferedStream.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleBufferedStream.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleBufferedStream.class.getDeclaredMethod("readInternal", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleBufferedStream.class.getDeclaredMethod("read", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleBufferedStream.class.getDeclaredMethod("read", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleBufferedStream.class.getDeclaredMethod("readInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleBufferedStream.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleBufferedStream.class.getDeclaredMethod("writeBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleBufferedStream.class.getDeclaredMethod("flushBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleBufferedStream.class.getDeclaredMethod("needBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleBufferedStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

