/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.ABSTRACT_DATUM})
public abstract class DatumWithConnection
extends Datum
implements OracleDatumWithConnection {
    private oracle.jdbc.internal.OracleConnection physicalConnection;
    protected DatumWithConnection targetDatumWithConnection;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.targetDatumWithConnection != null) {
                oracle.jdbc.internal.OracleConnection oracleConnection = this.targetDatumWithConnection.getPhysicalConnection();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$0, this, oracleConnection);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$0, this, null);
                }
                return oracleConnection;
            }
            if (this.physicalConnection == null) {
                try {
                    this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.physicalConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$0, this, oracleConnection);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$0, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$10, null, new Object[]{byArray});
            }
            this.physicalConnection = null;
            this.targetDatumWithConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$10, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public DatumWithConnection() {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$11, null, new Object[0]);
            }
            this.physicalConnection = null;
            this.targetDatumWithConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$11, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void assertNotNull(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$1, null, connection);
            }
            if (connection == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68, "Connection is null").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$1, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$1, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$2, null, typeDescriptor);
            }
            if (typeDescriptor == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(61).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$2, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$2, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setPhysicalConnectionOf(Connection connection) {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$3, this, connection);
            }
            if (this.ojiOracleDatumWithConnection != null) {
                this.ojiOracleDatumWithConnection.setPhysicalConnectionOf(connection);
            } else if (this.targetDatumWithConnection != null) {
                this.targetDatumWithConnection.setPhysicalConnectionOf(connection);
            } else {
                this.physicalConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$3, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$4, this, new Object[0]);
            }
            if (this.ojiOracleDatumWithConnection != null) {
                Connection connection = this.ojiOracleDatumWithConnection.getJavaSqlConnection();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$4, this, connection);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$4, this, null);
                }
                return connection;
            }
            oracle.jdbc.OracleConnection oracleConnection = this.getPhysicalConnection().getWrapper();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$4, this, oracleConnection);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$4, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.ojiOracleDatumWithConnection != null) {
                oracle.jdbc.OracleConnection oracleConnection = this.ojiOracleDatumWithConnection.getOracleConnection();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$5, this, oracleConnection);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$5, this, null);
                }
                return oracleConnection;
            }
            oracle.jdbc.OracleConnection oracleConnection = this.getPhysicalConnection().getWrapper();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$5, this, oracleConnection);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$5, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.ojiOracleDatumWithConnection != null) {
                oracle.jdbc.internal.OracleConnection oracleConnection = this.ojiOracleDatumWithConnection.getInternalConnection();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$6, this, oracleConnection);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$6, this, null);
                }
                return oracleConnection;
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.getPhysicalConnection();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$6, this, oracleConnection);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$6, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleConnection getConnection() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x400000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (this.ojiOracleDatumWithConnection != null) {
                OracleConnection oracleConnection = this.ojiOracleDatumWithConnection.getConnection();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, oracleConnection);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, null);
                }
                return oracleConnection;
            }
            if (this.targetDatumWithConnection != null) {
                OracleConnection oracleConnection = this.targetDatumWithConnection.getConnection();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, oracleConnection);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, null);
                }
                return oracleConnection;
            }
            OracleConnection oracleConnection = null;
            try {
                oracleConnection = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
            }
            catch (ClassCastException classCastException) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(103).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            OracleConnection oracleConnection2 = oracleConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, oracleConnection2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, null);
            }
            return oracleConnection2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DatumWithConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getConnectionDuringExceptionHandling();
        }
        return this.physicalConnection;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    static {
        try {
            $$$methodRef$$$11 = DatumWithConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = DatumWithConnection.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = DatumWithConnection.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = DatumWithConnection.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = DatumWithConnection.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = DatumWithConnection.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = DatumWithConnection.class.getDeclaredMethod("getOracleConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = DatumWithConnection.class.getDeclaredMethod("getJavaSqlConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = DatumWithConnection.class.getDeclaredMethod("setPhysicalConnectionOf", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = DatumWithConnection.class.getDeclaredMethod("assertNotNull", TypeDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = DatumWithConnection.class.getDeclaredMethod("assertNotNull", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = DatumWithConnection.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

